/* 
   lparser.h
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   $Id: lparser.h,v 1.6 2001/07/25 17:03:09 reinhard Exp $
*/

#ifndef LPARSER_Y
#define LPARSER_Y

extern int current_pass;
extern odl_tree *yycurrenttree;

extern char *yytext;
#define SHOWTOKEN() printf( "token: %d %c (%s)\n" , yychar , (yychar<127?yychar:'?') , yytext )

extern unsigned int expecting_datatype;
extern unsigned int expecting_fieldprop;
extern unsigned int expect_triggertype;

int yylex (void);
int yywarn (char *msg, ...);
int yyerror (char *msg, ...);
int yymessage (char *msg, ...);
void yy_setfirstfilename (char *filename);
int yystartfile (char *filename);
void clear_file_history (void);
void errors_show_file (int state);
const char * yyget_current_filename (void);

extern struct _odl_container *yycurrent_container;

extern unsigned long int current_access;

#endif
