
%{

#include <glib.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "gcdparser.h"
#include "classdata.h"

      /* use the more useful verbose error messages */
#define YYERROR_VERBOSE 1
#define YYDEBUG 1

      /* defaults to everything public */
unsigned long int current_access = ODL_ACCESS_PUBLIC;

      /* from lparser.l */
#include "lparser.h"

      /* error checking function prototypes */
void dtype_unsigned_check( gboolean isunsigned , const char *datatype );

/*
int indent = 0;
void doindent (void)
{
  int i;
  for( i=0 ; i<indent ; i++ )
    {
      printf(" ");
    }
}
*/

struct _odl_container *yycurrent_container = NULL;
struct _odl_container *lastpushed = NULL;
struct _odl_container *beforefind = NULL;   /* used with find class to restore last position */

static gboolean is_a_type = FALSE;

%}

%union {
    char                  *string;
    signed long int        integer;
    unsigned long int      uint;
    gint64                 int64;
    gboolean               boolean;
    double                 floating;
    gboolean               bool_value;
    struct _odl_argument   *arg;
    GList                  *list;
    odl_item               *item;
    _odl_datatype          *datatype;
    odl_argument           *argument;
    _odl_datasource        *datasource;
};

%token UNSIGNED TRIGGERTYPE ENUM
%token LOOKUP LIST REFERENCE CALCULATED TRIGGER UNIQUE INDEX SINGLETON
%token CTYPE MODULE CLASS EXTEND PUBLIC PROTECTED PRIVATE FINAL ABSTRACT
%token NOT NUL READONLY ORDER BY DESC

%token <string>   SYMBOL DATATYPE STRING
%token <integer>  INTEGER
%token <floating> DOUBLE

%type <uint>       access opt_access opt_class_type
%type <string>     new_container_name new_field_name existing_class_name
%type <string>     qualified_name opt_format opt_default
%type <string>     existing_field_name
%type <string>     new_module_name new_class_name
%type <list>       enum_body parent_list search_fields
%type <list>       body_item class_body_item class_body opt_parent_list
%type <list>       new_field_list opt_argument_list argument_list
%type <list>       field_list source_field_list this_field_list
%type <list>       index_item_list
%type <item>       new_field method reference list lookup
%type <bool_value> opt_unsigned opt_unique
%type <datatype>   datatype
%type <argument>   argument
%type <datasource> reference_data_source list_data_source lookup_data_source
%type <uint>       opt_properties property properties
%type <boolean>    optdesc

%%

file: /* empty */  { yywarn("File is empty"); }
  |    unit_list
  ;

dt_on: /* dummy rule, modifies expecting_* */ { expecting_datatype=1; /*printf("on\n");*/ }
  ;

dt_off: /* dummy rule, modifies expecting_* */ { expecting_datatype=0; /*printf("off\n");*/ }
  ;
  
fp_on:  /* dummy rule, modifies expecting_* */ { expecting_fieldprop=1; /* printf("fld prop on\n"); */ }
  ;
  
fp_off: /* dummy rule, modifies expecting_* */ { expecting_fieldprop=0; /* printf("fld prop off\n");*/ }
  ;

             /* 'fake' rules to cause the tree to have items added */
push_module: /* */   {
                       if( current_pass == 1 ) {
                         odl_module *newone =
                             odl_new_module($<uint>-2,$<string>0);
                         newone->filename = g_strdup( yyget_current_filename() );
                         odl_container_insert_container( yycurrent_container ,
                                                  (odl_container *)newone );
                         newone->base.parent = (odl_base *)yycurrent_container;
                         yycurrent_container = newone;
                         /* doindent(); printf( "push module\n" ); indent+=4; */
                       }
                       else {
                           yycurrent_container = (odl_container *)
                               odl_find_in_container( (odl_base *)yycurrent_container,
                               $<string>0);
                       }
                       lastpushed = yycurrent_container;
                     }
  ;

pop_module:  /* */   {
                       if( current_pass == 1 ) {
                         /* printf( "pop_module:\n"); */
                         yycurrent_container = (odl_container *)
                             odl_container_get_parent(yycurrent_container);
                         /* indent-=4; doindent(); printf( "pop module\n" ); */
                       }
                       else {
                           yycurrent_container = (odl_container *)yycurrent_container->base.parent;
                       }
                     }
  ;
  
find_class:  /* */   {
                       odl_class * found_class = NULL;
                       found_class = odl_find_class ( yycurrenttree, $<string>0, NULL);
                                /* TODO fix extend must use fully qualified name */
                                /* odl_make_fullname_base( yycurrent_container, $<string>0)); */
                       if ( found_class != NULL)
                         {
                           beforefind = yycurrent_container;
                           yycurrent_container = found_class;
                         }
                       else
                         {
                           yyerror("Could not find class.");
                         }
                     }
  ;

unfind_class:  /* */ {
                       if( current_pass == 1 )
                         {
                           odl_class *c = NULL;
                           c = (odl_class *) yycurrent_container;
                           /* add stuff to class */
                           if ($<list>-1)
                             {
                               if (c->contents)
                                 {
                                   c->contents = g_list_concat (c->contents, $<list>-1);
                                 }
                               else
                                 {
                                   c->contents = $<list>-1;
                                 }
                             }
                         }
                       yycurrent_container = beforefind;
                     }
  ;

push_class:  /* */   {
                       if( current_pass == 1 )
                         {
                           odl_class *newone = NULL;
                           char * fullname = NULL;
                           odl_class *check_class = NULL;
                           /* printf( "push_class name: %s\n", $<list>-0); */
                           newone = odl_new_class($<uint>-4,$<string>0);
                           g_assert( newone );
                           newone->base.parent = (odl_base *)yycurrent_container;
                           newone->filename = g_strdup( yyget_current_filename() );
                           /* try to find a class with the same name   */
                           fullname = odl_make_fullname_base( (odl_base*) newone );
                           check_class = odl_find_class(yycurrenttree, fullname, NULL);
                           if (check_class != NULL)
                             {
                               yyerror( "Duplicate class name found." );
                             }
                           /* continue with creating class */
                           odl_container_insert_container( yycurrent_container ,
                                                         (odl_container *)newone );
                           yycurrent_container = newone;
                          /* doindent(); printf( "push class\n" ); indent += 4; */
                         }
                       else
                         {
                           yycurrent_container = (odl_container *)
                               odl_find_in_container( (odl_base *)yycurrent_container,
                               $<string>0);
                         }
                       lastpushed = yycurrent_container;
                     }
  ;

pop_class:   /* */    {
                        /* GList *l; */
                        odl_class *c = NULL;
                        if (current_pass == 1)
                          {
                                        /*
                                        odl_container * tmp;
                                        tmp = (odl_container *) yycurrent_container;
                                        printf( "pop_class current name: %s\n", tmp->base.name);
                                        */
                            c = (odl_class *) yycurrent_container;
                            yycurrent_container = (odl_container *)
                              odl_container_get_parent (yycurrent_container);
                                        /*
                                        tmp = (odl_container *) yycurrent_container;
                                        printf( "pop_class new name: %s\n", tmp->base.fullname);
                                        */
                                        /* indent-=4; doindent(); printf( "pop class\n" ); */
                                        /* add all the class's info to yycurrent_container */
                                        /* add fields in the class (any subclasses already added) */
                            if ($<list>-1)
                              {
                                if (c->contents)
                                  {
                                    c->contents = g_list_concat (c->contents, $<list>-1);
                                  }
                                else
                                  {
                                    c->contents = $<list>-1;
                                  }
                              }
                            /* add parents */
                            c->parents = $<list>-4;
                          }
                        else
                          {                           /* current_pass == 2 */
                            odl_standardise_parents ((odl_class *) yycurrent_container);
                            yycurrent_container =
                              (odl_container *) yycurrent_container->base.parent;
                          }
                      }
  ;

unit_list: unit
  |        unit_list unit
  ;
  
opt_access: /* */       { $$ = ODL_ACCESS_DEFAULT; current_access = ODL_ACCESS_DEFAULT; }
  |         access      { $$ = $1; current_access = $1; }

access:     PUBLIC      { $$ = ODL_ACCESS_PUBLIC;    current_access = $$; }
  |         PRIVATE     { $$ = ODL_ACCESS_PRIVATE;   current_access = $$; }
  |         PROTECTED   { $$ = ODL_ACCESS_PROTECTED; current_access = $$; }
  ;

opt_class_type: /* */        { $$ = ODL_CLASSTYPE_NORMAL;    }
  |             FINAL        { $$ = ODL_CLASSTYPE_FINAL;     }
  |             ABSTRACT     { $$ = ODL_CLASSTYPE_ABSTRACT;  }
  |             SINGLETON    { $$ = ODL_CLASSTYPE_SINGLETON; }
  ;

opt_unique: /* */           { $$ = FALSE; }
  |         UNIQUE dt_on    { $$ = TRUE;  }
  ;

opt_unsigned: /* */          { $$ = FALSE; }
  |           UNSIGNED dt_on { $$ = TRUE;  }
  ;

qualified_name: SYMBOL                        { $$ = $1; }
  |             qualified_name ':' ':' SYMBOL { $$ = g_strdup_printf("%s::%s",$1,$4); g_free($1); g_free($4); }
  ;

existing_class_name: qualified_name   { $$ = $1; }
  ;

new_container_name: SYMBOL   { $$ = $1; /*printf("[ (%s)\n",$1);*/ }
  ;

new_module_name: SYMBOL   {
                            odl_module * wanted = NULL;
                            wanted = odl_find_module( yycurrenttree, $1, 0);
                            /* printf("Looking for Module: %s, %p\n", $1, wanted); */
                            $$ = $1;
                            if ((wanted != NULL) && (current_pass == 1))
                              {
                                yyerror("Duplicate module name.");
                              }
                          }
  ;
  
new_class_name: SYMBOL    { /*printf("[ (%s)\n",$1);*/ 
                            $$ = $1;
                          }
  ;

new_field_name: SYMBOL fp_on { $$ = $1; }
  ;

existing_field_name: SYMBOL   { $$ = $1; }
  ;

unit: opt_access module    ';'  { is_a_type = FALSE; }
  |   opt_access class     ';'  { is_a_type = FALSE; }
  |   opt_access extend    ';'  { is_a_type = FALSE; }
  |   opt_access type      ';'  { is_a_type = TRUE;  }
  |   opt_access ENUM enum ';'  { is_a_type = FALSE; }
  ;

module: MODULE new_module_name push_module '{' dt_on unit_list '}' pop_module dt_on
  ;

class: opt_class_type CLASS dt_off new_class_name push_class opt_parent_list '{' dt_on class_body '}' pop_class dt_on {}
  ;

type: opt_class_type CTYPE dt_off new_class_name push_class opt_parent_list '{' dt_on class_body '}' pop_class dt_on { lastpushed->istype = TRUE; }
  ;

extend: EXTEND dt_off existing_class_name find_class '{' dt_on class_body '}' unfind_class dt_on {}
  ;

enum: new_container_name '{' enum_body  '}' dt_on {
                       if( current_pass == 1 )
                       {
                           odl_item *e = odl_new_enum( current_access , $1 );
                           if( e )
                           {
                               GList *l;
                               e->base.parent = (odl_base *)yycurrent_container;
                               l = $3;
                               while( l )
                               {
                                   odl_enum_add_element( e , l->data );
                                   l = g_list_next( l );
                               }

                               yycurrent_container->contents =
                               g_list_append( yycurrent_container->contents,
                                 e );
                           }
                       }
                       odl_namelist_free( $3 );
                   }
  ;

enum_body: SYMBOL               { $$ = g_list_append(NULL,$1); }
  |        enum_body ',' SYMBOL { $$ = g_list_append($1,$3);   }
  ;

opt_parent_list: /* */            { $$ = NULL; }
  |              ':' parent_list  { $$ = $2;   }
  ;

parent_list: existing_class_name                  { $$ = g_list_append(NULL,$1); }
  |          parent_list ',' existing_class_name  { $$ = g_list_append($1,$3); }
  ;

class_body: class_body_item            { $$ = $1; }
  |         class_body class_body_item {
                                          /* if 2 lists, concat them,
                                             otherwise pass both on
                                             otherwise an empty class */
                                          if( $1 && $2 ) {
                                             $$ = g_list_concat($1,$2);
                                          }
                                          else if( $1 != NULL ) {
                                             $$ = $1;
                                          }
                                          else if( $2 != NULL ) {
                                             $$ = $2;
                                          }
                                          else {
                                             $$ = $1;
                                          }
                                       }
  ;

class_body_item: access ':' dt_on         { current_access = $1; $$ = NULL; }
  |              body_item ';' dt_on      { $$ = $1; }
  ;

body_item: opt_access class               { $$ = NULL; /* already handled */ }
  |        opt_access type                { $$ = NULL; /* already handled */ }
  |        opt_unique INDEX index         { $$ = NULL; /* already handled */ }
  |        datatype new_field_list        { $$ = odl_reprocess_fields($1,$2); }
  |        datatype method                { $$ = g_list_append(NULL,set_method_datatype($1,$2));  }
  |        LOOKUP lookup                  { $$ = g_list_append(NULL,$2); }
  |        LIST list                      { $$ = g_list_append(NULL,$2); }
  |        REFERENCE reference            { $$ = g_list_append(NULL,$2); }
  |        CALCULATED calculated          { $$ = NULL; /* TODO */ }
  |        TRIGGER trigger                { $$ = NULL; /* TODO */ }
  |        READONLY readonly              { $$ = NULL; /* TODO */ }
  |        ENUM enum                      { $$ = NULL; /* already handled */ }
  |        ORDER dt_on BY orderby         { $$ = NULL; /* already handled */ }
  ;

index: '(' index_item_list ')' { if(current_pass == 2)
                                     odl_make_index(yycurrent_container,$<bool_value>-1,$2);
                                 else
                                     odl_namelist_free($2);
                               }
  ;

index_item_list: existing_field_name                      { $$ = g_list_append(NULL,$1); }
  |              index_item_list ',' existing_field_name  { $$ = g_list_append($1,$3); }
  ;

datatype: opt_unsigned DATATYPE            { $$ = alloc_odl_datatype($1,$2,-1,odl_datatype_id($2)); }
  |       ENUM qualified_name              { $$ = alloc_odl_datatype(FALSE,$2,-1,DT_enum); }
  |       qualified_name                   { $$ = alloc_odl_datatype(FALSE,$1,-1,DT_type); }
  |       qualified_name '*'               { $$ = alloc_odl_datatype(FALSE,$1,-1,DT_class); }
  |       qualified_name '[' ']'           { $$ = alloc_odl_datatype(FALSE,$1,0,DT_class); }
  |       qualified_name '[' INTEGER ']'   { $$ = alloc_odl_datatype(FALSE,$1,$3,DT_class); yyerror("Bounded lists are not yet supported."); }
  ;

opt_format: /* */                       { $$ = NULL; }
  |         '<' INTEGER             '>' { $$ = g_strdup_printf("%ld",$2); }
  |         '<' DOUBLE              '>' { $$ = g_strdup_printf("%f",$2); }
  |         '<' INTEGER ',' INTEGER '>' { $$ = g_strdup_printf("%ld,%ld",$2,$4); }
  |         '<' STRING              '>' { $$ = $2; }
  |         '<' INTEGER ',' STRING  '>' { $$ = g_strdup_printf("%ld,%s",$2,$4); g_free($4); }
  ;

opt_default: /* */        { $$ = NULL; }
  |          '=' STRING   { $$ = $2;   }
  |          '=' INTEGER  { $$ = g_strdup_printf("%ld",$2); }
  |          '=' DOUBLE   { $$ = g_strdup_printf("%f",$2); }
  |          '=' SYMBOL   { $$ = $2; }
  ;

property: NOT NUL { $$ = ODL_PROP_NOTNULL; }
  ;

properties: property             { $$ = $1; }
  |         properties property  { $$ = $1 | $2; }
  ;

opt_properties: /* */      { $$ = ODL_PROP_NONE; }
  |             properties { $$ = $1; }
  ;


new_field: new_field_name opt_format opt_default opt_properties fp_off {
               $$ = alloc_odl_item();
               if( $$ )
               {
                   $$->base.parent = (odl_base *)yycurrent_container;
                   $$->base.access = current_access;
                   $$->base.name   = $1;
                   $$->base.type   = IT_field;
                   $$->fieldtype   = FT_basic;
                   $$->format      = $2;
                   $$->defaultval  = $3;
                   $$->properties  = $4;
               }
           }
  ;

new_field_list: new_field                    { $$ = g_list_append(NULL,$1); }
  |             new_field_list ',' new_field { $$ = g_list_append($1,$3);   }
  ;

readonly: new_field_name fp_off ':' existing_field_name   {}
  ;

method: new_field_name fp_off '(' dt_on opt_argument_list ')' dt_off  {
              odl_item *i = alloc_odl_item();
              if( i )
              {
                  i->base.parent = (odl_base *)yycurrent_container;
                  i->base.type   = IT_field;
                  i->base.name   = $1;
                  i->base.access = current_access;
                  i->fieldtype   = FT_method;
                  i->arguments   = $5;
              }
              $$ = i;
          }
  ;

opt_argument_list: /* */           { $$ = NULL; }
  |                argument_list   { $$ = $1;   }
  ;

argument: datatype SYMBOL dt_on   { $$ = alloc_odl_argument();
                                    $$->name = $2;
                                    $$->datatype = $1->dt;
                                  }
  ;

argument_list: argument                    { $$ = g_list_append(NULL,$1); }
  |            argument_list ',' argument  { $$ = g_list_append($1,$3);   }
  ;

this: SYMBOL '.' { }
  ;

search_fields: this '(' this_field_list ')' { $$ = $3; }
  |            '(' this_field_list ')'      { $$ = $2; }
  |            this existing_field_name     { $$ = g_list_append(NULL,$2); }
  |            existing_field_name          { $$ = g_list_append(NULL,$1); }
  ;

field_list: qualified_name                     { $$ = g_list_append(NULL,$1); }
  |         field_list ',' qualified_name      { $$ = g_list_append($1,$3);   }
  ;

this_field_list: field_list   { $$ = $1; /* fields in THIS object */ }
  ;

source_field_list: field_list { $$ = $1; /* fields in class to load */ }
  ;

lookup_data_source: list_data_source '.' qualified_name {
               $$ = $1;
               $$->field = $3;
           }
  ;

reference_data_source:  qualified_name '(' source_field_list ')'  {
          _odl_datasource *d = alloc_odl_datasource();
          if( d )
          {
              d->classname = $1;
              d->fields = $3;
              d->field = NULL;
          }
          else yyerror( "Out of memory." );
          $$ = d;
      }
  ;

list_data_source:  qualified_name '(' source_field_list ')'   {
          _odl_datasource *d = alloc_odl_datasource();
          if( d )
          {
              d->classname = $1;
              d->fields = $3;
              d->field = NULL;
          }
          else yyerror( "Out of memory." );
          $$ = d;
      }
  ;

lookup: new_field_name fp_off ':' lookup_data_source '=' search_fields  {
            odl_item *i = alloc_odl_item();
            g_assert( i != NULL);
            if( i )
            {
                i->base.parent   = (odl_base *)yycurrent_container;
                i->base.type     = IT_field;
                i->base.name     = $1;
                i->base.access   = current_access;
                i->fieldtype     = FT_lookup;
                i->source_fields = $4->fields;
                i->this_fields   = $6;
                i->sourceclass   = $4->classname;
                i->sourcefield   = $4->field;

                $4->classname = NULL;
                $4->fields = NULL;
                $4->field  = NULL;
                free_odl_datasource($4);

                $$ = i;
            }
            else {
                yyerror("Out of memory.");
                $$ = NULL;
            }
        }
  ;

list: new_field_name fp_off ':' list_data_source '=' search_fields   {
            odl_item *i = NULL;
            
            if( current_pass == 1 )
              {
                i = alloc_odl_item();
                g_assert( i != NULL);
              }
            if( i )
              {
                i->base.parent   = (odl_base *)yycurrent_container;
                i->base.type     = IT_field;
                i->base.name     = $1;
                i->base.access   = current_access;
                i->fieldtype     = FT_list;
                i->source_fields = $4->fields;
                i->this_fields   = $6;
                i->sourceclass   = $4->classname;
                i->datatype      = DT_class;
                i->datatypeclass = g_strdup( i->sourceclass );

                $4->classname = NULL;
                $4->fields = NULL;
                free_odl_datasource($4);

                $$ = i;
              }
            else if( current_pass == 1 )
              {
                yyerror("Out of memory.");
                $$ = NULL;
              }
        }
  ;

reference: new_field_name fp_off ':' reference_data_source '=' search_fields   {
            odl_item *i = NULL;
            
            if( current_pass == 1 ) i = alloc_odl_item();
            if( i )
            {
                i->base.parent   = (odl_base *)yycurrent_container;
                i->base.type     = IT_field;
                i->base.name     = $1;
                i->base.access   = current_access;
                i->fieldtype     = FT_reference;
                i->source_fields = $4->fields;
                i->this_fields   = $6;
                i->sourceclass   = $4->classname;
                i->datatype      = DT_class;
                i->datatypeclass = g_strdup( i->sourceclass );

                $4->classname = NULL;
                $4->fields = NULL;
                free_odl_datasource($4);

                $$ = i;
            }
            else if( current_pass == 1 ) {
                yyerror("Out of memory.");
                $$ = NULL;
            }
        }
  ;

calculated: /* */
  ;

trigger: /* */
  ;

optdesc: /* */ { $$ = FALSE; }
  |      DESC  { $$ = TRUE;  }
  ;

orderby: SYMBOL dt_on optdesc dt_off  { if( yycurrent_container->orderby )
                                            g_free( yycurrent_container->orderby );
                                        yycurrent_container->orderby = $1;
					yycurrent_container->desc = $3;
                                      }
