/*
   GEAS configuration management library

   Copyright (C) 2001 Free Software Foundation

   This file is part of the GNU Enterprise Application Server (GEAS)

   GEAS is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   GEAS is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GEAS; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: configuration.h,v 1.6 2001/05/29 23:02:29 reinhard Exp $
*/

/*
 * This library is an API for GEAS to use to read configuration details.
 * the internals are subject to change at any time, and will be what
 * defines how the config data is stored
 * 
 */

#ifndef _CONFIGURATION_H
#define _CONFIGURATION_H

#include <glib.h>

/* handle to configuration data */
typedef void *configuration;

extern configuration configdata;

#define NO_CONFIGURATION NULL

/* load/release configuration files */
configuration load_configuration_file (const char *filename,
                                       const char *shadowpwfile);
void          free_configuration (configuration config);

/* display current config */
void          show_configuration (configuration config,
                                  gboolean show_passwords);

/* track databases in the file */
int           count_configured_databases (configuration config);
const char   *get_database_name (configuration config, int index);

/* global configuration */
const char   *get_global_option (configuration config, const char *key);
const char   *get_global_option_str (configuration config, const char *key,
                                     const char *defaultval);
int           get_global_option_int (configuration config, const char *key,
                                     int defaultval);
gboolean      get_global_option_bool (configuration config, const char *key,
                                      gboolean defaultval);

/* find configuration item for a particular database */
const char   *get_database_option (configuration tree,
                                   const char *databasename, const char *key);
gboolean      get_database_option_bool (configuration tree,
                                        const char *databasename,
                                        const char *key, gboolean defaultval);
int           get_database_option_int (configuration tree,
                                       const char *databasename,
                                       const char *key, int defaultval);
const char   *get_database_option_str (configuration tree,
                                       const char *databasename,
                                       const char *key,
                                       const char *defaultvalue);

/* HACK - temporary function, until multiple databases are supported */
const char   *get_first_active_database (configuration tree);

#endif /* configuration.h */
