/* gEDA - GPL Electronic Design Automation
 * gschem - gEDA Schematic Capture
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */


/* DO NOT read or edit this file ! Use ../noweb/g_register.nw instead */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/prototype.h"

void g_register_funcs(void)
{
  /* rc file */
  gh_new_procedure1_0("gschem-version", g_rc_gschem_version);

  gh_new_procedure("override-net-color", g_rc_override_net_color, 7, 0, 0);
  gh_new_procedure("override-bus-color", g_rc_override_bus_color, 7, 0, 0);
  gh_new_procedure("override-pin-color", g_rc_override_pin_color, 7, 0, 0);
  gh_new_procedure("attribute-color", g_rc_attribute_color, 7, 0, 0);
  gh_new_procedure("detached-attribute-color", g_rc_detachedattr_color,
		   7, 0, 0);
  gh_new_procedure("text-color", g_rc_text_color, 7, 0, 0);
  gh_new_procedure("logic-bubble-color", g_rc_logic_bubble_color, 7, 0, 0);
  gh_new_procedure("lock-color", g_rc_lock_color, 7, 0, 0);
  gh_new_procedure("zoom-box-color", g_rc_zoom_box_color, 7, 0, 0);
  gh_new_procedure("net-color", g_rc_net_color, 7, 0, 0);
  gh_new_procedure("bus-color", g_rc_bus_color, 7, 0, 0);
  gh_new_procedure("pin-color", g_rc_pin_color, 7, 0, 0);
  gh_new_procedure("graphic-color", g_rc_graphic_color, 7, 0, 0);
  gh_new_procedure("grid-color", g_rc_grid_color, 7, 0, 0);
  gh_new_procedure("background-color", g_rc_background_color, 7, 0, 0);
  gh_new_procedure("select-color", g_rc_select_color, 7, 0, 0);
  gh_new_procedure("boundingbox-color", g_rc_boundingbox_color, 7, 0, 0);
  gh_new_procedure("net-endpoint-color", g_rc_net_endpoint_color, 7, 0, 0);
  gh_new_procedure("stroke-color", g_rc_stroke_color, 7, 0, 0);
  gh_new_procedure("output-color-background", g_rc_output_color_background,
		   7, 0, 0);
  gh_new_procedure("freestyle-color", g_rc_freestyle_color, 7, 0, 0);


  gh_new_procedure1_0("net-endpoint-mode", g_rc_net_endpoint_mode);
  gh_new_procedure1_0("net-midpoint-mode", g_rc_net_midpoint_mode);
  gh_new_procedure1_0("net-style", g_rc_net_style);
  gh_new_procedure1_0("bus-style", g_rc_bus_style);
  gh_new_procedure1_0("pin-style", g_rc_pin_style);
  gh_new_procedure1_0("zoom-with-pan", g_rc_zoom_with_pan);
  gh_new_procedure1_0("action-feedback-mode", g_rc_action_feedback_mode);
  gh_new_procedure1_0("text-feedback", g_rc_text_feedback);
  gh_new_procedure1_0("text-display-zoomfactor",
		      g_rc_text_display_zoomfactor);
  gh_new_procedure1_0("scrollbars", g_rc_scrollbars);
  gh_new_procedure1_0("scrollbar-update", g_rc_scrollbar_update);
  gh_new_procedure1_0("object-clipping", g_rc_object_clipping);
  gh_new_procedure1_0("embed-components", g_rc_embed_components);
  gh_new_procedure1_0("logging", g_rc_logging);
  gh_new_procedure1_0("text-size", g_rc_text_size);
  gh_new_procedure1_0("snap-size", g_rc_snap_size);

  gh_new_procedure1_0("text-caps-style", g_rc_text_caps_style);
  gh_new_procedure1_0("logging-destination", g_rc_logging_destination);
  gh_new_procedure1_0("default-series-name", g_rc_default_series_name);
  gh_new_procedure1_0("untitled-name", g_rc_untitled_name);
  gh_new_procedure1_0("component-library", g_rc_component_library);
  gh_new_procedure1_0("component-library-search",
		      g_rc_component_library_search);
  gh_new_procedure1_0("source-library", g_rc_source_library);
  gh_new_procedure1_0("source-library-search", g_rc_source_library_search);
  gh_new_procedure1_0("attribute-name", g_rc_attribute_name);
  gh_new_procedure1_0("scheme-directory", g_rc_scheme_directory);
  /* gh_new_procedure2_0 ("stroke", g_rc_stroke); old way */
  gh_new_procedure1_0("font-directory", g_rc_font_directory);
  gh_new_procedure3_0("world-size", g_rc_world_size);
  gh_new_procedure2_0("paper-size", g_rc_paper_size);
  gh_new_procedure3_0("paper-sizes", g_rc_paper_sizes);
  /* text-output is old... will eventually be removed! */
  gh_new_procedure1_0("text-output", g_rc_output_text);
  gh_new_procedure1_0("output-text", g_rc_output_text);
  gh_new_procedure1_0("output-type", g_rc_output_type);
  gh_new_procedure1_0("output-orientation", g_rc_output_orientation);
  gh_new_procedure1_0("output-color", g_rc_output_color);
  gh_new_procedure1_0("output-capstyle", g_rc_output_capstyle);
  gh_new_procedure1_0("image-color", g_rc_image_color);
  gh_new_procedure1_0("log-window", g_rc_log_window);
  gh_new_procedure1_0("log-window-type", g_rc_log_window_type);
  gh_new_procedure1_0("third-button", g_rc_third_button);
  gh_new_procedure1_0("middle-button", g_rc_middle_button);
  gh_new_procedure1_0("net-consolidate", g_rc_net_consolidate);
  gh_new_procedure1_0("file-preview", g_rc_file_preview);
  gh_new_procedure1_0("enforce-hierarchy", g_rc_enforce_hierarchy);
  gh_new_procedure1_0("text-origin-marker", g_rc_text_origin_marker);
  gh_new_procedure1_0("fast-mousepan", g_rc_fast_mousepan);
  gh_new_procedure1_0("raise-dialog-boxes-on-expose",
		      g_rc_raise_dialog_boxes_on_expose);
  gh_new_procedure1_0("attribute-promotion", g_rc_attribute_promotion);
  gh_new_procedure1_0("promote-invisible", g_rc_promote_invisible);
  gh_new_procedure1_0("keep-invisible", g_rc_keep_invisible);
  gh_new_procedure1_0("continue-component-place",
		      g_rc_continue_component_place);
  gh_new_procedure1_0("undo-levels", g_rc_undo_levels);
  gh_new_procedure1_0("undo-control", g_rc_undo_control);
  gh_new_procedure1_0("undo-type", g_rc_undo_type);

  gh_new_procedure1_0("draw-grips", g_rc_draw_grips);
  gh_new_procedure1_0("netconn-rubberband", g_rc_netconn_rubberband);
  gh_new_procedure1_0("sort-component-library",
		      g_rc_sort_component_library);
  gh_new_procedure2_0("add-menu", g_rc_add_menu);

  /* general guile functions */
  gh_new_procedure1_0("gschem-print", g_funcs_print);
  gh_new_procedure1_0("gschem-key-name", g_funcs_key_name);
  gh_new_procedure1_0("gschem-key-value", g_funcs_key_value);
  gh_new_procedure0_0("gschem-key-done", g_funcs_key_done);
  gh_new_procedure0_0("gschem-use-rc-values", g_funcs_use_rc_values);
  gh_new_procedure0_0("gschem-exit", g_funcs_exit);

  /* keymapping callbacks */
  gh_new_procedure0_0("file-new-window", g_key_file_new_window);
  gh_new_procedure0_0("file-new", g_key_file_new);
  gh_new_procedure0_0("file-open", g_key_file_open);
  gh_new_procedure0_0("file-script", g_key_file_script);
  gh_new_procedure0_0("file-save", g_key_file_save);
  gh_new_procedure0_0("file-save-as", g_key_file_save_as);
  gh_new_procedure0_0("file-save-all", g_key_file_save_all);
  gh_new_procedure0_0("file-print", g_key_file_print);
  gh_new_procedure0_0("file-image", g_key_file_write_png);
  gh_new_procedure0_0("file-close-window", g_key_file_close);
  gh_new_procedure0_0("file-quit", g_key_file_quit);
  gh_new_procedure0_0("edit-undo", g_key_edit_undo);
  gh_new_procedure0_0("edit-redo", g_key_edit_redo);
  gh_new_procedure0_0("edit-select", g_key_edit_select);
  gh_new_procedure0_0("edit-copy", g_key_edit_copy);
  gh_new_procedure0_0("edit-copy-hotkey", g_key_edit_copy_hotkey);
  gh_new_procedure0_0("edit-move", g_key_edit_move);
  gh_new_procedure0_0("edit-move-hotkey", g_key_edit_move_hotkey);
  gh_new_procedure0_0("edit-delete", g_key_edit_delete);
  gh_new_procedure0_0("edit-rotate-90", g_key_edit_rotate_90);
  gh_new_procedure0_0("edit-rotate-90-hotkey",
		      g_key_edit_rotate_90_hotkey);
  gh_new_procedure0_0("edit-mirror", g_key_edit_mirror);
  gh_new_procedure0_0("edit-mirror-hotkey", g_key_edit_mirror_hotkey);
#if 0				/* Obsolete */
  gh_new_procedure0_0("edit-stretch", g_key_edit_stretch);
  gh_new_procedure0_0("edit-stretch-hotkey", g_key_edit_stretch_hotkey);
#endif
  gh_new_procedure0_0("edit-slot", g_key_edit_slot);
  gh_new_procedure0_0("edit-color", g_key_edit_color);
  gh_new_procedure0_0("edit-edit", g_key_edit_edit);
  gh_new_procedure0_0("edit-text", g_key_edit_text);
  gh_new_procedure0_0("edit-lock", g_key_edit_lock);
  gh_new_procedure0_0("edit-unlock", g_key_edit_unlock);
  gh_new_procedure0_0("edit-linetype", g_key_edit_linetype);
  gh_new_procedure0_0("edit-filltype", g_key_edit_filltype);
  gh_new_procedure0_0("edit-translate", g_key_edit_translate);
  gh_new_procedure0_0("edit-embed", g_key_edit_embed);
  gh_new_procedure0_0("edit-unembed", g_key_edit_unembed);
  gh_new_procedure0_0("edit-show-hidden", g_key_edit_show_hidden);

  gh_new_procedure0_0("buffer-copy1", g_key_buffer_copy1);
  gh_new_procedure0_0("buffer-copy2", g_key_buffer_copy2);
  gh_new_procedure0_0("buffer-copy3", g_key_buffer_copy3);
  gh_new_procedure0_0("buffer-copy4", g_key_buffer_copy4);
  gh_new_procedure0_0("buffer-copy5", g_key_buffer_copy5);
  gh_new_procedure0_0("buffer-cut1", g_key_buffer_cut1);
  gh_new_procedure0_0("buffer-cut2", g_key_buffer_cut2);
  gh_new_procedure0_0("buffer-cut3", g_key_buffer_cut3);
  gh_new_procedure0_0("buffer-cut4", g_key_buffer_cut4);
  gh_new_procedure0_0("buffer-cut5", g_key_buffer_cut5);
  gh_new_procedure0_0("buffer-paste1", g_key_buffer_paste1);
  gh_new_procedure0_0("buffer-paste2", g_key_buffer_paste2);
  gh_new_procedure0_0("buffer-paste3", g_key_buffer_paste3);
  gh_new_procedure0_0("buffer-paste4", g_key_buffer_paste4);
  gh_new_procedure0_0("buffer-paste5", g_key_buffer_paste5);
  gh_new_procedure0_0("buffer-paste1-hotkey", g_key_buffer_paste1_hotkey);
  gh_new_procedure0_0("buffer-paste2-hotkey", g_key_buffer_paste2_hotkey);
  gh_new_procedure0_0("buffer-paste3-hotkey", g_key_buffer_paste3_hotkey);
  gh_new_procedure0_0("buffer-paste4-hotkey", g_key_buffer_paste4_hotkey);
  gh_new_procedure0_0("buffer-paste5-hotkey", g_key_buffer_paste5_hotkey);

  gh_new_procedure0_0("view-redraw", g_key_view_redraw);
  gh_new_procedure0_0("view-zoom-full", g_key_view_zoom_full);
  gh_new_procedure0_0("view-zoom-extents", g_key_view_zoom_extents);
  gh_new_procedure0_0("view-zoom-in", g_key_view_zoom_in);
  gh_new_procedure0_0("view-zoom-out", g_key_view_zoom_out);
  gh_new_procedure0_0("view-zoom-in-hotkey", g_key_view_zoom_in_hotkey);
  gh_new_procedure0_0("view-zoom-out-hotkey", g_key_view_zoom_out_hotkey);
  gh_new_procedure0_0("view-zoom-box", g_key_view_zoom_box);
  gh_new_procedure0_0("view-zoom-box-hotkey", g_key_view_zoom_box_hotkey);
  gh_new_procedure0_0("view-pan", g_key_view_pan);
  gh_new_procedure0_0("view-pan-hotkey", g_key_view_pan_hotkey);
  gh_new_procedure0_0("view-update-cues", g_key_view_update_cues);
  gh_new_procedure0_0("page-manager", g_key_page_manager);
  gh_new_procedure0_0("page-next", g_key_page_next);
  gh_new_procedure0_0("page-prev", g_key_page_prev);
  gh_new_procedure0_0("page-new", g_key_page_new);
  gh_new_procedure0_0("page-close", g_key_page_close);
  gh_new_procedure0_0("page-revert", g_key_page_revert);
  gh_new_procedure0_0("page-discard", g_key_page_discard);
  gh_new_procedure0_0("page-print", g_key_page_print);
  gh_new_procedure0_0("add-component", g_key_add_component);
  gh_new_procedure0_0("add-attribute", g_key_add_attribute);
  gh_new_procedure0_0("add-attribute-hotkey", g_key_add_attribute_hotkey);
  gh_new_procedure0_0("add-net", g_key_add_net);
  gh_new_procedure0_0("add-net-hotkey", g_key_add_net_hotkey);
  gh_new_procedure0_0("add-bus", g_key_add_bus);
  gh_new_procedure0_0("add-bus-hotkey", g_key_add_bus_hotkey);
  gh_new_procedure0_0("add-text", g_key_add_text);
  gh_new_procedure0_0("add-line", g_key_add_line);
  gh_new_procedure0_0("add-line-hotkey", g_key_add_line_hotkey);
  gh_new_procedure0_0("add-box", g_key_add_box);
  gh_new_procedure0_0("add-box-hotkey", g_key_add_box_hotkey);
  gh_new_procedure0_0("add-circle", g_key_add_circle);
  gh_new_procedure0_0("add-circle-hotkey", g_key_add_circle_hotkey);
  gh_new_procedure0_0("add-arc", g_key_add_arc);
  gh_new_procedure0_0("add-arc-hotkey", g_key_add_arc_hotkey);
  gh_new_procedure0_0("add-pin", g_key_add_pin);
  gh_new_procedure0_0("add-pin-hotkey", g_key_add_pin_hotkey);
  gh_new_procedure0_0("hierarchy-down-schematic",
		      g_key_hierarchy_down_schematic);
  gh_new_procedure0_0("hierarchy-down-symbol",
		      g_key_hierarchy_down_symbol);
  gh_new_procedure0_0("hierarchy-up", g_key_hierarchy_up);
  gh_new_procedure0_0("attributes-attach", g_key_attributes_attach);
  gh_new_procedure0_0("attributes-detach", g_key_attributes_detach);
  gh_new_procedure0_0("attributes-show-name", g_key_attributes_show_name);
  gh_new_procedure0_0("attributes-show-value",
		      g_key_attributes_show_value);
  gh_new_procedure0_0("attributes-show-both", g_key_attributes_show_both);
  gh_new_procedure0_0("attributes-visibility-toggle",
		      g_key_attributes_visibility_toggle);
  gh_new_procedure0_0("options-text-size", g_key_options_text_size);
  gh_new_procedure0_0("options-snap-size", g_key_options_snap_size);
  gh_new_procedure0_0("options-action-feedback", g_key_options_afeedback);
  gh_new_procedure0_0("options-grid", g_key_options_grid);
  gh_new_procedure0_0("options-snap", g_key_options_snap);
  gh_new_procedure0_0("options-rubberband", g_key_options_rubberband);
  gh_new_procedure0_0("options-show-log-window",
		      g_key_options_show_log_window);
  gh_new_procedure0_0("options-show-coord-window",
		      g_key_options_show_coord_window);
  gh_new_procedure0_0("help-about", g_key_help_about);
  gh_new_procedure0_0("help-hotkeys", g_key_help_hotkeys);
  gh_new_procedure0_0("misc-misc", g_key_misc);
  gh_new_procedure0_0("misc-misc2", g_key_misc2);
  gh_new_procedure0_0("misc-misc3", g_key_misc3);
  gh_new_procedure0_0("cancel", g_key_cancel);

  g_init_attrib_smob();

  /* Hook stuff */
  scm_make_gsubr("set-attribute-value!", 2, 0, 0, g_set_attrib_value_x);
  add_component_hook = scm_create_hook("add-component-hook", 1);
  copy_component_hook = scm_create_hook("copy-component-hook", 1);
  move_component_hook = scm_create_hook("move-component-hook", 1);

  /*help functions for generating netlists */
  gh_new_procedure0_0("get-selected-filename", g_get_selected_filename);
  gh_new_procedure0_0("get-selected-component-attributes",
		      g_get_selected_component_attributes);


  return;
}
