static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2005 Øyvind Kolås <pippin@gimp.org>,                           \n"
" *           2007 Øyvind Kolås <oeyvindk@hig.no>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (blur_radius, _(\"Blur radius\"), 4.0)                        \n"
"  description(_(\"Radius of square pixel region, (width and height will be radius*2+1).\"))\n"
"  value_range   (0.0, 1000.0)                                                 \n"
"  ui_range      (0.0, 100.0)                                                  \n"
"  ui_gamma      (1.5)                                                         \n"
"                                                                              \n"
"property_double (edge_preservation, _(\"Edge preservation\"), 8.0)            \n"
"  description   (_(\"Amount of edge preservation\"))                          \n"
"  value_range   (0.0, 100.0)                                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE bilateral-filter.c                                   \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"bilateral_filter (GeglBuffer          *src,                                   \n"
"                  const GeglRectangle *src_rect,                              \n"
"                  GeglBuffer          *dst,                                   \n"
"                  const GeglRectangle *dst_rect,                              \n"
"                  gdouble              radius,                                \n"
"                  gdouble              preserve);                             \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties              *o = GEGL_PROPERTIES (operation);               \n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom = ceil (o->blur_radius);\n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/bilateral-filter.cl.h\"                                     \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_bilateral_filter (cl_mem                in_tex,                            \n"
"                     cl_mem                out_tex,                           \n"
"                     size_t                global_worksize,                   \n"
"                     const GeglRectangle  *roi,                               \n"
"                     gfloat                radius,                            \n"
"                     gfloat                preserve)                          \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  size_t global_ws[2];                                                        \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"bilateral_filter\", NULL};               \n"
"      cl_data = gegl_cl_compile_and_build (bilateral_filter_cl_source, kernel_name);\n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  global_ws[0] = roi->width;                                                  \n"
"  global_ws[1] = roi->height;                                                 \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_float), (void*)&radius);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float), (void*)&preserve);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                       cl_data->kernel[0], 2,                 \n"
"                                       NULL, global_ws, NULL,                 \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err;                                                                   \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err) return FALSE;                                                  \n"
"                                                                              \n"
"      err = cl_bilateral_filter(i->tex[read],                                 \n"
"                                i->tex[0],                                    \n"
"                                i->size[0],                                   \n"
"                                &i->roi[0],                                   \n"
"                                ceil(o->blur_radius),                         \n"
"                                o->edge_preservation);                        \n"
"                                                                              \n"
"      if (err) return FALSE;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle compute;                                                      \n"
"                                                                              \n"
"  if (o->blur_radius >= 1.0 && gegl_operation_use_opencl (operation))         \n"
"    if (cl_process (operation, input, output, result))                        \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  compute = gegl_operation_get_required_for_output (operation, \"input\",result);\n"
"                                                                              \n"
"  if (o->blur_radius < 1.0)                                                   \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, result, GEGL_ABYSS_NONE,                       \n"
"                        output, result);                                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      bilateral_filter (input, &compute, output, result, o->blur_radius, o->edge_preservation);\n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"bilateral_filter (GeglBuffer          *src,                                   \n"
"                  const GeglRectangle *src_rect,                              \n"
"                  GeglBuffer          *dst,                                   \n"
"                  const GeglRectangle *dst_rect,                              \n"
"                  gdouble              radius,                                \n"
"                  gdouble              preserve)                              \n"
"{                                                                             \n"
"  gfloat *gauss;                                                              \n"
"  gint x,y;                                                                   \n"
"  gint offset;                                                                \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"  gint width = (gint) radius * 2 + 1;                                         \n"
"  gint iradius = radius;                                                      \n"
"  gint src_width = src_rect->width;                                           \n"
"  gint src_height = src_rect->height;                                         \n"
"                                                                              \n"
"  gauss = g_newa (gfloat, width * width);                                     \n"
"  src_buf = g_new0 (gfloat, src_rect->width * src_rect->height * 4);          \n"
"  dst_buf = g_new0 (gfloat, dst_rect->width * dst_rect->height * 4);          \n"
"                                                                              \n"
"  gegl_buffer_get (src, src_rect, 1.0, babl_format (\"RGBA float\"), src_buf, GEGL_AUTO_ROWSTRIDE,\n"
"                   GEGL_ABYSS_NONE);                                          \n"
"                                                                              \n"
"  offset = 0;                                                                 \n"
"                                                                              \n"
"#define POW2(a) ((a)*(a))                                                     \n"
"  for (y=-iradius;y<=iradius;y++)                                             \n"
"    for (x=-iradius;x<=iradius;x++)                                           \n"
"      {                                                                       \n"
"        gauss[x+(int)radius + (y+(int)radius)*width] = exp(- 0.5*(POW2(x)+POW2(y))/radius   );\n"
"      }                                                                       \n"
"                                                                              \n"
"  for (y=0; y<dst_rect->height; y++)                                          \n"
"    for (x=0; x<dst_rect->width; x++)                                         \n"
"      {                                                                       \n"
"        gint u,v;                                                             \n"
"        gfloat *center_pix = src_buf + ((x+iradius)+((y+iradius) * src_width)) * 4;\n"
"        gfloat  accumulated[4]={0,0,0,0};                                     \n"
"        gfloat  count=0.0;                                                    \n"
"                                                                              \n"
"        for (v=-iradius;v<=iradius;v++)                                       \n"
"          for (u=-iradius;u<=iradius;u++)                                     \n"
"            {                                                                 \n"
"              gint i,j;                                                       \n"
"              i = x + radius + u;                                             \n"
"              j = y + radius + v;                                             \n"
"              if (i >= 0 && i < src_width &&                                  \n"
"                  j >= 0 && j < src_height)                                   \n"
"                {                                                             \n"
"                  gint c;                                                     \n"
"                                                                              \n"
"                  gfloat *src_pix = src_buf + (i + j * src_width) * 4;        \n"
"                                                                              \n"
"                  gfloat diff_map   = exp (- (POW2(center_pix[0] - src_pix[0])+\n"
"                                              POW2(center_pix[1] - src_pix[1])+\n"
"                                              POW2(center_pix[2] - src_pix[2])) * preserve\n"
"                                          );                                  \n"
"                  gfloat gaussian_weight;                                     \n"
"                  gfloat weight;                                              \n"
"                                                                              \n"
"                  gaussian_weight = gauss[u+(int)radius+(v+(int)radius)*width];\n"
"                                                                              \n"
"                  weight = diff_map * gaussian_weight;                        \n"
"                                                                              \n"
"                  for (c=0;c<4;c++)                                           \n"
"                    {                                                         \n"
"                      accumulated[c] += src_pix[c] * weight;                  \n"
"                    }                                                         \n"
"                  count += weight;                                            \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"        for (u=0; u<4;u++)                                                    \n"
"          dst_buf[offset*4+u] = accumulated[u]/count;                         \n"
"        offset++;                                                             \n"
"      }                                                                       \n"
"  gegl_buffer_set (dst, dst_rect, 0, babl_format (\"RGBA float\"), dst_buf,   \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class  = GEGL_OPERATION_CLASS (klass);                            \n"
"  filter_class     = GEGL_OPERATION_FILTER_CLASS (klass);                     \n"
"                                                                              \n"
"  filter_class->process   = process;                                          \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"           \"name\", \"gegl:bilateral-filter\",                               \n"
"           \"title\", _(\"Bilateral Filter\"),                                \n"
"           \"categories\", \"enhance:noise-reduction\",                       \n"
"           \"description\",                                                   \n"
"           _(\"Like a gaussian blur; but where the contribution for each neighbourhood \"\n"
"          \"pixel is also weighted by the color difference with the original center pixel. \"),\n"
"           NULL);                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
