/*
** 1998-09-23 -	No program is complete without an "About" command.
** 1999-03-13 -	Now uses a multi dialog, which allows setting a sensible title. :)
** 1999-03-21 -	Brought the copyright into 1999, and added fun page flipping. :)
** 1999-06-20 -	Adapted for the new dialog module, and made asynchronous for fun.
*/

#include "gentoo.h"
#include "dialog.h"

#include "cmd_about.h"

#define	CMD_ID	"about"

/* ----------------------------------------------------------------------------------------- */

#include "graphics/icon_gentoo.xpm"

/* ----------------------------------------------------------------------------------------- */

struct body {
	GtkWidget	*page[2];
	guint		index;
	guint		handle;
};

/* ----------------------------------------------------------------------------------------- */

static gint timeout_trigger(gpointer user)
{
	struct body	*body = user;

	gtk_widget_hide(body->page[body->index]);
	body->index ^= 1;
	gtk_widget_show(body->page[body->index]);

	return TRUE;
}

/* 1999-06-19 -	This gets called as the dialog finally closes. */
static void timeout_remove(gint button, gpointer user)
{
	struct body	*body = user;

	gtk_timeout_remove(GPOINTER_TO_UINT(body->handle));
	g_free(body);
}

int cmd_about(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	gchar		gtkver[32], buf[64];
	GtkWidget	*hbox, *w;
	GdkPixmap	*pmap;
	GdkBitmap	*mask;
	struct body	*body;

	body = g_malloc(sizeof *body);
	body->index = 0U;

	g_snprintf(gtkver, sizeof gtkver, "%d.%d.%d", gtk_major_version, gtk_minor_version, gtk_micro_version);
	g_snprintf(buf, sizeof buf, _("Version %s (GTK+ version %s)."), VERSION, gtkver);

	hbox = gtk_hbox_new(FALSE, 0);
	body->page[0] = gtk_vbox_new(FALSE, 0);
	if((pmap = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(min->gui->window)->window, &mask, NULL, icon_gentoo_xpm)) != NULL)
	{
		w = gtk_pixmap_new(pmap, mask);
		gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 5);
	}
	w = gtk_label_new(buf);
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);
	w = gtk_label_new("(c) 1998-2002 by Emil Brink, Obsession Development.\n");
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);
	w = gtk_label_new(_("This is free software, and there is ABSOLUTELY NO\n"
			"WARRANTY. Read the file COPYING for more details.\n\n"
			"Using built-in English strings."));
	gtk_box_pack_start(GTK_BOX(body->page[0]), w, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), body->page[0], TRUE, TRUE, 0);
	gtk_widget_show_all(body->page[0]);
	body->page[1] = gtk_label_new(	_("The author of gentoo can be reached via Internet\n"
					"e-mail at <emil@obsession.se>; feel free to let\n"
					"me know what you think of this software, give\n"
					"suggestions/bug reports, and so on.\n\n"

					"Custom widgets by J. Hanson <johan@obsession.se>.\n\n"

					"The latest release of gentoo can always be down-\n"
					"loaded from the official gentoo project homepage at\n"
					"<http://www.obsession.se/gentoo/>. New releases are\n"
					"typically announced on the Freshmeat service at\n"
					"<http://freshmeat.net/>."));
	gtk_box_pack_start(GTK_BOX(hbox), body->page[1], TRUE, TRUE, 0);

	body->handle = gtk_timeout_add(10000, timeout_trigger, body);
	dlg_dialog_async_new(hbox, _("About gentoo"), _("OK (Wait for More)"), timeout_remove, body);

	return 1;
}
