


Geomview(5)					      Geomview(5)


NAME
       Geomview - Geomview command language

NOTE
       The  material  in  this	manual	page  also appears in the
       Geomview manual.

DESCRIPTION
       gcl: the Geomview Command Language
       **********************************

       Gcl has the syntax of lisp -- i.e. an expression of the form (f a b
	...) means pass the values of a, b, ... to the function f.
       Gcl is very limited and is by no means an implementation of lisp.  It
       is simply a language for expressing commands to be executed in the order
       given, rather than a programming language.  It does not support variable
       or function definition.

       Gcl is the language that Geomview understands for files that it loads
       as well as for communication with other programs.
       To execute a gcl command interactively, you can bring up the
       *Commands* panel which lets you type in a command; Geomview
       executes the command when you hit the return key.  Output from such
       commands is printed to standard output.	Alternately, you can invoke
       Geomview as `geomview -c -' which causes it to read gcl commands
       from standard input.

       Gcl functions return a value, and you can nest function calls in ways
       which use this returned value.  For example
	    (f (g a b))
       evaluates `(g a b)' and then evaluates `(f x)' where `x'
       is the result returned by `(g a b)'.  Geomview maintains these
       return values internally but does not normally print them out.
       To print out a return value pass it to the `echo' function.
       For example the `geomview-version' function returns a string
       representing the version of Geomview that is running, and
	    (echo (geomview-version))
       prints out this string.

       Many functions simply return `t' for success or `nil' for
       failure; this is the case if the documentation for the function does not
       indicate otherwise.  These are the lisp symbols for true and false,
       respectively.  (They correspond to the C variables `Lt' and
       `Lnil' which you are likely to see if you look at the source code
       for Geomview or some of the external modules.)

       In the descriptions of the commands below several references are made to
       "OOGL" formats.	OOGL is the data description language that Geomview
       uses for describing geometry, cameras, appearances, and other basic
       objects.	 For details of the OOGL formats, *Note OOGL File Formats::.
       (Or equivalently, see the oogl(5) manual page, distributed with Geomview
       in the file man/cat5/oogl.5.

       The gcl commands and argument types are listed below.  Most



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			1





Geomview(5)					      Geomview(5)


       of the documentation in this section of the manual is available within
       Geomview via the `?' and `??' commands.	The command `(?
       COMMAND)' causes Geomview to print out a one-line summary of the
       syntax of COMMAND, and `(?? COMMAND)' prints out an
       explanation of what COMMAND does.  You can include the wild-card
       character `*' in COMMAND to print information for a group of
       commands matching a pattern.  For example, `(?? *emodule*)' will
       print all information about all commands containing the string
       `emodule'.  `(? *)' will print a short list of all commands.

       Conventions Used In Describing Argument Types
       =============================================

       The following symbols are used to describe argument types
       in the documentation for gcl functions.


       `APPEARANCE'
	    is an OOGL appearance specification.

       `CAM-ID'
	    is an ID that refers to a camera.

       `CAMERA'
	    is an OOGL camera specification.

       `GEOM-ID'
	    is an ID that refers to a geometry.

       `GEOMETRY'
	    is an OOGL geometry specification.

       `ID'
	    is a string which names a geometry or camera.  Besides
	    those you create, valid ones are:


	    ``World, world, worldgeom, g0''
		 the collection of all geom's

	    `target'
		 selected target object (cam or geom)

	    `center'
		 selected center-of-motion object

	    `targetcam'
		 last selected target camera

	    `targetgeom'
		 last selected target geom

	    `focus'
		 camera where cursor is (or most recently was)



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			2





Geomview(5)					      Geomview(5)


	    `allgeoms'
		 all geom objects

	    `allcams'
		 all cameras

	    ``default, defaultcam, prototype''
		 future cameras inherit default's settings


	    The following IDs are used to name coordinate systems,
	    e.g. in `pick' and `write' commands:


	    ``World, world, worldgeom, g0''
		 the world, within which all other geoms live.

	    `universe '
		 the universe, in which the World, lights and cameras live.  Cameras'
		 world2cam transforms might better be called universe2cam, etc.

	    `self'
		 "this Geomview object".  Transform from an object to `self' is the
		 identity; writing its geometry gives the object itself with no
		 enclosing transform; picked points appear in the object's coordinates.

	    `primitive'
		 (for `pick' only) Picked points appear in the coordinate system of the
		 lowest-level OOGL primitive.


	    A name is also an acceptable id.  Given names are made unique by
	    appending numbers if necessary (i.e. `foo<2>'). Every geom is also
	    named g[n] and every camera is also named c[n] (`g0' is always the
	    worldgeom): this name is used as a prefix to keyboard commands and can
	    also be used as a gcl id.  Numbers are reused after an
	    object is deleted. Both names are shown in the Object browser.

       `STATEMENT'
	    represents a function call.	 Function calls have the form `(func arg1
	    arg2 ... )', where `func' is the name of the function and `arg1',
	    `arg2', ... are the arguments.

       `TRANSFORM'
	    is an OOGL 4x4 transformation matrix.

       `WINDOW'
	    is an OOGL winddow specification.



       Gcl Reference Guide
       ===================




Geometry Center	   Thu Dec 12 02:41:23 CST 1996			3





Geomview(5)					      Geomview(5)


       `! is a synonym for `shell''

       `(< EXPR1 EXPR2)'
	    Returns t if EXPR1 is less than EXPR2.  EXPR1 and EXPR2 should
	    be either both integers or floats, or both strings.

       `(= EXPR1 EXPR2)'
	    Returns t if EXPR1 is equal to EXPR2.  EXPR1 and EXPR2 should
	    be either both integers or floats, or both strings.

       `(> EXPR1 EXPR2)'
	    Returns t if EXPR1 is greater than EXPR2.  EXPR1 and EXPR2 should
	    be either both integers or floats, or both strings.

       `(?  [command])'
	    Gives one-line usage summary for `command'.
	    Command may include `*'s as wildcards; see also `??'
	    One-line command help; lists names only if multiple commands match.
	    ? is a synonym for `help'

       `(?? command)  `command' may include `*' wildcards'
	    Prints more info than `(? command)'.  ?? is a synonym
	    for `morehelp'.

       `| is a synonym for `emodule-run'.'

       `(all geometry)	returns a list of names of all geometry objects.'
	    Use e.g. `(echo (all geometry))' to print such a list.
       `(all camera)  returns a list of names of all cameras.'
       `(all emodule defined)  returns a list of all defined external modules.'
       `(all emodule running)  returns a list of all running external modules.'

       `(ap-override [on|off])'
	    Selects whether appearance controls should override objects' own
	    settings.  On by default.  With no arguments, returns current setting.

       `(backcolor	CAM-ID R G B)'
	    Set the background color of CAM-ID; R G B are numbers
	    between 0 and 1.

       `(background-image CAM-ID [FILENAME])'
	    Use the given image as the background of camera CAM-ID (which must be a
	    real camera, not `default' or `allcams'). Centers the image on
	    the window area.  Works only with GL and OpenGL graphics.
	    Use "" for filename to remove background.  With no filename argument,
	    returns name of that window's current background image, or "".
	    Any file type acceptable as a texture is allowed, e.g. .ppm.gz, .sgi, etc.

       `(bbox-color	GEOM-ID R G B)'
	    Set the bounding-box color of GEOM-ID; R G B are numbers
	    between 0 and 1.

       `(bbox-draw	GEOM-ID [yes|no])'
	    Say whether GEOM-ID's bounding-box should be drawn; `yes' if omitted.



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			4





Geomview(5)					      Geomview(5)


       `(camera		CAM-ID [CAMERA])'
	    Specify data for CAM-ID; CAMERA is a string giving an OOGL
	    camera specification.  If no camera CAM-ID exists,
	    it is created; in this case, the second argument is optional,
	    and if omitted, a default camera is used.  See also: new-camera.

       `(camera-draw	CAM-ID [yes|no])'
	    Say whether or not cameras should be drawn in CAM-ID; `yes' if omitted.

       `(camera-prop { geometry object }   [projective])'
	    Specify the object to be shown when drawing other cameras.
	    By default, this object is drawn with its origin at the camera,
	    and with the camera looking toward the object's -Z axis.
	    With the `projective' keyword, the camera's viewing projection is
	    also applied to the object; this places the object's Z=-1 and Z=+1 at
	    near and far clipping planes, with the viewing area -1<={X,Y}<=+1.
	    Example:  (camera-prop { < cube } projective)

       `(camera-reset	CAM-ID)'
	    Reset CAM-ID to its default value.

       `(car LIST)'
	    returns the first element of LIST.

       `(cdr LIST)'
	    returns the list obtained by removing the first element of LIST.

       `(clock)'
	    Returns the current time, in seconds, as shown by this stream's clock.
	    See also set-clock and sleep-until.

       `(command	INFILE [OUTFILE])'
	    Read commands from INFILE; send corresponding responses
	    (e.g. anything written to filename `-') to OUTFILE, stdout
	    by default.

       `(copy [ID] [name])'
	    Copies an object or camera.	 If ID is not specified, it
	    is assumed to be targetgeom.  If name is not specified, it
	    is assumed to be the same as the name of ID.

       `(cursor-still [INT])'
	    Sets the number of microseconds for which the cursor must not
	    move to register as holding still.	If INT is not specified,
	    the value will be reset to the default.

       `(cursor-twitch	   [INT])'
	    Sets the distance which the cursor must not move (in x or
	    y) to register as holding still.  If INT is not specified,
	    the value will be reset to the default.

       `(delete		ID)'
	    Delete object or camera ID.




Geometry Center	   Thu Dec 12 02:41:23 CST 1996			5





Geomview(5)					      Geomview(5)


       `(dice		GEOM-ID N)'
	    Dice any Bezier patches within GEOM-ID into NxN meshes; default 10.
	    See also the appearance attribute `dice', which makes this command
	    obsolete.

       `(dimension [N])'
	    Sets or reads the space dimension for N-dimensional viewing.
	    (Since calculations are done using homogeneous coordinates,
	    this means matrices are (N+1)x(N+1).)
	    With no arguments, returns the current dimension, or 0 if
	    N-dimensional viewing has not been enabled.

       `(dither	 CAM-ID {on|off|toggle})'
		     Turn dithering on or off in that camera.

       `(draw		CAM-ID)'
	    Draw the view in CAM-ID, if it needs redrawing.  See also `redraw'.

       `(echo	       ...)'
	    Write the given data to the special file `-'.  Strings are written
	    literally; lisp expressions are evaluated and their values written.
	    If received from an external program, `echo' sends to the program's
	    input.  Otherwise writes to geomview's own standard output
	    (typically the terminal).

       `(emodule-clear)'
	    Clears the geomview application (external module) browser.

       `(emodule-define	 NAME  SHELL-COMMAND ...)'
		    Define an external module called NAME, which then appears in the
		    external-module browser.  The SHELL-COMMAND string
		    is a UNIX shell command which invokes the module.
		    See emodule-run for discussion of external modules.

       `(emodule-defined `modulename')'
	    If the given external-module name is known, returns the name of
	    the program invoked when it's run as a quoted string; otherwise
	    returns nil.  `(echo (emodule-defined `name'))' prints the string.

       `(emodule-isrunning NAME)'
	    Returns Lt if the emodule NAME is running, or Lnil
	    if it is not running.  NAME is searched for in the
	    names as they appear in the browser and in the shell commands
	    used to execute the external modules (not including arguments).

       `(emodule-path)'
	    Returns the current search path for external modules.
	    Note: to actually see the value returned by this function
	    you should wrap it in a call to echo: (echo (emodule-path)).
		    See also set-emodule-path.

       `(emodule-run  SHELL-COMMAND ARGS...)'
	    Runs the given SHELL-COMMAND (a string containing a UNIX shell
	    command) as an external module.  The module's standard output



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			6





Geomview(5)					      Geomview(5)


	    is taken as geomview commands; responses (written to filename
	    `-') are sent to the module's standard input.  The shell
	    command is interpreted by /bin/sh, so e.g. I/O redirection may
	    be used; a program which prompts the user for input from the
	    terminal could be run with:
	      (emodule-run  yourprogram	 <&2)
	    If not already set, the environment variable $MACHTYPE is set
	    to the name of the machine type.  Input and output
	    connections to geomview are dropped when the shell command
	    terminates.	 Clicking on a running program's module-browser entry
	    sends the signal SIGHUP to the program.  For this to work, programs
	    should avoid running in the background; those using FORMS or GL
	    should call foreground() before the first FORMS or winopen() call.
	    See also emodule-define, emodule-start.

       `(emodule-sort)'
		    Sorts the modules in the application browser alphabetically.

       `(emodule-start	NAME)'
		    Starts the external module NAME, defined by emodule-define.
		    Equivalent to clicking on the corresponding module-browser entry.

       `(emodule-transmit NAME LIST)'
	    Places LIST into external module NAME's standard input.  NAME is
	    searched for in the names of the modules as they appear in the
	    External Modules browser and then in the shell commands used to
	    execute the external modules.  Does nothing if modname is not
	    running.

       `(escale		 GEOM-ID FACTOR)'
	    Same as scale but multiplies by exp(scale).	 Obsolete.

       `(event-keys {on|off})'
		     Turn keyboard events on or off to enable/disable keyboard shortcuts.

       `(event-mode	MODESTRING)'
	    Set the mouse event (motion) mode; MODESTRING should be one of
	    the strings that appears in the motion mode browser (including
	    the keyboard shortcut, e.g. `[r] Rotate').

       `(event-pick {on|off})'
	    Turn picking on or off.

       `(evert		GEOM-ID [yes|no])'
	    Set the normal eversion state of GEOM-ID.  If the second argument
	    is omitted, toggle the eversion state.

       `(exit)'
	    Terminates geomview.

       `(ezoom		GEOM-ID FACTOR)'
	    Same as zoom but multiplies by exp(zoom).  Obsolete.

       `(freeze		CAM-ID)'



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			7





Geomview(5)					      Geomview(5)


	    Freeze CAM-ID; drawing in this camera's window is turned off
	    until it is explicitly redrawn with `(redraw CAM-ID)', after
	    which time drawing resumes as normal.

       `(geometry	GEOM-ID [GEOMETRY])'
	    Specify the geometry for GEOM-ID.  GEOMETRY is a string
	    giving an OOGL geometry specification.  If no object
	    called GEOM-ID exists, it is created; in this case the
	    GEOMETRY argument is optional, and if omitted, the new
	    object GEOM-ID is given an empty geometry.

       `(geomview-version)'
	    Returns a string representing the version of geomview that is
	    running.

       `(hdefine  `geometry'|`camera'|`transform'|`window'  name  value)'
	    Sets the value of a handle of a given type.
		   (hdefine  <type>  <name>  <value>)
	    is generally equivalent to
		   (read <type>	 { define <name> <value> })
	    except that the assignment is done when hdefine is executed,
	    (possibly not at all if inside a conditional statement),
	    while the `read ... define' performs assignment as soon as the
	    text is read.


       `(help	      [command])'
	    Command may include `*'s as wildcards; see also `??'
	    One-line command help; lists names only if multiple commands match.

       `(hmodel CAMID {virtual|projective|conformal})'
	    Set the model used to display geometry in
	    this camera; see also `space'.

       `(hsphere-draw	CAMID [yes|no])'
	    Say whether to draw a unit sphere: the sphere at infinity in
	    hyperbolic space, and a reference sphere in Euclidean and spherical
	    spaces.  If the second argument is omitted, `yes' is assumed.

       `(if TEST EXPR1 [EXPR2])'
	    Evaluates TEST; if TEST returns a non-nil value, returns the
	    value of EXPR1.  If TEST returns nil, returns the value of
	    EXPR2 if EXPR2 is present, otherwise returns nil.

       `(inhibit-warning STRING)'
	    Inhibit warning inhbits geomview from displaying a
	    particular warning message determined by STRING.
	    At present there are no warning messages that this
	    applies to, so this command is rather useless.

       `(input-translator  "#prefix_string"  "Bourne-shell-command")'
	    Defines an external translation program for special input types.
	    When asked to read a file which begins with the specified string,
	    geomview invokes that program with standard input coming from the given file.



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			8





Geomview(5)					      Geomview(5)


	    The program is expected to emit OOGL geometric data to its standard output.
	    In this implementation, only prefixes beginning with # are recognized.
	    Useful as in
		   (input-translator "#VRML" "vrml2oogl")

       `(interest (COMMAND [args]))'

	    Allows you to express interest in a command.  When geomview
	    executes that command in the future it will echo it to the
	    communication pool from which the interest command came.
	    COMMAND can be any command.	 Args specify restrictions on the
	    values of the arguments; if args are present in the interest
	    command, geomview will only echo calls to the command in which
	    the arguments match those given in the interest command.  Two
	    special argument values may appear in the argument list.  `*'
	    matches any value. `nil' matches any value but supresses the
	    reporting of that value; its value is reported as `nil'.

	    The purpose of the interest command is to allow external
	    modules to find out about things happening inside geomview.
	    For example, a module interested in knowing when a geom called
	    `foo' is deleted could say `(interest (delete foo))' and would
	    receive the string `(delete foo)' when foo is deleted.

	    Picking is a special case of this.	For most modules
	    interested in pick events the command `(interest (pick
	    world))' is sufficient.  This causes geomview to send a string
	    of the form `(pick world ...)' every time a pick event (right
	    mouse double click).  See the `pick' command for details.

       `(lines-closer	CAM-ID DIST)'
	    Draw lines (including edges) closer to the camera than polygons
	    by DIST / 10^5  of the Z-buffer range.  DIST = 3.0 by default.
	    If DIST is too small, a line lying on a surface may be
	    dotted or invisible, depending on the viewpoint.
	    If DIST is too large, lines may appear in front of surfaces
	    that they actually lie behind.  Good values for DIST vary with
	    the scene, viewpoint, and distance between near and far clipping
	    planes.  This feature is a kludge, but can be helpful.

       `(load  filename	 [command|geometry|camera])'
	    Loads the given file into geomview.	 The optional second argument
	    specifies the type of data it contains, which may be `command'
	    (geomview commands), `geometry' (OOGL geometric data), or
	    `camera' (OOGL camera definition).	If omitted, attempts to guess
	    about the file's contents.
	    Loading geometric data creates a new visible object; loading a camera
	    opens a new window; loading a command file executes those commands.


       `(load-path)'
	    Returns the current search path for command, geometry, etc. files.
	    Note: to actually see the value returned by this function
	    you should wrap it in a call to echo: (echo (load-path)).



Geometry Center	   Thu Dec 12 02:41:23 CST 1996			9





Geomview(5)					      Geomview(5)


	    See also set-load-path.

       `(look [objectID] [cameraID])'
	    Rotates the named camera to point toward the center of the
	    bounding box of the named object (or the origin in hyperbolic or
	    spherical space).  In Euclidean space, moves the camera
	    forward or backward until the object appears as large
	    as possible while still being entirely visible.  Equivalent to
	    progn (
		 (look-toward [objectID] [cameraID] {center | origin})
		 [(look-encompass [objectID] [cameraID])]
	    )
	    If objectID is not specified, it is assumed to be World.  If
	    cameraID is not specified, it is assumed to be targetcam.

       `(look-encompass [objectID] [cameraID])'
	    Moves cameraID backwards or forwards until its field of view
	    surrounds objectID. This routine works only in Euclidean space.
	    If objectID is not specified, it is assumed to be the world.
	    If cameraID is not specified, it is assumed to be the targetcam.
	    See also (look-encompass-size).

       `(look-encompass-size [view-fraction  clip-ratio	 near-margin far-margin])'
	    Sets/returns parameters used by (look-encompass).
	    view-fraction is the portion of the camera window filled by the object,
	    clip-ratio is the max allowed ratio of near-to-far clipping planes.
	    The near clipping plane is 1/near-margin times closer than the near
	    edge of the object, and the far clipping plane is far-margin times
	    further away.  Returns the list of current values.
	    Defaults: .75  100	0.1  4.0


       `(look-recenter [objectID] [cameraID])'
	    Translates and rotates the camera so that it is looking in the
	    -z direction (in objectID's coordinate system) at the center of
	    objectID's bounding box (or the origin of the coordinate system
	    in non-Eudlidean space).  In Euclidean space, the camera is also
	    moved as close as possible to the object while allowing the
	    entire object to be visible.  Also makes sure that the y-axes of
	    objectID and cameraID are parallel.

       `(look-toward [objectID] [cameraID] [origin | center])'
	    Rotates the named camera to point toward the origin of the
	    object's coordinate system, or the center of the object's
	    bounding box (in non-Euclidean space, the origin will be used
	    automatically).  Default objectID is the world, default camera
	    is targetcam, default location to point towards is the center
	    of the bounding box.

       `(merge		{window|camera} CAM-ID	{ WINDOW or CAMERA ... } )'
	    Modify the given window or camera, changing just those properties
	    specified in the last argument.  E.g.
		 (merge camera `Camera' { far 20 })
	    sets Camera's far clipping plane to 20 while leaving



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       10





Geomview(5)					      Geomview(5)


	    other attributes untouched.

       `(merge-ap	GEOM-ID APPEARANCE)'
	    Merge in some appearance characteristics to GEOM-ID.
	    Appearance parameters include surface and line color, shading
	    style, line width, and lighting.

       `merge-base-ap is a synonym for merge-baseap.'

       `(merge-baseap	APPEARANCE)'
	    Merge in some appearance characteristics to the base default
	    appearance (applied to every geom before its own apperance).
	    Lighting is typically included in the base appearance.

       `(morehelp    command)'
	    `command' may include `*' wildcards.
	    Prints more info than `(help command)'.

       `(name-object	ID NAME)'
	    Assign a new NAME (a string) to ID.	 A number is appended if
	    that name is in use (for example, `foo' -> `foo<2>').  The new
	    name, possibly with number appended, may be used as object's
	    id thereafter.

       `(ND-axes CAMID [CLUSTERNAME [Xindex Yindex Zindex]])'
	    In our model for N-D viewing (enabled by (dimension)), objects in
	    N-space are viewed by N-dimensional *camera clusters*.
	    Each real camera window belongs to some cluster, and shows &
	    manipulates a 3-D axis-aligned projected subspace of the N-space seen
	    by its cluster.  Moving one camera in a cluster affects its siblings.

	    The ND-axes command configures all this.  It specifies a camera's
	    cluster membership, and the set of N-space axes which become the
	    3-D camera's X, Y, and Z axes.  Axes are specified by their indices,
	    from 0 to N-1 for an N-dimensional space.  Cluster CLUSTERNAME is
	    implicitly created if not previously known.
	    To read a camera's configuration, use `(echo (ND-axes CAMID))'.


       `(ND-color CAMID'
		 [ (( [ID] (x0 x1 x2 ... xn) v r g b a	 v r g b a  ... )
		    ((x0 ... xn)  v r g b a  v r g b a ...) ...)] )
	    Specifies a function, applied to each N-D vertex, which determines the
	    colors of N-dimensional objects as shown in camera CAMID.
	    Each coloring function is defined by a vector (in ID's coordinate system)
	    [x0 x1 ... xn] and by a sequence of value (v)/color(r g b a) tuples,
	    ordered by increasing v.  The inner product v = P.[x] is linearly
	    interpolated in this table to give a color.
	    If ID is omitted, the (xi) vector is assumed in universe coordinates.
	    The ND-color command specifies a list of such functions; each vertex
	    is colored by their sum (so e.g. green intensity could indicate
	    projection along one axis while red indicated another.
	    An empty list, as in (ND-color CAMID ()), suppresses coloring.
	    With no second argument, (ND-color CAMID) returns that camera's



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       11





Geomview(5)					      Geomview(5)


	    color-function list.
	    Even when coloring is enabled, objects tagged with the `keepcolor'
	    appearance attribute are shown in their natural colors.


       `(ND-xform OBJID [ntransform { idim odim	 ... }])'
	    Sets or returns the N-D transform of the given object.
	    In dimension N, this is an (N+1)x(N+1) matrix.
	    Note that all cameras in a camera-cluster have the same N-D transform.


       `(ND-xform-get ID [from-ID])'
	    Returns the N-D transform of the given object in the coordinate system
	    of from-ID (default `universe'), in the sense
	      <point-in-ID-coords> * Transform = <point-in-from-ID-coords>


       `(new-alien	name [GEOMETRY])'
	    Create a new alien (geom not in the world) with the given name
	    (a string).	 GEOMETRY is a string giving an OOGL geometry
	    specification.  If GEOMETRY is omitted, the new alien
	    is given an empty geometry.	 If an object with that name
	    already exists, the new alien is given a unique name.  The
	    light beams that are used to move around the lights are an
	    example of aliens. They're drawn but are not controllable the
	    way ordinary objects are: they don't appear in the object
	    browser and the user can't move them with the normal motion
	    modes.

       `(new-camera	name [CAMERA])'
	    Create a new camera with the given name (a string).	 If a
	    camera with that name already exists, the new object is given
	    a unique name.  If CAMERA is omitted a default camera is used.

       `(new-center [id])'
	    Stop id, then set id's transform to the identity.  Default id
	    is target.	Also, if the id is a camera, calls
	    (look-recenter World id).  The main function of the call to
	    (look-recenter) is to place the camera so that it is pointing
	    parallel to the z axis toward the center of the world.

       `(new-geometry	name [GEOMETRY])'
	    Create a new geom with the given name (a string).  GEOMETRY is
	    a string giving an OOGL geometry specification.  If
	    GEOMETRY is omitted, the new object is given an empty geometry.
	    If an object with that name already exists, the new object is
	    given a unique name.

       `(new-reset)'
	    Equivalent to (progn (new-center ALLGEOMS)(new-center ALLCAMS))

       `(NeXT)'
	    Returns t if running on a NeXT, nil if not




Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       12





Geomview(5)					      Geomview(5)


       `(normalization	GEOM-ID {each|none|all|keep})'
	    Set the normalization status of GEOM-ID.
	    `none'
		 suppresses all normalization.
	    `each'
		 normalizes the object's bounding box to fit into the unit
		 sphere, with the center of its bounding box translated
		 to the origin.	 The box is scaled such that its long diagonal,
		 sqrt((xmax-xmin)^2 + (ymax-ymin)^2 + (zmax-zmin)^2), is 2.
	    `all'
		 resembles `each', except when an object is changing
		 (e.g. when its geometry is being changed by an external program).
		 Then, `each' tightly fits the bounding box around the
		 object whenever it changes and normalizes accordingly,
		 while `all' normalizes the union of all variants of the object
		 and normalizes accordingly.
	    `keep'
		 leaves the current normalization transform unchanged
		 when the object changes.  It may be useful to apply `each' or
		 `all' normalization apply to the first version of a changing
		 object to bring it in view, then switch to `keep'.

       `(pick COORDSYS GEOMID G V E F P VI EI FI)'
	    The pick command is executed internally in response to pick
	    events (right mouse double click).

	    COORDSYS = coordinate system in which coordinates of the following
		arguments are specified.   This can be:
		 world: world coord sys
		 self:	coord sys of the picked geom (GEOMID)
		 primitive: coord sys of the actual primitive within
		     the picked geom where the pick occurred.
	    GEOMID = id of picked geom
	    G = picked point (actual intersection of pick ray with object)
	    V = picked vertex, if any
	    E = picked edge, if any
	    F = picked face
	    P = path to picked primitive [0 or more]
	    VI = index of picked vertex in primitive
	    EI = list of indices of endpoints of picked edge, if any
	    FI = index of picked face

	    External modules can find out about pick events by registering
	    interest in calls to `pick' via the `interest' command.

       `(pick-invisible [yes|no])'
	    Selects whether picks should be sensitive to objects whose appearance
	    makes them invisible; default yes.
	    With no arguments, returns current status.

       `(pickable	GEOM-ID {yes|no})'
	    Say whether or not GEOM-ID is included in the pool of objects
	    that could be returned from the pick command.




Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       13





Geomview(5)					      Geomview(5)


       `(position	objectID otherID)'
	    Set the transform of objectID to that of otherID.

       `(position-at	objectID otherID [center | origin])'
	    Translate objectID to the center of the bounding box or the
	    origin of the coordinate system of otherID (parallel translation).
	    Default is center.

       `(position-toward objectID otherID [center | origin])'
	    Rotate objectID so that the center of the bounding box
	    or the origin of the coordinate system of the otherID
	    lies on the positive z-axis of the first object.  Default is
	    the center of the bounding box.

       `(progn STATEMENT [ ... ])'
	    evaluates each STATEMENT in order and returns the value of the
	    last one.  Use progn to group a collection of commands together,
	    forcing them to be treated as a single command.

       `quit is a synonym for `exit''

       `(quote EXPR)'
	    returns the symbolic lisp expression EXPR without evaluating it.

       `(rawevent	dev val x y t)'
	    Enter the specified raw event into the event queue.	 The
	    arguments directly specify the members of the event structure
	    used internally by geomview.  This is the lowest level event
	    handler and is not intended for general use.

       `(rawpick CAMID X Y)'
	    Process a pick event in camera CAMID at location (X,Y) given in
	    integer pixel coordinates.	This is a low-level procedure not
	    intended for external use.

       `(read {geometry|camera|transform|command} {GEOMETRY or CAMERA or ...})'
	    Read and interpret the text in ... as containing the
	    given type of data.	 Useful for defining objects using OOGL
	    reference syntax, e.g.

	      (geometry	 thing { INST  transform : T	geom : fred })
	      (read  geometry  { define fred QUAD 1 0 0	 0 1 0	0 0 1  1 0 0 })
	      (read  transform { define T <myfile})

       `(real-id ID)'
	    Returns a string canonically identifying the given ID,
	    or `nil' if the object does not exist.  Examples:
	     (if (real-id fred) (delete fred))
	    deletes `fred' if it exists but reports no error if it doesn't, and
	     (if (= (real-id targetgeom) (real-id World)) () (delete targetgeom))
	    deletes `targetgeom' if it is different from the World.


       `(redraw		CAM-ID)'



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       14





Geomview(5)					      Geomview(5)


	    States that the view in CAM-ID should be redrawn on the
	    next pass through the main loop or the next invocation of `draw'.

       `(regtable) --- shows the registry table'

       `(rehash-emodule-path)'
	    Rebuilds the application (external module) browser by reading
	    all .geomview-* files in all directories on the emodule-path.
	    Primarily intended for internal use; any applications defined
	    by (emodule-define ...) commands outside of the .geomview-*
	    files on the emodule-path will be lost.  Does not sort the
	    entries in the brower; see (emodule-sort) for that.

       `(replace-geometry GEOM-ID PART-SPECIFICATION GEOMETRY)'
	    Replace a part of the geometry for GEOM-ID.

       `(rib-display	[frame|tiff] FILEPREFIX)'
	    Set Renderman display to framebuffer (popup screen window) or a
	    TIFF format disk file. FILEPREFIX is used to construct
	    names of the form `prefixNNNN.suffix'. (i.e. foo0000.rib)
	    The number is incremented on every call to `rib-snapshot' and
	    reset to 0000 when `rib-display' is called. TIFF files are given
	    the same prefix and number as the RIB file (i.e. foo0004.rib
	    generates foo0004.tiff). The default FILEPREFIX is `geom' and
	    the default format is TIFF. (Note that geomview just generates a
	    RIB file, which must then be rendered.)

       `(rib-snapshot	CAM-ID	[filename])'
	    Write Renderman snapshot (in RIB format) of CAM-ID to <filename>.
	    If no filename specified, see `rib-display' for explanation of
	    the filename used.

       `(scale		GEOM-ID FACTOR [FACTORY FACTORZ])'
	    Scale GEOM-ID, multiplying its size by FACTOR.  The factors
	    should be positive numbers.	 If FACTORY and FACTORZ are
	    present and non-zero, the object is scaled by FACTOR in x, by
	    FACTORY in y, and by FACTORZ in z.	If only FACTOR is present,
	    the object is scaled by FACTOR in x, y, and z.  Scaling only
	    really makes sense in Euclidean space.  Mouse-driven scaling in
	    other spaces is not allowed;  the scale command may be issued
	    in other spaces but should be used with caution because it may
	    cause the data to extend beyond the limits of the space.

       `(scene		CAM-ID [GEOMETRY])'
	    Make CAM-ID look at GEOMETRY instead of at the universe.

       `(set-clock TIME)'
	    Adjusts the clock for this command stream to read TIME (in seconds)
	    as of the moment the command is received.  See also sleep-until, clock.

       `(set-conformal-refine CMX [N [SHOWEDGES]])'
	    Sets the parameters for the refinement algorithm used in drawing
	    in the conformal model.  CMX is the cosine of the maximum angle
	    an edge can bend before it is refined.  Its value should be between



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       15





Geomview(5)					      Geomview(5)


	    -1 and 1; the default is 0.95; decreasing its value will cause less
	    refinement.	 N is the maximum number of iterations of refining;
	    the default is 6.  SHOWEDGES, which should be `no' or `yes',
	    determines whether interior edges in the refinement are drawn.

       `(set-emodule-path      (PATH1 ... PATHN))'
	    Sets the search path for external modules.	The PATHi should
	    be pathnames of directories containing, for each module, the
	    module's executable file and a .geomview-<modulename> file
	    which contains an (emodule-define ...) command for that
	    module.  This command implicitly calls (rehash-emodule-path)
	    to rebuild the application brower from the new path setting.
	    The special directory name `+' is replaced by the existing path,
	    so e.g. (set-emodule-path (mydir +)) prepends mydir to the path.

       `(set-load-path	    (PATH1 ... PATHN))'
	    Sets search path for command, geometry, etc. files.	 The PATHi
	    are strings giving the pathnames of directories to be searched.
	    The special directory name `+' is replaced by the existing path,
	    so e.g. (set-load-path (mydir +)) prepends mydir to the path.

       `(set-motionscale X)'
	    Set the motion scale factor to X (default value 0.5).  These
	    commands scale their motion by an amount which depends on the
	    distance from the frame to the center and on the size of the
	    frame.  Specifically, they scale by
		    dist + scaleof(frame) * motionscale
	    where dist is the distance from the center to the frame and
	    motionscale is the motion scale factor set by this function.
	    Scaleof(frame) measures the size of the frame object.

       `(setenv	 name string)  sets the environment variable `name' to the value'

	    STRING;
	    the name is visible to geomview (as in pathnames containing `$name')
	    and to processes it creates, e.g. external modules.

       `(sgi)'
	    Returns t if running on an sgi machine, nil if not

       `(shell	       SHELL-COMMAND)'
	    Execute the given UNIX SHELL-COMMAND using /bin/sh.	 Geomview
	    waits for it to complete and will be unresponsive until it does.
	    A synonym is `!'.

       `(sleep-for  TIME)'
	    Suspend reading commands from this stream for TIME seconds.
	    Commands already read will still be executed; `sleep-for' inside
	    `progn' won't delay execution of the rest of the progn's contents.

       `(sleep-until TIME)'
	    Suspend reading commands from this stream until TIME (in seconds).
	    Commands already read will still be executed; `sleep-until' inside
	    `progn' won't delay execution of the rest of the progn's contents.



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       16





Geomview(5)					      Geomview(5)


	    Time is measured according to this stream's clock, as set by
	    `set-clock'; if never set, the first sleep-until sets it to 0
	    (so initially (sleep-until TIME) is the same as (sleep-for TIME)).
	    Returns the number of seconds until TIME.

       `(snapshot	CAM-ID	   FILENAME [FORMAT [XSIZE [YSIZE]]])'
	    Save a snapshot of CAM-ID in the FILENAME (a string).  The
	    FORMAT argument is optional; it may be `ppmscreen',
	    `sgi', `ps', or `ppm'.  A `ppmscreen' snapshot is created by reading
	    the image directly from the given window; the window is popped above
	    other windows and redrawn first, then its contents are written as a
	    PPM format image.  With `ps', dumps a Postscript picture representing
	    the view from that window; hidden-surface removal might be incorrect.
	    With `ppm', dumps a PPM-format image produced by geomview's internal
	    software renderer; this may be of arbitrary size.  If the FILENAME
	    argument begins with the vertical bar `|', it's interpreted as a
	    /bin/sh command to which the PPM or PS data should be piped.
	    Optional XSIZE and YSIZE values are relevant only for `ppm' format,
	    and render to a window of that size (or scaled to that size,
	    with aspect fixed, if only XSIZE is given)

       `(soft-shader  CAM-ID  {on|off|toggle})'
	    Select whether to use software or hardware shading in that camera.

       `(space {euclidean|hyperbolic|spherical})'
	    Set the space associated with the world.

       `(stereowin CAM-ID  [no|horizontal|vertical|colored] [gapsize])'
	    Configure CAM-ID as a stereo window.
	    no: entire window is a single pane, stereo disabled
	    horizontal: split left/right: left is stereo eye#0, right is #1.
	    vertical: split top/bottom: bottom is eye#0, top is #1.
	    colored: panes overlap, red is stereo eye#0, cyan is #1.

	    A gap of `gapsize' pixels is left between subwindows;
	    if omitted, subwindows are adjacent.
	    If both layout and gapsize are omitted, e.g. (stereowin CAM-ID),
	    returns current settings as a `(stereowin ...)' command list.
	    This command doesn't set stereo projection; use `merge camera' or
	    `camera' to set the stereyes transforms, and `merge window' or
	    `window' to set the pixel aspect ratio & window position if needed.

       `(time-interests deltatime initial prefix [suffix])'
	    Indicates that all interest-related messages, when separated by at
	    least `deltatime' seconds of real time, should be preceded by
	    the string `prefix' and followed by `suffix'; the first message
	    is preceded by `initial'.  All three are printf format strings,
	    whose argument is the current clock time (in seconds) on that stream.
	    A `deltatime' of zero timestamps every message.  Typical usage:
	    (time-interests .1 `(set-clock %g)' `(sleep-until %g)')  or
	    (time-interests .1 `(set-clock %g)'
		 "(sleep-until %g) (progn (set-clock %g)" ")")	  or
	    (time-interests .1 "(set-clock %g)"
			 "(if (> 0 (sleep-until %g)) (" "))".



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       17





Geomview(5)					      Geomview(5)


       `(transform	objectID centerID frameID [rotate|translate|translate-scaled|scale] x y z [dt] [`smooth'])'
	    Apply a motion (rotation, translation, scaling) to object `objectID';
	    that is, construct and concatenate a transformation matrix with
	    objectID's transform  The 3 IDs involved are the object
	    that moves, the center of motion, and the frame of reference
	    in which to apply the motion.  The center is easiest understood
	    for rotations: if centerID is the same as objectID then it will
	    spin around its own axes; otherwise the moving object will orbit
	    the center object.	Normally frameID, in whose coordinate system
	    the (mouse) motions are interpreted, is `focus', the current camera.
	    Translations can be scaled proportional to the
	    distance between the target and the center. Support for
	    spherical and hyperbolic as well as Euclidean space is
	    built-in: use the `space' command to change spaces.	 With type
	    `rotate' x, y, and z are floats specifying angles in RADIANS.
	    For types `translate' and `translate-scaled' x, y, and z are
	    floats specifying distances in the coordinate system of the
	    center object.  The optional `dt' field allows a simple form of
	    animation; if present, the object moves by just that amount during
	    approximately `dt' seconds, then stops.  If present and followed by
	    the `smooth' keyword, the motion is animated with a 3t^2-2t^3
	    function, so as to start and stop smoothly.	 If absent, the motion is
	    applied immediately.

       `(transform-incr	 objectID centerID frameID [rotate|translate|translate-scaled|scale] x y z [dt])'
	    Apply continuing motion: construct a transformation matrix and
	    concatenate it with the current transform of objectID every
	    refresh (sets objectID's incremental transform). Same syntax
	    as transform.  If optional `dt' argument is present,
	    the object is moved at each time step such that its average motion
	    equals one instance of the motion per `dt' seconds.	 E.g.
	      (transform-incr  World World World  rotate  6.28318 0 0  10.0)
	    rotates the World about its X axis at 1 turn (2pi radians) per 10 seconds.


       `(transform-set objectID centerID frameID [rotate|translate|translate-scaled|scale] x y z)'
	    Set objectID's transform to the constructed transform.
	    Same syntax as transform.

       `(ui-center	ID)'
		    Set the center for user interface (i.e. mouse) controlled
		    motions to object ID.

       `ui-emotion-program is an obsolete command.'
	    Use its new eqivalent `emodule-define' instead.

       `ui-emotion-run is an obsolete command.'
	    Use its new eqivalent `emodule_start' instead.

       `(ui-freeze [on|off])'
		    Toggle updating user interface panels. Off by default.

       `(ui-panel	PANELNAME  {on|off} [ WINDOW ] )'
		    Do or don't display the given user-interface panel.



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       18





Geomview(5)					      Geomview(5)


		    Case is ignored in panel names.  Current PANELNAMEs are:
			    geomview	    main panel
			    tools	    motion controls
			    appearance	    appearance controls
			    cameras	    camera controls
			    lighting	    lighting controls
			    obscure	    obscure controls
			    materials	    material properties controls
			    command	    command entry box
			    credits	    geomview credits
		    By default, the `geomview' and `tools' panels appear when
		    geomview starts.  If the optional Window is supplied, a
		    `position' clause (e.g. (ui-panel obscure on { position xmin
		    xmax ymin ymax }) sets the panel's default position.  (Only
		    xmin and ymin values are actually used.)  A present but empty
		    Window, e.g.  `(ui-panel obscure on {})' causes interactive
		    positioning.

       `(ui-target	ID [yes|no])'
		    Set the target of user actions (the selected line of the
		    target object browser) to ID.  The second argument specifies
		    whether to make ID the current object regardless of its type.
		    If `no', then ID becomes the current object of its type
		    (geom or camera).  The default is `yes'.  This command may
		    result in a change of motion modes based on target choice.

       `(uninterest (COMMAND [args]))'
	    Undoes the effect of an `interest' command.	 (COMMAND [args]) must
	    be identical to those used in the `interest' command.

       `(update [timestep_in_seconds])'
	    Apply each incremental motion once.	 Uses timestep if it's present and
	    nonzero; otherwise motions are proportional to elapsed real time.

       `(update-draw	CAM-ID	[timestep_in_seconds])'
	    Apply each incremental motion once and then draw CAM-ID.
	    Applies `timestep' seconds' worth of motion, or uses elapsed real
	    time if `timestep' is absent or zero.

       `(window		CAM-ID	WINDOW)'
	    Specify attributes for the window of CAM-ID, e.g. its size
	    or initial position, in the OOGL Window syntax.
	    The special CAM-ID `default' specifies
	    properties of future windows (created by `camera' or
	    `new-camera').

       `(winenter	CAM-ID)'
	    Tell geomview that the mouse cursor is in the window
	    of CAM-ID.	This function is for development purposes
	    and is not intended for general use.

       `(write {command,geometry,camera,transform,window} FILENAME [ID|(ID ...)] [self|world|universe|otherID])'
	    write description of ID in given format to FILENAME.  Last
	    parameter chooses coordinate system for geometry & transform:



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       19





Geomview(5)					      Geomview(5)


	    self: just the object, no transformation or appearance (geometry only)
	    world: the object as positioned within the World.
	    universe: object's position in universal coordinates;
	    includes Worldtransform
	    other ID: the object transformed to otherID's coordinate system.

	    A filename of `-' is a special case: data are written to the
	    stream from which the 'write' command was read.  For external
	    modules, the data are sent to the module's standard input.
	    For commands not read from an external program, `-' means
	    geomview's standard output.	 (See also the `command'
	    command.)

	    The ID can either be a single id or a parenthesized list of
	    ids, like `g0' or `(g2 g1 dodec.off)'.

       `(write-comments FILENAME GEOMID PICKPATH)'
	    write OOGL COMMENT objects in the GEOMID hierarchy at the
		 level of the pick path to FILENAME. Specifically, COMMENTS
		 at level (a b c ... f g) will match pick paths of the form
		 (a b c ... f *) where * includes any value of g, and also
		 any values of possible further indices h,i,j, etc. The pick
		 path (returned in the `pick' command) is a list of
		 integer counters specifying a subpart of a hierarchical
		 OOGL object. Descent into a complex object (LIST or INST)
		 adds a new integer to the path. Traversal of simple objects
		 increments the counter at the current level.
		 Individual COMMENTS are enclosed by curly braces, and the
		 entire string of zero, one, or more COMMENTS (written in
		 the order in which they are encountered during hierarchy
		 traversal) is enclosed by parentheses.

		    Note that arbitrary data can only be passed through the OOGL
		 libraries as full-fledged OOGL COMMENT objects, which can be
		 attached to other OOGL objects via the LIST type as described
		 above. Ordinary comments in OOGL files (i.e. everything after
		 '#' on a line) are ignored at when the file is loaded and
		 cannot be returned.

       `(write-sexpr	 FILENAME LISPOBJECT)'
	    Writes the given LISPOBJECT to FILENAME. This function is intended
	    for internal debugging use only.

       `(xform		ID TRANSFORM)'
	    Concatenate TRANSFORM with the current transform of the object
	    (apply TRANSFORM to object ID).

       `(xform-incr	ID TRANSFORM)'
	    Apply continual motion: concatenate TRANSFORM with the current
	    transform of the object every refresh (set object ID's
	    incremental transform to TRANSFORM).

       `(xform-set	ID TRANSFORM)'
	    Overwrite the current object transform with TRANSFORM (set



Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       20





Geomview(5)					      Geomview(5)


	    object ID's transform to TRANSFORM).

       `(zoom		CAM-ID FACTOR)'
	    Zoom CAM-ID, multiplying its field of view by FACTOR.
	    FACTOR should be a positive number.



       Info file: geomview,    -*-Text-*-
       produced by texinfo-format-buffer
       from file: geomview.tex














































Geometry Center	   Thu Dec 12 02:41:23 CST 1996		       21


