/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  calendar.cc - Gtk::Calendar virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "calendar.hh"
#include "calendarsignals.hh"
#include "private/calendarclass.hh"

using namespace GFC;

/*  Gtk::CalendarSignals
 */

Gtk::CalendarSignals::CalendarSignals(Calendar *calendar)
: WidgetSignals(calendar)
{
	Gtk::CalendarClass::init(GTK_CALENDAR_GET_CLASS(calendar->gtk_calendar()));
}

Gtk::CalendarSignals::~CalendarSignals()
{
}

void
Gtk::CalendarSignals::on_month_changed()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->month_changed)
		g_class->month_changed((GtkCalendar*)instance_);
}

void
Gtk::CalendarSignals::on_day_selected()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->day_selected)
		g_class->day_selected((GtkCalendar*)instance_);
}

void
Gtk::CalendarSignals::on_day_selected_double_click()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->day_selected_double_click)
		g_class->day_selected_double_click((GtkCalendar*)instance_);
}

void
Gtk::CalendarSignals::on_prev_month()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->prev_month)
		g_class->prev_month((GtkCalendar*)instance_);
}

void
Gtk::CalendarSignals::on_next_month()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->next_month)
		g_class->next_month((GtkCalendar*)instance_);
}

void
Gtk::CalendarSignals::on_prev_year()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->prev_year)
		g_class->prev_year((GtkCalendar*)instance_);
}

void
Gtk::CalendarSignals::on_next_year()
{
	GtkCalendarClass *g_class = CalendarClass::get_parent_class(instance_);
	if (g_class->next_year)
		g_class->next_year((GtkCalendar*)instance_);
}

/*  Gtk::CalendarClass
 */

void
Gtk::CalendarClass::init(GtkCalendarClass *g_class)
{
	g_class->month_changed = &month_changed_proxy;
	g_class->day_selected = &day_selected_proxy;
	g_class->day_selected_double_click = &day_selected_double_click_proxy;
	g_class->prev_month = &prev_month_proxy;
	g_class->next_month = &next_month_proxy;
	g_class->prev_year = &prev_year_proxy;
	g_class->next_year = &next_year_proxy;
}

GtkCalendarClass*
Gtk::CalendarClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CALENDAR_GET_CLASS(instance));
	return static_cast<GtkCalendarClass*>(ptr);
}

GType
Gtk::CalendarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CALENDAR);
	}
	return type;
}

void*
Gtk::CalendarClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CalendarClass::month_changed_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_month_changed();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->month_changed)
			g_class->month_changed(calendar);
	}
}

void
Gtk::CalendarClass::day_selected_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_day_selected();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->day_selected)
			g_class->day_selected(calendar);
	}
}

void
Gtk::CalendarClass::day_selected_double_click_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_day_selected_double_click();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->day_selected_double_click)
			g_class->day_selected_double_click(calendar);
	}
}

void
Gtk::CalendarClass::prev_month_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_prev_month();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->prev_month)
			g_class->prev_month(calendar);
	}
}

void
Gtk::CalendarClass::next_month_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_next_month();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->next_month)
			g_class->next_month(calendar);
	}
}

void
Gtk::CalendarClass::prev_year_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_prev_year();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->prev_year)
			g_class->prev_year(calendar);
	}
}

void
Gtk::CalendarClass::next_year_proxy(GtkCalendar *calendar)
{
	void *ptr = g_object_get_qdata((GObject*)calendar, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CalendarSignals*>(ptr)->on_next_year();
	else
	{
		GtkCalendarClass *g_class = CalendarClass::get_parent_class(calendar);
		if (g_class->next_year)
			g_class->next_year(calendar);
	}
}

