/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  colorselectionsignals.cc - Gtk::ColorSelection virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "colorselection.hh"
#include "colorselectionsignals.hh"
#include "private/colorselectionclass.hh"

using namespace GFC;

/*  Gtk::ColorSelectionSignals
 */
 
Gtk::ColorSelectionSignals::ColorSelectionSignals(ColorSelection *color_selection)
: ContainerSignals(color_selection)
{
	Gtk::ColorSelectionClass::init(GTK_COLOR_SELECTION_GET_CLASS(color_selection->gtk_color_selection()));
}

Gtk::ColorSelectionSignals::~ColorSelectionSignals()
{
}

void
Gtk::ColorSelectionSignals::on_color_changed()
{
	GtkColorSelectionClass *g_class = ColorSelectionClass::get_parent_class(instance_);
	if (g_class->color_changed)
		g_class->color_changed((GtkColorSelection*)instance_);
}

/*  Gtk::ColorSelectionClass
 */

void
Gtk::ColorSelectionClass::init(GtkColorSelectionClass *g_class)
{
	g_class->color_changed = &color_changed_proxy;
}

GtkColorSelectionClass*
Gtk::ColorSelectionClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_COLOR_SELECTION_GET_CLASS(instance));
	return static_cast<GtkColorSelectionClass*>(ptr);
}

GType
Gtk::ColorSelectionClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_COLOR_SELECTION);
	}
	return type;
}

void*
Gtk::ColorSelectionClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ColorSelectionClass::color_changed_proxy(GtkColorSelection *color_selection)
{
	void *ptr = g_object_get_qdata((GObject*)color_selection, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ColorSelectionSignals*>(ptr)->on_color_changed();
	else
	{
		GtkColorSelectionClass *g_class = ColorSelectionClass::get_parent_class(color_selection);
		if (g_class->color_changed)
			g_class->color_changed(color_selection);
	}
}

