/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  accelkey.inl - Gtk::AccelKey inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkAccelKey*
GFC::Gtk::AccelKey::gtk_accel_key() const
{
	return const_cast<GtkAccelKey*>(&key_);
}

inline
GFC::Gtk::AccelKey::operator GtkAccelKey* () const
{
	return this ? const_cast<GtkAccelKey*>(&key_) : 0;
}

inline unsigned int
GFC::Gtk::AccelKey::key() const
{
	return key_.accel_key;
}

inline GFC::Gdk::ModifierTypeField
GFC::Gtk::AccelKey::mods() const
{
	return key_.accel_mods;
}

inline GFC::Gtk::AccelFlagsField
GFC::Gtk::AccelKey::flags() const
{
	return key_.accel_flags;
}

