/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  cellrenderertext.inl - Gtk::CellRendererText inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkCellRendererText*
GFC::Gtk::CellRendererText::gtk_cell_renderer_text() const
{
	return reinterpret_cast<GtkCellRendererText*>(instance_);
}

inline GFC::Gtk::CellRendererText::operator GtkCellRendererText* () const
{
	return this ? gtk_cell_renderer_text() : 0;
}

inline void
GFC::Gtk::CellRendererText::set_fixed_height_from_font(int number_of_rows)
{
	gtk_cell_renderer_text_set_fixed_height_from_font(gtk_cell_renderer_text(), number_of_rows);
}

inline const GFC::Gtk::CellRendererText::TextPropertyProxy
GFC::Gtk::CellRendererText::prop_text()
{
	return TextPropertyProxy(this, &text_property);
}

inline const GFC::Gtk::CellRendererText::MarkupPropertyProxy
GFC::Gtk::CellRendererText::prop_markup()
{
	return MarkupPropertyProxy(this, &markup_property);
}

inline const GFC::Gtk::CellRendererText::AttributePropertyProxy
GFC::Gtk::CellRendererText::prop_attribute()
{
	return AttributePropertyProxy(this, &attribute_property);
}

inline const GFC::Gtk::CellRendererText::SingleParagraphModePropertyProxy 
GFC::Gtk::CellRendererText::prop_single_paragraph_mode()
{
	return SingleParagraphModePropertyProxy(this, &single_paragraph_mode_property);
}

inline const GFC::Gtk::CellRendererText::BackgroundPropertyProxy
GFC::Gtk::CellRendererText::prop_background()
{
	return BackgroundPropertyProxy(this, &background_property);
}

inline const GFC::Gtk::CellRendererText::BackgroundGdkPropertyProxy
GFC::Gtk::CellRendererText::prop_background_gdk()
{
	return BackgroundGdkPropertyProxy(this, &background_gdk_property);
}

inline const GFC::Gtk::CellRendererText::ForegroundPropertyProxy
GFC::Gtk::CellRendererText::prop_foreground()
{
	return ForegroundPropertyProxy(this, &foreground_property);
}

inline const GFC::Gtk::CellRendererText::ForegroundGdkPropertyProxy
GFC::Gtk::CellRendererText::prop_foreground_gdk()
{
	return ForegroundGdkPropertyProxy(this, &foreground_gdk_property);
}

inline const GFC::Gtk::CellRendererText::EditablePropertyProxy
GFC::Gtk::CellRendererText::prop_editable()
{
	return EditablePropertyProxy(this, &editable_property);
}

inline const GFC::Gtk::CellRendererText::FontPropertyProxy
GFC::Gtk::CellRendererText::prop_font()
{
	return FontPropertyProxy(this, &font_property);
}

inline const GFC::Gtk::CellRendererText::FontDescPropertyProxy
GFC::Gtk::CellRendererText::prop_font_desc()
{
	return FontDescPropertyProxy(this, &font_desc_property);
}

inline const GFC::Gtk::CellRendererText::FamilyPropertyProxy
GFC::Gtk::CellRendererText::prop_family()
{
	return FamilyPropertyProxy(this, &family_property);
}

inline const GFC::Gtk::CellRendererText::StylePropertyProxy
GFC::Gtk::CellRendererText::prop_style()
{
	return StylePropertyProxy(this, &style_property);
}

inline const GFC::Gtk::CellRendererText::VariantPropertyProxy
GFC::Gtk::CellRendererText::prop_variant()
{
	return VariantPropertyProxy(this, &variant_property);
}

inline const GFC::Gtk::CellRendererText::WeightPropertyProxy
GFC::Gtk::CellRendererText::prop_weight()
{
	return WeightPropertyProxy(this, &weight_property);
}

inline const GFC::Gtk::CellRendererText::StretchPropertyProxy
GFC::Gtk::CellRendererText::prop_stretch()
{
	return StretchPropertyProxy(this, &stretch_property);
}

inline const GFC::Gtk::CellRendererText::SizePropertyProxy
GFC::Gtk::CellRendererText::prop_size()
{
	return SizePropertyProxy(this, &size_property);
}

inline const GFC::Gtk::CellRendererText::SizePointsPropertyProxy
GFC::Gtk::CellRendererText::prop_size_points()
{
	return SizePointsPropertyProxy(this, &size_points_property);
}

inline const GFC::Gtk::CellRendererText::ScalePropertyProxy
GFC::Gtk::CellRendererText::prop_scale()
{
	return ScalePropertyProxy(this, &scale_property);
}

inline const GFC::Gtk::CellRendererText::RisePropertyProxy
GFC::Gtk::CellRendererText::prop_rise()
{
	return RisePropertyProxy(this, &rise_property);
}

inline const GFC::Gtk::CellRendererText::LanguagePropertyProxy 
GFC::Gtk::CellRendererText::prop_language()
{
	return LanguagePropertyProxy(this, &language_property);
}	

inline const GFC::Gtk::CellRendererText::StrikethroughPropertyProxy
GFC::Gtk::CellRendererText::prop_strikethrough()
{
	return StrikethroughPropertyProxy(this, &strikethrough_property);
}

inline const GFC::Gtk::CellRendererText::UnderlinePropertyProxy
GFC::Gtk::CellRendererText::prop_underline()
{
	return UnderlinePropertyProxy(this, &underline_property);
}

inline const GFC::Gtk::CellRendererText::BackgroundSetPropertyProxy
GFC::Gtk::CellRendererText::prop_background_set()
{
	return BackgroundSetPropertyProxy(this, &background_set_property);
}

inline const GFC::Gtk::CellRendererText::ForegroundSetPropertyProxy
GFC::Gtk::CellRendererText::prop_foreground_set()
{
	return ForegroundSetPropertyProxy(this, &foreground_set_property);
}

inline const GFC::Gtk::CellRendererText::EditableSetPropertyProxy
GFC::Gtk::CellRendererText::prop_editable_set()
{
	return EditableSetPropertyProxy(this, &editable_set_property);
}

inline const GFC::Gtk::CellRendererText::FamilySetPropertyProxy
GFC::Gtk::CellRendererText::prop_family_set()
{
	return FamilySetPropertyProxy(this, &family_set_property);
}

inline const GFC::Gtk::CellRendererText::StyleSetPropertyProxy
GFC::Gtk::CellRendererText::prop_style_set()
{
	return StyleSetPropertyProxy(this, &style_set_property);
}

inline const GFC::Gtk::CellRendererText::VariantSetPropertyProxy
GFC::Gtk::CellRendererText::prop_variant_set()
{
	return VariantSetPropertyProxy(this, &variant_set_property);
}

inline const GFC::Gtk::CellRendererText::WeightSetPropertyProxy
GFC::Gtk::CellRendererText::prop_weight_set()
{
	return WeightSetPropertyProxy(this, &weight_set_property);
}

inline const GFC::Gtk::CellRendererText::StretchSetPropertyProxy
GFC::Gtk::CellRendererText::prop_stretch_set()
{
	return StretchSetPropertyProxy(this, &stretch_set_property);
}

inline const GFC::Gtk::CellRendererText::SizeSetPropertyProxy
GFC::Gtk::CellRendererText::prop_size_set()
{
	return SizeSetPropertyProxy(this, &size_set_property);
}

inline const GFC::Gtk::CellRendererText::ScaleSetPropertyProxy
GFC::Gtk::CellRendererText::prop_scale_set()
{
	return ScaleSetPropertyProxy(this, &scale_set_property);
}

inline const GFC::Gtk::CellRendererText::RiseSetPropertyProxy
GFC::Gtk::CellRendererText::prop_rise_set()
{
	return RiseSetPropertyProxy(this, &rise_set_property);
}

inline const GFC::Gtk::CellRendererText::StrikethroughSetPropertyProxy
GFC::Gtk::CellRendererText::prop_strikethrough_set()
{
	return StrikethroughSetPropertyProxy(this, &strikethrough_set_property);
}

inline const GFC::Gtk::CellRendererText::UnderlineSetPropertyProxy
GFC::Gtk::CellRendererText::prop_underline_set()
{
	return UnderlineSetPropertyProxy(this, &underline_set_property);
}

inline const GFC::Gtk::CellRendererText::LanguageSetPropertyProxy 
GFC::Gtk::CellRendererText::prop_language_set()
{
	return LanguageSetPropertyProxy(this, &language_set_property);
}

inline const GFC::Gtk::CellRendererText::EditedSignalProxy
GFC::Gtk::CellRendererText::sig_edited()
{
	return EditedSignalProxy(this, &edited_signal);
}

