/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  socket.inl - Gtk::Socket inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkSocket*
GFC::Gtk::Socket::gtk_socket() const
{
	return reinterpret_cast<GtkSocket*>(instance_);
}

inline GFC::Gtk::Socket::operator GtkSocket* () const
{
	return this ? gtk_socket() : 0;
}

inline bool
GFC::Gtk::Socket::has_plug() const
{
	return GDK_IS_WINDOW(gtk_socket()->plug_window);
}

inline bool
GFC::Gtk::Socket::same_app() const
{
	return gtk_socket()->same_app;
}

inline GdkNativeWindow
GFC::Gtk::Socket::get_id() const
{
	return gtk_socket_get_id(gtk_socket());
}

inline void
GFC::Gtk::Socket::add_id(GdkNativeWindow window_id)
{
	gtk_socket_add_id(gtk_socket(), window_id);
}

inline const GFC::Gtk::Socket::PlugAddedSignalProxy
GFC::Gtk::Socket::sig_plug_added()
{
	return PlugAddedSignalProxy(this, &plug_added_signal);
}

inline const GFC::Gtk::Socket::PlugRemovedSignalProxy
GFC::Gtk::Socket::sig_plug_removed()
{
	return PlugRemovedSignalProxy(this, &plug_removed_signal);
}

