{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 3.10 (Fog) of the OpenGL 1.2.1 specs.
-}

module GL_Fog (
   FogDensity(..), FogSetting(..), fog, Fog(..)
) where

import Foreign          (Ptr, withObject)

import GL_Constants     (gl_FOG_MODE, gl_LINEAR, gl_EXP, gl_EXP2,
                         gl_FOG_START, gl_FOG_END, gl_FOG_DENSITY,
                         gl_FOG_COLOR, gl_FOG_INDEX, gl_FOG)
import GL_BasicTypes    (GLint, GLfloat, GLenum, Capability(..))
import GL_VertexSpec    (Color4(..), ColorIndex(..))

---------------------------------------------------------------------------

data FogDensity =
     FogLinear GLfloat GLfloat
   | FogExp GLfloat
   | FogExp2 GLfloat
   deriving (Eq,Ord)

data FogSetting =
     FogDensity FogDensity
   | FogColor (Color4 GLfloat)
   | FogIndex (ColorIndex GLint)
   deriving (Eq,Ord)

fog :: FogSetting -> IO ()
fog (FogDensity (FogLinear s e)) = do glFogi gl_FOG_MODE gl_LINEAR
                                      glFogf gl_FOG_START s
                                      glFogf gl_FOG_END e
fog (FogDensity (FogExp d))      = do glFogi gl_FOG_MODE gl_EXP
                                      glFogf gl_FOG_DENSITY d
fog (FogDensity (FogExp2 d))     = do glFogi gl_FOG_MODE gl_EXP2
                                      glFogf gl_FOG_DENSITY d
fog (FogColor c)                 = withObject c $ glFogfv gl_FOG_COLOR
fog (FogIndex (ColorIndex x))    = glFogi gl_FOG_INDEX x

foreign import "glFogi"  unsafe glFogi  :: GLenum -> GLint                -> IO ()
foreign import "glFogf"  unsafe glFogf  :: GLenum -> GLfloat              -> IO ()
foreign import "glFogfv" unsafe glFogfv :: GLenum -> Ptr (Color4 GLfloat) -> IO ()

data Fog = Fog deriving (Eq,Ord)

instance Capability Fog where
   marshalCapability Fog = gl_FOG
