{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 2.12 (Current Raster Position) of the
OpenGL 1.2.1 specs.
-}

module GL_RasterPos (
   RasterPos2(..), RasterPos3(..), RasterPos4(..),
   RasterPos(..), RasterPosV(..)
) where

import Foreign          (Ptr, Storable(..))

import GL_BasicTypes    (GLshort, GLint, GLfloat, GLdouble,
                         peek2, peek3, peek4, poke2, poke3, poke4)

---------------------------------------------------------------------------

data RasterPos2 a = RasterPos2 a a

instance Storable a => Storable (RasterPos2 a) where
   sizeOf    ~(RasterPos2 x _) = 2 * sizeOf x
   alignment ~(RasterPos2 x _) = alignment x
   peek                        = peek2 RasterPos2
   poke ptr   (RasterPos2 x y) = poke2 ptr x y

data RasterPos3 a = RasterPos3 a a a

instance Storable a => Storable (RasterPos3 a) where
   sizeOf    ~(RasterPos3 x _ _) = 3 * sizeOf x
   alignment ~(RasterPos3 x _ _) = alignment x
   peek                          = peek3 RasterPos3
   poke ptr   (RasterPos3 x y z) = poke3 ptr x y z

data RasterPos4 a = RasterPos4 a a a a

instance Storable a => Storable (RasterPos4 a) where
   sizeOf    ~(RasterPos4 x _ _ _) = 4 * sizeOf x
   alignment ~(RasterPos4 x _ _ _) = alignment x
   peek                            = peek4 RasterPos4
   poke ptr   (RasterPos4 x y z w) = poke4 ptr x y z w

---------------------------------------------------------------------------

class RasterPos a where
   rasterPos :: a -> IO ()

instance RasterPos (RasterPos2 GLshort ) where
   rasterPos (RasterPos2 x y) = glRasterPos2s x y

instance RasterPos (RasterPos2 GLint   ) where
   rasterPos (RasterPos2 x y) = glRasterPos2i x y

instance RasterPos (RasterPos2 GLfloat ) where
   rasterPos (RasterPos2 x y) = glRasterPos2f x y

instance RasterPos (RasterPos2 GLdouble) where
   rasterPos (RasterPos2 x y) = glRasterPos2d x y

instance RasterPos (RasterPos3 GLshort ) where
   rasterPos (RasterPos3 x y z) = glRasterPos3s x y z

instance RasterPos (RasterPos3 GLint   ) where
   rasterPos (RasterPos3 x y z) = glRasterPos3i x y z

instance RasterPos (RasterPos3 GLfloat ) where
   rasterPos (RasterPos3 x y z) = glRasterPos3f x y z

instance RasterPos (RasterPos3 GLdouble) where
   rasterPos (RasterPos3 x y z) = glRasterPos3d x y z

instance RasterPos (RasterPos4 GLshort ) where
   rasterPos (RasterPos4 x y z w) = glRasterPos4s x y z w

instance RasterPos (RasterPos4 GLint   ) where
   rasterPos (RasterPos4 x y z w) = glRasterPos4i x y z w

instance RasterPos (RasterPos4 GLfloat ) where
   rasterPos (RasterPos4 x y z w) = glRasterPos4f x y z w

instance RasterPos (RasterPos4 GLdouble) where
   rasterPos (RasterPos4 x y z w) = glRasterPos4d x y z w

foreign import "glRasterPos2s" unsafe glRasterPos2s :: GLshort  -> GLshort                          -> IO ()
foreign import "glRasterPos2i" unsafe glRasterPos2i :: GLint    -> GLint                            -> IO ()
foreign import "glRasterPos2f" unsafe glRasterPos2f :: GLfloat  -> GLfloat                          -> IO ()
foreign import "glRasterPos2d" unsafe glRasterPos2d :: GLdouble -> GLdouble                         -> IO ()
foreign import "glRasterPos3s" unsafe glRasterPos3s :: GLshort  -> GLshort  -> GLshort              -> IO ()
foreign import "glRasterPos3i" unsafe glRasterPos3i :: GLint    -> GLint    -> GLint                -> IO ()
foreign import "glRasterPos3f" unsafe glRasterPos3f :: GLfloat  -> GLfloat  -> GLfloat              -> IO ()
foreign import "glRasterPos3d" unsafe glRasterPos3d :: GLdouble -> GLdouble -> GLdouble             -> IO ()
foreign import "glRasterPos4s" unsafe glRasterPos4s :: GLshort  -> GLshort  -> GLshort  -> GLshort  -> IO ()
foreign import "glRasterPos4i" unsafe glRasterPos4i :: GLint    -> GLint    -> GLint    -> GLint    -> IO ()
foreign import "glRasterPos4f" unsafe glRasterPos4f :: GLfloat  -> GLfloat  -> GLfloat  -> GLfloat  -> IO ()
foreign import "glRasterPos4d" unsafe glRasterPos4d :: GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ()

---------------------------------------------------------------------------

class RasterPosV a where
   rasterPosV :: Ptr a -> IO ()

instance RasterPosV (RasterPos2 GLshort ) where
   rasterPosV = glRasterPos2sv

instance RasterPosV (RasterPos2 GLint   ) where
   rasterPosV = glRasterPos2iv

instance RasterPosV (RasterPos2 GLfloat ) where
   rasterPosV = glRasterPos2fv

instance RasterPosV (RasterPos2 GLdouble) where
   rasterPosV = glRasterPos2dv

instance RasterPosV (RasterPos3 GLshort ) where
   rasterPosV = glRasterPos3sv

instance RasterPosV (RasterPos3 GLint   ) where
   rasterPosV = glRasterPos3iv

instance RasterPosV (RasterPos3 GLfloat ) where
   rasterPosV = glRasterPos3fv

instance RasterPosV (RasterPos3 GLdouble) where
   rasterPosV = glRasterPos3dv

instance RasterPosV (RasterPos4 GLshort ) where
   rasterPosV = glRasterPos4sv

instance RasterPosV (RasterPos4 GLint   ) where
   rasterPosV = glRasterPos4iv

instance RasterPosV (RasterPos4 GLfloat ) where
   rasterPosV = glRasterPos4fv

instance RasterPosV (RasterPos4 GLdouble) where
   rasterPosV = glRasterPos4dv

foreign import "glRasterPos2sv" unsafe glRasterPos2sv :: Ptr (RasterPos2 GLshort ) -> IO ()
foreign import "glRasterPos2iv" unsafe glRasterPos2iv :: Ptr (RasterPos2 GLint   ) -> IO ()
foreign import "glRasterPos2fv" unsafe glRasterPos2fv :: Ptr (RasterPos2 GLfloat ) -> IO ()
foreign import "glRasterPos2dv" unsafe glRasterPos2dv :: Ptr (RasterPos2 GLdouble) -> IO ()
foreign import "glRasterPos3sv" unsafe glRasterPos3sv :: Ptr (RasterPos3 GLshort ) -> IO ()
foreign import "glRasterPos3iv" unsafe glRasterPos3iv :: Ptr (RasterPos3 GLint   ) -> IO ()
foreign import "glRasterPos3fv" unsafe glRasterPos3fv :: Ptr (RasterPos3 GLfloat ) -> IO ()
foreign import "glRasterPos3dv" unsafe glRasterPos3dv :: Ptr (RasterPos3 GLdouble) -> IO ()
foreign import "glRasterPos4sv" unsafe glRasterPos4sv :: Ptr (RasterPos4 GLshort ) -> IO ()
foreign import "glRasterPos4iv" unsafe glRasterPos4iv :: Ptr (RasterPos4 GLint   ) -> IO ()
foreign import "glRasterPos4fv" unsafe glRasterPos4fv :: Ptr (RasterPos4 GLfloat ) -> IO ()
foreign import "glRasterPos4dv" unsafe glRasterPos4dv :: Ptr (RasterPos4 GLdouble) -> IO ()
