% -----------------------------------------------------------------------------
% $Id: MarshalUtils.lhs,v 1.5 2001/01/11 17:25:58 simonmar Exp $
%
% (c) The FFI task force, 2000
%

Utilities for primitive marshaling

\begin{code}
module MarshalUtils (

  -- combined allocation and marshalling
  --
  withObject,    -- :: Storable a => a -> (Ptr a -> IO b) -> IO b
  {- FIXME: should be `with' -}
  new,           -- :: Storable a => a -> IO (Ptr a)

  -- marshalling of Boolean values (non-zero corresponds to `True')
  --
  fromBool,      -- :: Num a => Bool -> a
  toBool,	 -- :: Num a => a -> Bool

  -- marshalling of Maybe values
  --
  maybeNew,      -- :: (      a -> IO (Ptr a))
		 -- -> (Maybe a -> IO (Ptr a))
  maybeWith,     -- :: (      a -> (Ptr b -> IO c) -> IO c) 
		 -- -> (Maybe a -> (Ptr b -> IO c) -> IO c)
  maybePeek,     -- :: (Ptr a -> IO        b ) 
		 -- -> (Ptr a -> IO (Maybe b))

  -- marshalling lists of storable objects
  --
  withMany,      -- :: (a -> (b -> res) -> res) -> [a] -> ([b] -> res) -> res

  -- Haskellish interface to memcpy and memmove
  -- (argument order: destination, source)
  --
  copyBytes,     -- :: Ptr a -> Ptr a -> Int -> IO ()
  moveBytes      -- :: Ptr a -> Ptr a -> Int -> IO ()
) where

import PrelMarshalUtils
\end{code}
