module StdControlDef ( module StdControlDef
                     , module StdIOCommon
                     , module StdGUI
                     ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdControlDef contains the types to define the standard set of controls.
--	********************************************************************************


import StdGUI
import StdIOCommon
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


data	ButtonControl IF_MVAR(,ls ps)
 =	ButtonControl String                      [ControlAttribute IF_MVAR(,ls ps)]
data	EditControl   IF_MVAR(,ls ps)
 =	EditControl   String ControlWidth NrLines [ControlAttribute IF_MVAR(,ls ps)]
data	TextControl   IF_MVAR(,ls ps)
 =	TextControl   String                      [ControlAttribute IF_MVAR(,ls ps)]

type	NrLines
 =	Int
data	RowsOrColumns
	= Rows       Int
	| Columns    Int
data	ControlWidth                                -- The width of the control:
 =	PixelWidth   Int                            -- the exact number of pixels
 |	TextWidth    String                         -- the exact string width in dialog font
 |	ContentWidth String                         -- width of the control as if string is its content

data	ControlAttribute IF_MVAR(,ls ps)            -- Default:
 -- General control attributes:
 =	ControlFunction (GUIFun IF_MVAR((),ls ps))  -- (\st->return st)
 |	ControlId       Id                          -- no id
 |	ControlKeyboard KeyboardStateFilter SelectState IF_MVAR(KeyboardFunction,(KeyboardFunction ls ps))
	                                            -- no keyboard input/overruled
 |	ControlModsFunction (ModifiersFunction IF_MVAR(,ls ps))
                                                    -- ControlFunction
 |	ControlPos      ItemPos                     -- (RightTo previous,zero)
 |	ControlWidth    ControlWidth                -- system derived
