{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include <commctrl.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "Win32Control_stub_ffi.h" #-}
module Win32Control where

import StdDIS
import Win32Types
import GDITypes
import Win32Window
import Win32WinMessage


-- Bindings to the various standard Win32 controls


-- == Command buttons

type ButtonStyle   = WindowStyle

bS_PUSHBUTTON :: ButtonStyle
bS_PUSHBUTTON =
  unsafePerformIO(
    prim_bS_PUSHBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_PUSHBUTTON" unsafe prim_bS_PUSHBUTTON :: IO (Word32)
bS_DEFPUSHBUTTON :: ButtonStyle
bS_DEFPUSHBUTTON =
  unsafePerformIO(
    prim_bS_DEFPUSHBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_DEFPUSHBUTTON" unsafe prim_bS_DEFPUSHBUTTON :: IO (Word32)
bS_CHECKBOX :: ButtonStyle
bS_CHECKBOX =
  unsafePerformIO(
    prim_bS_CHECKBOX
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_CHECKBOX" unsafe prim_bS_CHECKBOX :: IO (Word32)
bS_AUTOCHECKBOX :: ButtonStyle
bS_AUTOCHECKBOX =
  unsafePerformIO(
    prim_bS_AUTOCHECKBOX
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_AUTOCHECKBOX" unsafe prim_bS_AUTOCHECKBOX :: IO (Word32)
bS_RADIOBUTTON :: ButtonStyle
bS_RADIOBUTTON =
  unsafePerformIO(
    prim_bS_RADIOBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_RADIOBUTTON" unsafe prim_bS_RADIOBUTTON :: IO (Word32)
bS_3STATE :: ButtonStyle
bS_3STATE =
  unsafePerformIO(
    prim_bS_3STATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_3STATE" unsafe prim_bS_3STATE :: IO (Word32)
bS_AUTO3STATE :: ButtonStyle
bS_AUTO3STATE =
  unsafePerformIO(
    prim_bS_AUTO3STATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_AUTO3STATE" unsafe prim_bS_AUTO3STATE :: IO (Word32)
bS_GROUPBOX :: ButtonStyle
bS_GROUPBOX =
  unsafePerformIO(
    prim_bS_GROUPBOX
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_GROUPBOX" unsafe prim_bS_GROUPBOX :: IO (Word32)
bS_AUTORADIOBUTTON :: ButtonStyle
bS_AUTORADIOBUTTON =
  unsafePerformIO(
    prim_bS_AUTORADIOBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_AUTORADIOBUTTON" unsafe prim_bS_AUTORADIOBUTTON :: IO (Word32)
bS_OWNERDRAW :: ButtonStyle
bS_OWNERDRAW =
  unsafePerformIO(
    prim_bS_OWNERDRAW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_OWNERDRAW" unsafe prim_bS_OWNERDRAW :: IO (Word32)
bS_LEFTTEXT :: ButtonStyle
bS_LEFTTEXT =
  unsafePerformIO(
    prim_bS_LEFTTEXT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_LEFTTEXT" unsafe prim_bS_LEFTTEXT :: IO (Word32)
bS_USERBUTTON :: ButtonStyle
bS_USERBUTTON =
  unsafePerformIO(
    prim_bS_USERBUTTON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bS_USERBUTTON" unsafe prim_bS_USERBUTTON :: IO (Word32)

createButton :: String -> WindowStyle -> ButtonStyle -> MbPos -> MbPos -> MbPos -> MbPos -> MbHWND -> MbHMENU -> HANDLE -> IO HWND
createButton gc_arg1 wstyle bstyle x y w h parent hmenu handle =
  (marshall_string_ gc_arg1) >>= \ (nm) ->
  (case x of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just x) -> (return ((x)))
   }) >>= \ (x) ->
  (case y of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just y) -> (return ((y)))
   }) >>= \ (y) ->
  (case w of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just w) -> (return ((w)))
   }) >>= \ (w) ->
  (case h of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just h) -> (return ((h)))
   }) >>= \ (h) ->
  (case parent of {
      Nothing -> (return (nullHANDLE));
      (Just parent) -> (return ((parent)))
   }) >>= \ (parent) ->
  (case hmenu of {
      Nothing -> (return (nullHANDLE));
      (Just hmenu) -> (return ((hmenu)))
   }) >>= \ (hmenu) ->
  prim_createButton nm wstyle bstyle x y w h parent hmenu handle
  >>= \ gc_result ->
  access_prim_createButton_hwnd (gc_result :: Addr) >>= \ hwnd ->
  access_prim_createButton_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createButton_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (hwnd))
foreign import  ccall "prim_createButton" unsafe prim_createButton :: Addr -> Word32 -> Word32 -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createButton_hwnd" unsafe access_prim_createButton_hwnd :: Addr -> IO (Addr)
foreign import ccall "access_prim_createButton_gc_failed" unsafe access_prim_createButton_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createButton_gc_failstring" unsafe access_prim_createButton_gc_failstring :: Addr -> IO (Addr)

type ButtonState = UINT

bST_CHECKED :: ButtonState
bST_CHECKED =
  unsafePerformIO(
    prim_bST_CHECKED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bST_CHECKED" unsafe prim_bST_CHECKED :: IO (Word32)
bST_INDETERMINATE :: ButtonState
bST_INDETERMINATE =
  unsafePerformIO(
    prim_bST_INDETERMINATE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bST_INDETERMINATE" unsafe prim_bST_INDETERMINATE :: IO (Word32)
bST_UNCHECKED :: ButtonState
bST_UNCHECKED =
  unsafePerformIO(
    prim_bST_UNCHECKED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bST_UNCHECKED" unsafe prim_bST_UNCHECKED :: IO (Word32)

checkDlgButton :: HWND -> Int -> ButtonState -> IO ()
checkDlgButton arg1 arg2 arg3 =
  prim_checkDlgButton arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_checkDlgButton_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_checkDlgButton_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_checkDlgButton" unsafe prim_checkDlgButton :: Addr -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_checkDlgButton_gc_failed" unsafe access_prim_checkDlgButton_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_checkDlgButton_gc_failstring" unsafe access_prim_checkDlgButton_gc_failstring :: Addr -> IO (Addr)

checkRadioButton :: HWND -> Int -> Int -> Int -> IO ()
checkRadioButton arg1 arg2 arg3 arg4 =
  prim_checkRadioButton arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_checkRadioButton_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_checkRadioButton_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_checkRadioButton" unsafe prim_checkRadioButton :: Addr -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_checkRadioButton_gc_failed" unsafe access_prim_checkRadioButton_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_checkRadioButton_gc_failstring" unsafe access_prim_checkRadioButton_gc_failstring :: Addr -> IO (Addr)

isDlgButtonChecked :: HWND -> Int -> IO ButtonState
isDlgButtonChecked arg1 arg2 =
  prim_isDlgButtonChecked arg1 arg2
  >>= \ gc_result ->
  access_prim_isDlgButtonChecked_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_isDlgButtonChecked_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_isDlgButtonChecked_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_isDlgButtonChecked" unsafe prim_isDlgButtonChecked :: Addr -> Int -> IO (Addr)
foreign import ccall "access_prim_isDlgButtonChecked_res1" unsafe access_prim_isDlgButtonChecked_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_isDlgButtonChecked_gc_failed" unsafe access_prim_isDlgButtonChecked_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_isDlgButtonChecked_gc_failstring" unsafe access_prim_isDlgButtonChecked_gc_failstring :: Addr -> IO (Addr)


-- == ComboBoxes aka. pop up list boxes/selectors.

type ComboBoxStyle = WindowStyle

cBS_SIMPLE :: ComboBoxStyle
cBS_SIMPLE =
  unsafePerformIO(
    prim_cBS_SIMPLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_SIMPLE" unsafe prim_cBS_SIMPLE :: IO (Word32)
cBS_DROPDOWN :: ComboBoxStyle
cBS_DROPDOWN =
  unsafePerformIO(
    prim_cBS_DROPDOWN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_DROPDOWN" unsafe prim_cBS_DROPDOWN :: IO (Word32)
cBS_DROPDOWNLIST :: ComboBoxStyle
cBS_DROPDOWNLIST =
  unsafePerformIO(
    prim_cBS_DROPDOWNLIST
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_DROPDOWNLIST" unsafe prim_cBS_DROPDOWNLIST :: IO (Word32)
cBS_OWNERDRAWFIXED :: ComboBoxStyle
cBS_OWNERDRAWFIXED =
  unsafePerformIO(
    prim_cBS_OWNERDRAWFIXED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_OWNERDRAWFIXED" unsafe prim_cBS_OWNERDRAWFIXED :: IO (Word32)
cBS_OWNERDRAWVARIABLE :: ComboBoxStyle
cBS_OWNERDRAWVARIABLE =
  unsafePerformIO(
    prim_cBS_OWNERDRAWVARIABLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_OWNERDRAWVARIABLE" unsafe prim_cBS_OWNERDRAWVARIABLE :: IO (Word32)
cBS_AUTOHSCROLL :: ComboBoxStyle
cBS_AUTOHSCROLL =
  unsafePerformIO(
    prim_cBS_AUTOHSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_AUTOHSCROLL" unsafe prim_cBS_AUTOHSCROLL :: IO (Word32)
cBS_OEMCONVERT :: ComboBoxStyle
cBS_OEMCONVERT =
  unsafePerformIO(
    prim_cBS_OEMCONVERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_OEMCONVERT" unsafe prim_cBS_OEMCONVERT :: IO (Word32)
cBS_SORT :: ComboBoxStyle
cBS_SORT =
  unsafePerformIO(
    prim_cBS_SORT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_SORT" unsafe prim_cBS_SORT :: IO (Word32)
cBS_HASSTRINGS :: ComboBoxStyle
cBS_HASSTRINGS =
  unsafePerformIO(
    prim_cBS_HASSTRINGS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_HASSTRINGS" unsafe prim_cBS_HASSTRINGS :: IO (Word32)
cBS_NOINTEGRALHEIGHT :: ComboBoxStyle
cBS_NOINTEGRALHEIGHT =
  unsafePerformIO(
    prim_cBS_NOINTEGRALHEIGHT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_NOINTEGRALHEIGHT" unsafe prim_cBS_NOINTEGRALHEIGHT :: IO (Word32)
cBS_DISABLENOSCROLL :: ComboBoxStyle
cBS_DISABLENOSCROLL =
  unsafePerformIO(
    prim_cBS_DISABLENOSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBS_DISABLENOSCROLL" unsafe prim_cBS_DISABLENOSCROLL :: IO (Word32)

createComboBox :: String -> WindowStyle -> ComboBoxStyle -> MbPos -> MbPos -> MbPos -> MbPos -> HWND -> MbHMENU -> HANDLE -> IO HWND
createComboBox gc_arg1 wstyle cstyle x y w h parent hmenu handle =
  (marshall_string_ gc_arg1) >>= \ (nm) ->
  (case x of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just x) -> (return ((x)))
   }) >>= \ (x) ->
  (case y of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just y) -> (return ((y)))
   }) >>= \ (y) ->
  (case w of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just w) -> (return ((w)))
   }) >>= \ (w) ->
  (case h of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just h) -> (return ((h)))
   }) >>= \ (h) ->
  (case hmenu of {
      Nothing -> (return (nullHANDLE));
      (Just hmenu) -> (return ((hmenu)))
   }) >>= \ (hmenu) ->
  prim_createComboBox nm wstyle cstyle x y w h parent hmenu handle
  >>= \ gc_result ->
  access_prim_createComboBox_hwnd (gc_result :: Addr) >>= \ hwnd ->
  access_prim_createComboBox_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createComboBox_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (hwnd))
foreign import  ccall "prim_createComboBox" unsafe prim_createComboBox :: Addr -> Word32 -> Word32 -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createComboBox_hwnd" unsafe access_prim_createComboBox_hwnd :: Addr -> IO (Addr)
foreign import ccall "access_prim_createComboBox_gc_failed" unsafe access_prim_createComboBox_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createComboBox_gc_failstring" unsafe access_prim_createComboBox_gc_failstring :: Addr -> IO (Addr)

-- see comment about freeing windowNames in Win32Window.createWindow
-- %end free(nm)


--- == Edit controls

----------------------------------------------------------------

type EditStyle = WindowStyle

eS_LEFT :: EditStyle
eS_LEFT =
  unsafePerformIO(
    prim_eS_LEFT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_LEFT" unsafe prim_eS_LEFT :: IO (Word32)
eS_CENTER :: EditStyle
eS_CENTER =
  unsafePerformIO(
    prim_eS_CENTER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_CENTER" unsafe prim_eS_CENTER :: IO (Word32)
eS_RIGHT :: EditStyle
eS_RIGHT =
  unsafePerformIO(
    prim_eS_RIGHT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_RIGHT" unsafe prim_eS_RIGHT :: IO (Word32)
eS_MULTILINE :: EditStyle
eS_MULTILINE =
  unsafePerformIO(
    prim_eS_MULTILINE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_MULTILINE" unsafe prim_eS_MULTILINE :: IO (Word32)
eS_UPPERCASE :: EditStyle
eS_UPPERCASE =
  unsafePerformIO(
    prim_eS_UPPERCASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_UPPERCASE" unsafe prim_eS_UPPERCASE :: IO (Word32)
eS_LOWERCASE :: EditStyle
eS_LOWERCASE =
  unsafePerformIO(
    prim_eS_LOWERCASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_LOWERCASE" unsafe prim_eS_LOWERCASE :: IO (Word32)
eS_PASSWORD :: EditStyle
eS_PASSWORD =
  unsafePerformIO(
    prim_eS_PASSWORD
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_PASSWORD" unsafe prim_eS_PASSWORD :: IO (Word32)
eS_AUTOVSCROLL :: EditStyle
eS_AUTOVSCROLL =
  unsafePerformIO(
    prim_eS_AUTOVSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_AUTOVSCROLL" unsafe prim_eS_AUTOVSCROLL :: IO (Word32)
eS_AUTOHSCROLL :: EditStyle
eS_AUTOHSCROLL =
  unsafePerformIO(
    prim_eS_AUTOHSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_AUTOHSCROLL" unsafe prim_eS_AUTOHSCROLL :: IO (Word32)
eS_NOHIDESEL :: EditStyle
eS_NOHIDESEL =
  unsafePerformIO(
    prim_eS_NOHIDESEL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_NOHIDESEL" unsafe prim_eS_NOHIDESEL :: IO (Word32)
eS_OEMCONVERT :: EditStyle
eS_OEMCONVERT =
  unsafePerformIO(
    prim_eS_OEMCONVERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_OEMCONVERT" unsafe prim_eS_OEMCONVERT :: IO (Word32)
eS_READONLY :: EditStyle
eS_READONLY =
  unsafePerformIO(
    prim_eS_READONLY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_READONLY" unsafe prim_eS_READONLY :: IO (Word32)
eS_WANTRETURN :: EditStyle
eS_WANTRETURN =
  unsafePerformIO(
    prim_eS_WANTRETURN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_eS_WANTRETURN" unsafe prim_eS_WANTRETURN :: IO (Word32)

createEditWindow :: String -> WindowStyle -> EditStyle -> MbPos -> MbPos -> MbPos -> MbPos -> HWND -> MbHMENU -> HANDLE -> IO HWND
createEditWindow gc_arg1 wstyle estyle x y w h parent hmenu handle =
  (marshall_string_ gc_arg1) >>= \ (nm) ->
  (case x of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just x) -> (return ((x)))
   }) >>= \ (x) ->
  (case y of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just y) -> (return ((y)))
   }) >>= \ (y) ->
  (case w of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just w) -> (return ((w)))
   }) >>= \ (w) ->
  (case h of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just h) -> (return ((h)))
   }) >>= \ (h) ->
  (case hmenu of {
      Nothing -> (return (nullHANDLE));
      (Just hmenu) -> (return ((hmenu)))
   }) >>= \ (hmenu) ->
  prim_createEditWindow nm wstyle estyle x y w h parent hmenu handle
  >>= \ gc_result ->
  access_prim_createEditWindow_hwnd (gc_result :: Addr) >>= \ hwnd ->
  access_prim_createEditWindow_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createEditWindow_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (hwnd))
foreign import  ccall "prim_createEditWindow" unsafe prim_createEditWindow :: Addr -> Word32 -> Word32 -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createEditWindow_hwnd" unsafe access_prim_createEditWindow_hwnd :: Addr -> IO (Addr)
foreign import ccall "access_prim_createEditWindow_gc_failed" unsafe access_prim_createEditWindow_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createEditWindow_gc_failstring" unsafe access_prim_createEditWindow_gc_failstring :: Addr -> IO (Addr)

-- see comment about freeing windowNames in Win32Window.createWindow
-- %end free(nm)

-- == List boxes


----------------------------------------------------------------

type ListBoxStyle   = WindowStyle

lBS_NOTIFY :: ListBoxStyle
lBS_NOTIFY =
  unsafePerformIO(
    prim_lBS_NOTIFY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_NOTIFY" unsafe prim_lBS_NOTIFY :: IO (Word32)
lBS_SORT :: ListBoxStyle
lBS_SORT =
  unsafePerformIO(
    prim_lBS_SORT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_SORT" unsafe prim_lBS_SORT :: IO (Word32)
lBS_NOREDRAW :: ListBoxStyle
lBS_NOREDRAW =
  unsafePerformIO(
    prim_lBS_NOREDRAW
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_NOREDRAW" unsafe prim_lBS_NOREDRAW :: IO (Word32)
lBS_MULTIPLESEL :: ListBoxStyle
lBS_MULTIPLESEL =
  unsafePerformIO(
    prim_lBS_MULTIPLESEL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_MULTIPLESEL" unsafe prim_lBS_MULTIPLESEL :: IO (Word32)
lBS_OWNERDRAWFIXED :: ListBoxStyle
lBS_OWNERDRAWFIXED =
  unsafePerformIO(
    prim_lBS_OWNERDRAWFIXED
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_OWNERDRAWFIXED" unsafe prim_lBS_OWNERDRAWFIXED :: IO (Word32)
lBS_OWNERDRAWVARIABLE :: ListBoxStyle
lBS_OWNERDRAWVARIABLE =
  unsafePerformIO(
    prim_lBS_OWNERDRAWVARIABLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_OWNERDRAWVARIABLE" unsafe prim_lBS_OWNERDRAWVARIABLE :: IO (Word32)
lBS_HASSTRINGS :: ListBoxStyle
lBS_HASSTRINGS =
  unsafePerformIO(
    prim_lBS_HASSTRINGS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_HASSTRINGS" unsafe prim_lBS_HASSTRINGS :: IO (Word32)
lBS_USETABSTOPS :: ListBoxStyle
lBS_USETABSTOPS =
  unsafePerformIO(
    prim_lBS_USETABSTOPS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_USETABSTOPS" unsafe prim_lBS_USETABSTOPS :: IO (Word32)
lBS_NOINTEGRALHEIGHT :: ListBoxStyle
lBS_NOINTEGRALHEIGHT =
  unsafePerformIO(
    prim_lBS_NOINTEGRALHEIGHT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_NOINTEGRALHEIGHT" unsafe prim_lBS_NOINTEGRALHEIGHT :: IO (Word32)
lBS_MULTICOLUMN :: ListBoxStyle
lBS_MULTICOLUMN =
  unsafePerformIO(
    prim_lBS_MULTICOLUMN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_MULTICOLUMN" unsafe prim_lBS_MULTICOLUMN :: IO (Word32)
lBS_WANTKEYBOARDINPUT :: ListBoxStyle
lBS_WANTKEYBOARDINPUT =
  unsafePerformIO(
    prim_lBS_WANTKEYBOARDINPUT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_WANTKEYBOARDINPUT" unsafe prim_lBS_WANTKEYBOARDINPUT :: IO (Word32)
lBS_DISABLENOSCROLL :: ListBoxStyle
lBS_DISABLENOSCROLL =
  unsafePerformIO(
    prim_lBS_DISABLENOSCROLL
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_DISABLENOSCROLL" unsafe prim_lBS_DISABLENOSCROLL :: IO (Word32)
lBS_STANDARD :: ListBoxStyle
lBS_STANDARD =
  unsafePerformIO(
    prim_lBS_STANDARD
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_lBS_STANDARD" unsafe prim_lBS_STANDARD :: IO (Word32)

createListBox :: String -> WindowStyle -> ListBoxStyle -> MbPos -> MbPos -> MbPos -> MbPos -> HWND -> MbHMENU -> HANDLE -> IO HWND
createListBox gc_arg1 wstyle lstyle x y w h parent hmenu handle =
  (marshall_string_ gc_arg1) >>= \ (nm) ->
  (case x of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just x) -> (return ((x)))
   }) >>= \ (x) ->
  (case y of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just y) -> (return ((y)))
   }) >>= \ (y) ->
  (case w of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just w) -> (return ((w)))
   }) >>= \ (w) ->
  (case h of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just h) -> (return ((h)))
   }) >>= \ (h) ->
  (case hmenu of {
      Nothing -> (return (nullHANDLE));
      (Just hmenu) -> (return ((hmenu)))
   }) >>= \ (hmenu) ->
  prim_createListBox nm wstyle lstyle x y w h parent hmenu handle
  >>= \ gc_result ->
  access_prim_createListBox_hwnd (gc_result :: Addr) >>= \ hwnd ->
  access_prim_createListBox_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createListBox_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (hwnd))
foreign import  ccall "prim_createListBox" unsafe prim_createListBox :: Addr -> Word32 -> Word32 -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createListBox_hwnd" unsafe access_prim_createListBox_hwnd :: Addr -> IO (Addr)
foreign import ccall "access_prim_createListBox_gc_failed" unsafe access_prim_createListBox_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createListBox_gc_failstring" unsafe access_prim_createListBox_gc_failstring :: Addr -> IO (Addr)

-- see comment about freeing windowNames in Win32Window.createWindow
-- %end free(nm)

-- == Scrollbars


----------------------------------------------------------------

type ScrollbarStyle = WindowStyle

sBS_HORZ :: ScrollbarStyle
sBS_HORZ =
  unsafePerformIO(
    prim_sBS_HORZ
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_HORZ" unsafe prim_sBS_HORZ :: IO (Word32)
sBS_TOPALIGN :: ScrollbarStyle
sBS_TOPALIGN =
  unsafePerformIO(
    prim_sBS_TOPALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_TOPALIGN" unsafe prim_sBS_TOPALIGN :: IO (Word32)
sBS_BOTTOMALIGN :: ScrollbarStyle
sBS_BOTTOMALIGN =
  unsafePerformIO(
    prim_sBS_BOTTOMALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_BOTTOMALIGN" unsafe prim_sBS_BOTTOMALIGN :: IO (Word32)
sBS_VERT :: ScrollbarStyle
sBS_VERT =
  unsafePerformIO(
    prim_sBS_VERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_VERT" unsafe prim_sBS_VERT :: IO (Word32)
sBS_LEFTALIGN :: ScrollbarStyle
sBS_LEFTALIGN =
  unsafePerformIO(
    prim_sBS_LEFTALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_LEFTALIGN" unsafe prim_sBS_LEFTALIGN :: IO (Word32)
sBS_RIGHTALIGN :: ScrollbarStyle
sBS_RIGHTALIGN =
  unsafePerformIO(
    prim_sBS_RIGHTALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_RIGHTALIGN" unsafe prim_sBS_RIGHTALIGN :: IO (Word32)
sBS_SIZEBOX :: ScrollbarStyle
sBS_SIZEBOX =
  unsafePerformIO(
    prim_sBS_SIZEBOX
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_SIZEBOX" unsafe prim_sBS_SIZEBOX :: IO (Word32)
sBS_SIZEBOXTOPLEFTALIGN :: ScrollbarStyle
sBS_SIZEBOXTOPLEFTALIGN =
  unsafePerformIO(
    prim_sBS_SIZEBOXTOPLEFTALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_SIZEBOXTOPLEFTALIGN" unsafe prim_sBS_SIZEBOXTOPLEFTALIGN :: IO (Word32)
sBS_SIZEBOXBOTTOMRIGHTALIGN :: ScrollbarStyle
sBS_SIZEBOXBOTTOMRIGHTALIGN =
  unsafePerformIO(
    prim_sBS_SIZEBOXBOTTOMRIGHTALIGN
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sBS_SIZEBOXBOTTOMRIGHTALIGN" unsafe prim_sBS_SIZEBOXBOTTOMRIGHTALIGN :: IO (Word32)

createScrollbar :: String -> WindowStyle -> ScrollbarStyle -> MbPos -> MbPos -> MbPos -> MbPos -> HWND -> MbHMENU -> HANDLE -> IO HWND
createScrollbar gc_arg1 wstyle sstyle x y w h parent hmenu handle =
  (marshall_string_ gc_arg1) >>= \ (nm) ->
  (case x of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just x) -> (return ((x)))
   }) >>= \ (x) ->
  (case y of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just y) -> (return ((y)))
   }) >>= \ (y) ->
  (case w of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just w) -> (return ((w)))
   }) >>= \ (w) ->
  (case h of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just h) -> (return ((h)))
   }) >>= \ (h) ->
  (case hmenu of {
      Nothing -> (return (nullHANDLE));
      (Just hmenu) -> (return ((hmenu)))
   }) >>= \ (hmenu) ->
  prim_createScrollbar nm wstyle sstyle x y w h parent hmenu handle
  >>= \ gc_result ->
  access_prim_createScrollbar_hwnd (gc_result :: Addr) >>= \ hwnd ->
  access_prim_createScrollbar_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createScrollbar_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (hwnd))
foreign import  ccall "prim_createScrollbar" unsafe prim_createScrollbar :: Addr -> Word32 -> Word32 -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createScrollbar_hwnd" unsafe access_prim_createScrollbar_hwnd :: Addr -> IO (Addr)
foreign import ccall "access_prim_createScrollbar_gc_failed" unsafe access_prim_createScrollbar_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createScrollbar_gc_failstring" unsafe access_prim_createScrollbar_gc_failstring :: Addr -> IO (Addr)

-- see comment about freeing windowNames in Win32Window.createWindow
-- %end free(nm)

-- == Static controls aka. labels


----------------------------------------------------------------

type StaticControlStyle = WindowStyle

sS_LEFT :: StaticControlStyle
sS_LEFT =
  unsafePerformIO(
    prim_sS_LEFT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_LEFT" unsafe prim_sS_LEFT :: IO (Word32)
sS_CENTER :: StaticControlStyle
sS_CENTER =
  unsafePerformIO(
    prim_sS_CENTER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_CENTER" unsafe prim_sS_CENTER :: IO (Word32)
sS_RIGHT :: StaticControlStyle
sS_RIGHT =
  unsafePerformIO(
    prim_sS_RIGHT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_RIGHT" unsafe prim_sS_RIGHT :: IO (Word32)
sS_ICON :: StaticControlStyle
sS_ICON =
  unsafePerformIO(
    prim_sS_ICON
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_ICON" unsafe prim_sS_ICON :: IO (Word32)
sS_BLACKRECT :: StaticControlStyle
sS_BLACKRECT =
  unsafePerformIO(
    prim_sS_BLACKRECT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_BLACKRECT" unsafe prim_sS_BLACKRECT :: IO (Word32)
sS_GRAYRECT :: StaticControlStyle
sS_GRAYRECT =
  unsafePerformIO(
    prim_sS_GRAYRECT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_GRAYRECT" unsafe prim_sS_GRAYRECT :: IO (Word32)
sS_WHITERECT :: StaticControlStyle
sS_WHITERECT =
  unsafePerformIO(
    prim_sS_WHITERECT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_WHITERECT" unsafe prim_sS_WHITERECT :: IO (Word32)
sS_BLACKFRAME :: StaticControlStyle
sS_BLACKFRAME =
  unsafePerformIO(
    prim_sS_BLACKFRAME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_BLACKFRAME" unsafe prim_sS_BLACKFRAME :: IO (Word32)
sS_GRAYFRAME :: StaticControlStyle
sS_GRAYFRAME =
  unsafePerformIO(
    prim_sS_GRAYFRAME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_GRAYFRAME" unsafe prim_sS_GRAYFRAME :: IO (Word32)
sS_WHITEFRAME :: StaticControlStyle
sS_WHITEFRAME =
  unsafePerformIO(
    prim_sS_WHITEFRAME
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_WHITEFRAME" unsafe prim_sS_WHITEFRAME :: IO (Word32)
sS_SIMPLE :: StaticControlStyle
sS_SIMPLE =
  unsafePerformIO(
    prim_sS_SIMPLE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_SIMPLE" unsafe prim_sS_SIMPLE :: IO (Word32)
sS_LEFTNOWORDWRAP :: StaticControlStyle
sS_LEFTNOWORDWRAP =
  unsafePerformIO(
    prim_sS_LEFTNOWORDWRAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_LEFTNOWORDWRAP" unsafe prim_sS_LEFTNOWORDWRAP :: IO (Word32)
sS_NOPREFIX :: StaticControlStyle
sS_NOPREFIX =
  unsafePerformIO(
    prim_sS_NOPREFIX
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sS_NOPREFIX" unsafe prim_sS_NOPREFIX :: IO (Word32)

createStaticWindow :: String -> WindowStyle -> StaticControlStyle -> MbPos -> MbPos -> MbPos -> MbPos -> HWND -> MbHMENU -> HANDLE -> IO HWND
createStaticWindow gc_arg1 wstyle sstyle x y w h parent hmenu handle =
  (marshall_string_ gc_arg1) >>= \ (nm) ->
  (case x of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just x) -> (return ((x)))
   }) >>= \ (x) ->
  (case y of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just y) -> (return ((y)))
   }) >>= \ (y) ->
  (case w of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just w) -> (return ((w)))
   }) >>= \ (w) ->
  (case h of {
      Nothing -> (return (cW_USEDEFAULT));
      (Just h) -> (return ((h)))
   }) >>= \ (h) ->
  (case hmenu of {
      Nothing -> (return (nullHANDLE));
      (Just hmenu) -> (return ((hmenu)))
   }) >>= \ (hmenu) ->
  prim_createStaticWindow nm wstyle sstyle x y w h parent hmenu handle
  >>= \ gc_result ->
  access_prim_createStaticWindow_hwnd (gc_result :: Addr) >>= \ hwnd ->
  access_prim_createStaticWindow_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createStaticWindow_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (hwnd))
foreign import  ccall "prim_createStaticWindow" unsafe prim_createStaticWindow :: Addr -> Word32 -> Word32 -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> IO (Addr)
foreign import ccall "access_prim_createStaticWindow_hwnd" unsafe access_prim_createStaticWindow_hwnd :: Addr -> IO (Addr)
foreign import ccall "access_prim_createStaticWindow_gc_failed" unsafe access_prim_createStaticWindow_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createStaticWindow_gc_failstring" unsafe access_prim_createStaticWindow_gc_failstring :: Addr -> IO (Addr)

-- see comment about freeing windowNames in Win32Window.createWindow
-- %end free(nm)

{- UNTESTED - leave out

type CommonControl   = Addr
%dis commonControl x = addr ({LPCTSTR} x)

%const CommonControl
% [ ToolTipsControl = {TOOLTIPS_CLASS}
% , TrackBarControl = {TRACKBAR_CLASS}
% , UpDownControl  = {UPDOWN_CLASS}
% , ProgressBarControl = {PROGRESS_CLASS}
% , HotKeyControl  = {HOTKEY_CLASS}
% , AnimateControl     = {ANIMATE_CLASS}
% , StatusControl     =  {STATUSCLASSNAME}
% , HeaderControl     =  {WC_HEADER}
% , ListViewControl   =  {WC_LISTVIEW}
% , TabControl        =  {WC_TABCONTROL}
% , TreeViewControl   =  {WC_TREEVIEW}
% , MonthCalControl    = {MONTHCAL_CLASS}
% , DateTimePickControl = {DATETIMEPICK_CLASS}
% , ReBarControl      =  {REBARCLASSNAME}
-- Not supplied in mingw-20001111
--% , ComboBoxExControl =  {WC_COMBOBOXEX}
--% , IPAddressControl  =  {WC_IPADDRESS}
--% , PageScrollerControl = {WC_PAGESCROLLER}
% ]

%fun createCommonControl
%    :: CommonControl -> WindowStyle -> String -> WindowStyle
%    -> MbPos -> MbPos -> MbPos -> MbPos 
%    -> MbHWND -> MbHMENU -> HANDLE 
%    -> IO HWND
%call (commonControl c) (windowStyle estyle) (string nm) (windowStyle wstyle)
%     (mbPos x) (mbPos y) (mbPos w) (mbPos h) 
%     (mbHWND parent) (mbHMENU hmenu) (hANDLE handle)
%code hwnd = CreateWindowEx(estyle, c, nm,wstyle,x,y,w,h,parent,hmenu,handle,NULL);
%fail { hwnd == NULL } { ErrorWin("CreateCommonControl") }
%result (hWND hwnd)

%fun InitCommonControls :: IO ()

-}

pBM_DELTAPOS :: WindowMessage
pBM_DELTAPOS =
  unsafePerformIO(
    prim_pBM_DELTAPOS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pBM_DELTAPOS" unsafe prim_pBM_DELTAPOS :: IO (Word32)
pBM_SETPOS :: WindowMessage
pBM_SETPOS =
  unsafePerformIO(
    prim_pBM_SETPOS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pBM_SETPOS" unsafe prim_pBM_SETPOS :: IO (Word32)
pBM_SETRANGE :: WindowMessage
pBM_SETRANGE =
  unsafePerformIO(
    prim_pBM_SETRANGE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pBM_SETRANGE" unsafe prim_pBM_SETRANGE :: IO (Word32)
pBM_SETSTEP :: WindowMessage
pBM_SETSTEP =
  unsafePerformIO(
    prim_pBM_SETSTEP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pBM_SETSTEP" unsafe prim_pBM_SETSTEP :: IO (Word32)
pBM_STEPIT :: WindowMessage
pBM_STEPIT =
  unsafePerformIO(
    prim_pBM_STEPIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pBM_STEPIT" unsafe prim_pBM_STEPIT :: IO (Word32)

-- % , PBM_GETRANGE
-- % , PBM_GETPOS
-- % , PBM_SETBARCOLOR
-- % , PBM_SETBKCOLOR
-- % , PBM_SETRANGE32
