{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Pen_stub_ffi.h" #-}
module Win32Pen where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Stock Objects
----------------------------------------------------------------

type StockPen   = WORD

wHITE_PEN :: StockPen
wHITE_PEN =
  unsafePerformIO(
    prim_wHITE_PEN
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_wHITE_PEN" unsafe prim_wHITE_PEN :: IO (Word32)
bLACK_PEN :: StockPen
bLACK_PEN =
  unsafePerformIO(
    prim_bLACK_PEN
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_bLACK_PEN" unsafe prim_bLACK_PEN :: IO (Word32)
nULL_PEN :: StockPen
nULL_PEN =
  unsafePerformIO(
    prim_nULL_PEN
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_nULL_PEN" unsafe prim_nULL_PEN :: IO (Word32)

getStockPen :: StockPen -> IO HPEN
getStockPen gc_arg1 =
  case ( word16ToWord32  gc_arg1) of { arg1 ->
  prim_getStockPen arg1
  >>= \ gc_result ->
  access_prim_getStockPen_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getStockPen_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getStockPen_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}
foreign import  ccall "prim_getStockPen" unsafe prim_getStockPen :: Word32 -> IO (Addr)
foreign import ccall "access_prim_getStockPen_res1" unsafe access_prim_getStockPen_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getStockPen_gc_failed" unsafe access_prim_getStockPen_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getStockPen_gc_failstring" unsafe access_prim_getStockPen_gc_failstring :: Addr -> IO (Addr)

deletePen :: HPEN -> IO ()
deletePen arg1 =
  prim_deletePen arg1
  >>= \ gc_result ->
  access_prim_deletePen_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deletePen_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deletePen" unsafe prim_deletePen :: Addr -> IO (Addr)
foreign import ccall "access_prim_deletePen_gc_failed" unsafe access_prim_deletePen_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deletePen_gc_failstring" unsafe access_prim_deletePen_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- Creating pens
----------------------------------------------------------------

type PenStyle   = Int32

pS_SOLID :: PenStyle
pS_SOLID =
  unsafePerformIO(
    prim_pS_SOLID
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_SOLID" unsafe prim_pS_SOLID :: IO (Int)
pS_DASH :: PenStyle
pS_DASH =
  unsafePerformIO(
    prim_pS_DASH
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_DASH" unsafe prim_pS_DASH :: IO (Int)
pS_DOT :: PenStyle
pS_DOT =
  unsafePerformIO(
    prim_pS_DOT
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_DOT" unsafe prim_pS_DOT :: IO (Int)
pS_DASHDOT :: PenStyle
pS_DASHDOT =
  unsafePerformIO(
    prim_pS_DASHDOT
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_DASHDOT" unsafe prim_pS_DASHDOT :: IO (Int)
pS_DASHDOTDOT :: PenStyle
pS_DASHDOTDOT =
  unsafePerformIO(
    prim_pS_DASHDOTDOT
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_DASHDOTDOT" unsafe prim_pS_DASHDOTDOT :: IO (Int)
pS_NULL :: PenStyle
pS_NULL =
  unsafePerformIO(
    prim_pS_NULL
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_NULL" unsafe prim_pS_NULL :: IO (Int)
pS_INSIDEFRAME :: PenStyle
pS_INSIDEFRAME =
  unsafePerformIO(
    prim_pS_INSIDEFRAME
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_INSIDEFRAME" unsafe prim_pS_INSIDEFRAME :: IO (Int)
pS_USERSTYLE :: PenStyle
pS_USERSTYLE =
  unsafePerformIO(
    prim_pS_USERSTYLE
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_USERSTYLE" unsafe prim_pS_USERSTYLE :: IO (Int)
pS_ALTERNATE :: PenStyle
pS_ALTERNATE =
  unsafePerformIO(
    prim_pS_ALTERNATE
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_ALTERNATE" unsafe prim_pS_ALTERNATE :: IO (Int)
pS_STYLE_MASK :: PenStyle
pS_STYLE_MASK =
  unsafePerformIO(
    prim_pS_STYLE_MASK
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_STYLE_MASK" unsafe prim_pS_STYLE_MASK :: IO (Int)

pS_ENDCAP_ROUND :: PenStyle
pS_ENDCAP_ROUND =
  unsafePerformIO(
    prim_pS_ENDCAP_ROUND
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_ENDCAP_ROUND" unsafe prim_pS_ENDCAP_ROUND :: IO (Int)
pS_ENDCAP_SQUARE :: PenStyle
pS_ENDCAP_SQUARE =
  unsafePerformIO(
    prim_pS_ENDCAP_SQUARE
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_ENDCAP_SQUARE" unsafe prim_pS_ENDCAP_SQUARE :: IO (Int)
pS_ENDCAP_FLAT :: PenStyle
pS_ENDCAP_FLAT =
  unsafePerformIO(
    prim_pS_ENDCAP_FLAT
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_ENDCAP_FLAT" unsafe prim_pS_ENDCAP_FLAT :: IO (Int)
pS_ENDCAP_MASK :: PenStyle
pS_ENDCAP_MASK =
  unsafePerformIO(
    prim_pS_ENDCAP_MASK
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_ENDCAP_MASK" unsafe prim_pS_ENDCAP_MASK :: IO (Int)

{-
If PS_JOIN_MASK is not defined with your GNU Windows32 header files,
you'll have to define it.
-}
pS_JOIN_ROUND :: PenStyle
pS_JOIN_ROUND =
  unsafePerformIO(
    prim_pS_JOIN_ROUND
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_JOIN_ROUND" unsafe prim_pS_JOIN_ROUND :: IO (Int)
pS_JOIN_BEVEL :: PenStyle
pS_JOIN_BEVEL =
  unsafePerformIO(
    prim_pS_JOIN_BEVEL
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_JOIN_BEVEL" unsafe prim_pS_JOIN_BEVEL :: IO (Int)
pS_JOIN_MITER :: PenStyle
pS_JOIN_MITER =
  unsafePerformIO(
    prim_pS_JOIN_MITER
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_JOIN_MITER" unsafe prim_pS_JOIN_MITER :: IO (Int)

pS_COSMETIC :: PenStyle
pS_COSMETIC =
  unsafePerformIO(
    prim_pS_COSMETIC
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_COSMETIC" unsafe prim_pS_COSMETIC :: IO (Int)
pS_GEOMETRIC :: PenStyle
pS_GEOMETRIC =
  unsafePerformIO(
    prim_pS_GEOMETRIC
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_GEOMETRIC" unsafe prim_pS_GEOMETRIC :: IO (Int)
pS_TYPE_MASK :: PenStyle
pS_TYPE_MASK =
  unsafePerformIO(
    prim_pS_TYPE_MASK
    >>= \  res1  ->
    let gc_res1 = ( intToInt32  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_pS_TYPE_MASK" unsafe prim_pS_TYPE_MASK :: IO (Int)

createPen :: PenStyle -> INT -> COLORREF -> IO HPEN
createPen gc_arg1 gc_arg2 arg3 =
  case ( int32ToInt  gc_arg1) of { arg1 ->
  case ( int32ToInt  gc_arg2) of { arg2 ->
  prim_createPen arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_createPen_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createPen_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createPen_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}}
foreign import  ccall "prim_createPen" unsafe prim_createPen :: Int -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_createPen_res1" unsafe access_prim_createPen_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createPen_gc_failed" unsafe access_prim_createPen_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createPen_gc_failstring" unsafe access_prim_createPen_gc_failstring :: Addr -> IO (Addr)

-- Not very well supported on Win'95
-- %fun NullHANDLE ExtCreatePen :: PenStyle -> INT -> LOGBRUSH -> [StyleBit] -> IO HPEN

-- ToDo: CreatePenIndirect

----------------------------------------------------------------
-- End
----------------------------------------------------------------
