{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Region_stub_ffi.h" #-}
module Win32Region where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Regions
----------------------------------------------------------------

combineRgn :: HRGN -> HRGN -> HRGN -> ClippingMode -> IO RegionType
combineRgn arg1 arg2 arg3 arg4 =
  prim_combineRgn arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_combineRgn_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_combineRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_combineRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( word32ToWord16  (res1)) in
       (return (gc_res1))
foreign import  ccall "prim_combineRgn" unsafe prim_combineRgn :: ForeignObj -> ForeignObj -> ForeignObj -> Word32 -> IO (Addr)
foreign import ccall "access_prim_combineRgn_res1" unsafe access_prim_combineRgn_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_combineRgn_gc_failed" unsafe access_prim_combineRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_combineRgn_gc_failstring" unsafe access_prim_combineRgn_gc_failstring :: Addr -> IO (Addr)

offsetRgn :: HRGN -> INT -> INT -> IO RegionType
offsetRgn arg1 gc_arg1 gc_arg2 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  prim_offsetRgn arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_offsetRgn_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_offsetRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_offsetRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( word32ToWord16  (res1)) in
       (return (gc_res1))}}
foreign import  ccall "prim_offsetRgn" unsafe prim_offsetRgn :: ForeignObj -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_offsetRgn_res1" unsafe access_prim_offsetRgn_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_offsetRgn_gc_failed" unsafe access_prim_offsetRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_offsetRgn_gc_failstring" unsafe access_prim_offsetRgn_gc_failstring :: Addr -> IO (Addr)

getRgnBox :: HRGN -> LPRECT -> IO RegionType
getRgnBox arg1 arg2 =
  prim_getRgnBox arg1 arg2
  >>= \ gc_result ->
  access_prim_getRgnBox_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getRgnBox_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getRgnBox_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( word32ToWord16  (res1)) in
       (return (gc_res1))
foreign import  ccall "prim_getRgnBox" unsafe prim_getRgnBox :: ForeignObj -> Addr -> IO (Addr)
foreign import ccall "access_prim_getRgnBox_res1" unsafe access_prim_getRgnBox_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getRgnBox_gc_failed" unsafe access_prim_getRgnBox_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getRgnBox_gc_failstring" unsafe access_prim_getRgnBox_gc_failstring :: Addr -> IO (Addr)

createEllipticRgn :: INT -> INT -> INT -> INT -> IO HRGN
createEllipticRgn gc_arg1 gc_arg2 gc_arg3 gc_arg4 =
  case ( int32ToInt  gc_arg1) of { arg1 ->
  case ( int32ToInt  gc_arg2) of { arg2 ->
  case ( int32ToInt  gc_arg3) of { arg3 ->
  case ( int32ToInt  gc_arg4) of { arg4 ->
  prim_createEllipticRgn arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_createEllipticRgn_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_createEllipticRgn_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_createEllipticRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createEllipticRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
       (return (gc_res2))}}}}
foreign import  ccall "prim_createEllipticRgn" unsafe prim_createEllipticRgn :: Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_createEllipticRgn_gc_res3" unsafe access_prim_createEllipticRgn_gc_res3 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createEllipticRgn_gc_res1" unsafe access_prim_createEllipticRgn_gc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createEllipticRgn_gc_failed" unsafe access_prim_createEllipticRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createEllipticRgn_gc_failstring" unsafe access_prim_createEllipticRgn_gc_failstring :: Addr -> IO (Addr)

createEllipticRgnIndirect :: LPRECT -> IO HRGN
createEllipticRgnIndirect arg1 =
  prim_createEllipticRgnIndirect arg1
  >>= \ gc_result ->
  access_prim_createEllipticRgnIndirect_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_createEllipticRgnIndirect_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_createEllipticRgnIndirect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createEllipticRgnIndirect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
       (return (gc_res2))
foreign import  ccall "prim_createEllipticRgnIndirect" unsafe prim_createEllipticRgnIndirect :: Addr -> IO (Addr)
foreign import ccall "access_prim_createEllipticRgnIndirect_gc_res3" unsafe access_prim_createEllipticRgnIndirect_gc_res3 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createEllipticRgnIndirect_gc_res1" unsafe access_prim_createEllipticRgnIndirect_gc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createEllipticRgnIndirect_gc_failed" unsafe access_prim_createEllipticRgnIndirect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createEllipticRgnIndirect_gc_failstring" unsafe access_prim_createEllipticRgnIndirect_gc_failstring :: Addr -> IO (Addr)

createRectRgn :: INT -> INT -> INT -> INT -> IO HRGN
createRectRgn gc_arg1 gc_arg2 gc_arg3 gc_arg4 =
  case ( int32ToInt  gc_arg1) of { arg1 ->
  case ( int32ToInt  gc_arg2) of { arg2 ->
  case ( int32ToInt  gc_arg3) of { arg3 ->
  case ( int32ToInt  gc_arg4) of { arg4 ->
  prim_createRectRgn arg1 arg2 arg3 arg4
  >>= \ gc_result ->
  access_prim_createRectRgn_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_createRectRgn_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_createRectRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createRectRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
       (return (gc_res2))}}}}
foreign import  ccall "prim_createRectRgn" unsafe prim_createRectRgn :: Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_createRectRgn_gc_res3" unsafe access_prim_createRectRgn_gc_res3 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRectRgn_gc_res1" unsafe access_prim_createRectRgn_gc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRectRgn_gc_failed" unsafe access_prim_createRectRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createRectRgn_gc_failstring" unsafe access_prim_createRectRgn_gc_failstring :: Addr -> IO (Addr)

createRectRgnIndirect :: LPRECT -> IO HRGN
createRectRgnIndirect arg1 =
  prim_createRectRgnIndirect arg1
  >>= \ gc_result ->
  access_prim_createRectRgnIndirect_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_createRectRgnIndirect_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_createRectRgnIndirect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createRectRgnIndirect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
       (return (gc_res2))
foreign import  ccall "prim_createRectRgnIndirect" unsafe prim_createRectRgnIndirect :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRectRgnIndirect_gc_res3" unsafe access_prim_createRectRgnIndirect_gc_res3 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRectRgnIndirect_gc_res1" unsafe access_prim_createRectRgnIndirect_gc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRectRgnIndirect_gc_failed" unsafe access_prim_createRectRgnIndirect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createRectRgnIndirect_gc_failstring" unsafe access_prim_createRectRgnIndirect_gc_failstring :: Addr -> IO (Addr)

createRoundRectRgn :: INT -> INT -> INT -> INT -> INT -> INT -> IO HRGN
createRoundRectRgn gc_arg1 gc_arg2 gc_arg3 gc_arg4 gc_arg5 gc_arg6 =
  case ( int32ToInt  gc_arg1) of { arg1 ->
  case ( int32ToInt  gc_arg2) of { arg2 ->
  case ( int32ToInt  gc_arg3) of { arg3 ->
  case ( int32ToInt  gc_arg4) of { arg4 ->
  case ( int32ToInt  gc_arg5) of { arg5 ->
  case ( int32ToInt  gc_arg6) of { arg6 ->
  prim_createRoundRectRgn arg1 arg2 arg3 arg4 arg5 arg6
  >>= \ gc_result ->
  access_prim_createRoundRectRgn_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_createRoundRectRgn_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_createRoundRectRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createRoundRectRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
       (return (gc_res2))}}}}}}
foreign import  ccall "prim_createRoundRectRgn" unsafe prim_createRoundRectRgn :: Int -> Int -> Int -> Int -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_createRoundRectRgn_gc_res3" unsafe access_prim_createRoundRectRgn_gc_res3 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRoundRectRgn_gc_res1" unsafe access_prim_createRoundRectRgn_gc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createRoundRectRgn_gc_failed" unsafe access_prim_createRoundRectRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createRoundRectRgn_gc_failstring" unsafe access_prim_createRoundRectRgn_gc_failstring :: Addr -> IO (Addr)

createPolygonRgn :: [POINT] -> PolyFillMode -> IO HRGN
createPolygonRgn gc_arg1 gc_arg3 =
  (marshall_listLenPOINT_ gc_arg1) >>= \ (gc_arg2) ->
  case gc_arg2 of { (ps,num_ps) ->
  case ( word16ToWord32  gc_arg3) of { mode ->
  prim_createPolygonRgn ps num_ps mode
  >>= \ gc_result ->
  access_prim_createPolygonRgn_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_createPolygonRgn_gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_createPolygonRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createPolygonRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (makeForeignObjPrim gc_res1 gc_res3) >>= \ gc_res2 ->
       (return (gc_res2))}}
foreign import  ccall "prim_createPolygonRgn" unsafe prim_createPolygonRgn :: Addr -> Int -> Word32 -> IO (Addr)
foreign import ccall "access_prim_createPolygonRgn_gc_res3" unsafe access_prim_createPolygonRgn_gc_res3 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createPolygonRgn_gc_res1" unsafe access_prim_createPolygonRgn_gc_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createPolygonRgn_gc_failed" unsafe access_prim_createPolygonRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createPolygonRgn_gc_failstring" unsafe access_prim_createPolygonRgn_gc_failstring :: Addr -> IO (Addr)

-- Needs to do proper error test for EqualRgn; GSL ???
equalRgn :: HRGN -> HRGN -> IO Bool
equalRgn arg1 arg2 =
  prim_equalRgn arg1 arg2
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_equalRgn" unsafe prim_equalRgn :: ForeignObj -> ForeignObj -> IO (Int)

fillRgn :: HDC -> HRGN -> HBRUSH -> IO ()
fillRgn arg1 arg2 arg3 =
  prim_fillRgn arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_fillRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_fillRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_fillRgn" unsafe prim_fillRgn :: Addr -> ForeignObj -> Addr -> IO (Addr)
foreign import ccall "access_prim_fillRgn_gc_failed" unsafe access_prim_fillRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_fillRgn_gc_failstring" unsafe access_prim_fillRgn_gc_failstring :: Addr -> IO (Addr)

invertRgn :: HDC -> HRGN -> IO ()
invertRgn arg1 arg2 =
  prim_invertRgn arg1 arg2
  >>= \ gc_result ->
  access_prim_invertRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_invertRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_invertRgn" unsafe prim_invertRgn :: Addr -> ForeignObj -> IO (Addr)
foreign import ccall "access_prim_invertRgn_gc_failed" unsafe access_prim_invertRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_invertRgn_gc_failstring" unsafe access_prim_invertRgn_gc_failstring :: Addr -> IO (Addr)

paintRgn :: HDC -> HRGN -> IO ()
paintRgn arg1 arg2 =
  prim_paintRgn arg1 arg2
  >>= \ gc_result ->
  access_prim_paintRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_paintRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_paintRgn" unsafe prim_paintRgn :: Addr -> ForeignObj -> IO (Addr)
foreign import ccall "access_prim_paintRgn_gc_failed" unsafe access_prim_paintRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_paintRgn_gc_failstring" unsafe access_prim_paintRgn_gc_failstring :: Addr -> IO (Addr)

frameRgn :: HDC -> HRGN -> HBRUSH -> Int -> Int -> IO ()
frameRgn arg1 arg2 arg3 arg4 arg5 =
  prim_frameRgn arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_frameRgn_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_frameRgn_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_frameRgn" unsafe prim_frameRgn :: Addr -> ForeignObj -> Addr -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_frameRgn_gc_failed" unsafe access_prim_frameRgn_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_frameRgn_gc_failstring" unsafe access_prim_frameRgn_gc_failstring :: Addr -> IO (Addr)

ptInRegion :: HRGN -> Int -> Int -> IO Bool
ptInRegion arg1 arg2 arg3 =
  prim_ptInRegion arg1 arg2 arg3
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))
foreign import  ccall "prim_ptInRegion" unsafe prim_ptInRegion :: ForeignObj -> Int -> Int -> IO (Int)

rectInRegion :: HRGN -> RECT -> IO Bool
rectInRegion arg1 gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  prim_rectInRegion arg1 gc_arg3 gc_arg5 gc_arg7 gc_arg9
  >>= \  res1  ->
  (unmarshall_bool_ res1) >>= \ gc_res1 ->
  (return (gc_res1))}}}}}
foreign import  ccall "prim_rectInRegion" unsafe prim_rectInRegion :: ForeignObj -> Int -> Int -> Int -> Int -> IO (Int)

deleteRegion :: HRGN -> IO ()
deleteRegion arg1 =
  prim_deleteRegion arg1
  >>= \ gc_result ->
  access_prim_deleteRegion_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deleteRegion_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deleteRegion" unsafe prim_deleteRegion :: ForeignObj -> IO (Addr)
foreign import ccall "access_prim_deleteRegion_gc_failed" unsafe access_prim_deleteRegion_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deleteRegion_gc_failstring" unsafe access_prim_deleteRegion_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- End
----------------------------------------------------------------
