// MM2DOCV.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm2docv.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "mm2rbn.h"

#include "color.h"
#include "views.h"

#include "mm1mdl.h"

#include <fstream>
#include <strstream>
using namespace std;

/*################################################################################################*/

mm2_cm_state mm2_docv::cm_state = mm2_cm_state();
mm2_cm_residue mm2_docv::cm_residue = mm2_cm_residue();
mm2_cm_sasa mm2_docv::cm_sasa = mm2_cm_sasa();

mm2_docv::mm2_docv(ostream * p1, graphics_class_factory & p2, mm2_eng_param * p3) :
	docview(p1, p2), mm2_mdl(p1, p2, p3), model_simple(p1, p2)
{
}

mm2_docv::~mm2_docv(void)
{
}

fGL mm2_docv::GetDefaultFocus(void)
{
	return 5.0;
}

const char * mm2_docv::GetType(void)
{
	return "MM, reduced protein model";
}

color_mode * mm2_docv::GetDefaultColorMode(void)
{
	return & mm2_docv::cm_state;
}

void mm2_docv::SelectAll(void)
{
	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
	{
		for (i32u n2 = 0;n2 < chn_vector[n1].res_vector.size();n2++)
		{
			chn_vector[n1].res_vector[n2].sel = true;
		}
	}
	
	UpdateAllGraphicsViews();
}

void mm2_docv::InvertSelection(void)
{
	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
	{
		for (i32u n2 = 0;n2 < chn_vector[n1].res_vector.size();n2++)
		{
			bool old = chn_vector[n1].res_vector[n2].sel;
			chn_vector[n1].res_vector[n2].sel = !old;
		}
	}
	
	UpdateAllGraphicsViews();
}

//void mm2_docv::SelectNone(void)
//{
//	for (i32u n1 = 0;n1 < chn_vector.size();n1++)
//	{
//		for (i32u n2 = 0;n2 < chn_vector[n1].res_vector.size();n2++)
//		{
//			chn_vector[n1].res_vector[n2].sel = false;
//		}
//	}
//	
//	UpdateAllGraphicsViews();
//}

void mm2_docv::DrawCylinder1(graphics_view * gv, mm2_res ** res, i32s * atm, i32s aaa)
{
	fGL rsum = res[0]->vdwr[atm[0]] + res[1]->vdwr[atm[1]];
	
	for (i32s n1 = 0;n1 < 2;n1++)
	{
		fGL * crd1 = res[n1]->crd_vector[atm[n1]][aaa].data;
		fGL * crd2 = res[!n1]->crd_vector[atm[!n1]][aaa].data;
		v3d<fGL> crt = v3d<fGL>(crd1, crd2);
		
		fGL pol[3]; crt2pol(crt.data, pol);
		
		mm2_cdata cdata; cdata.res = res[n1]; cdata.index = atm[n1];
		fGL_a4 color; gv->colormode->GetColor(& cdata, color, model_prefs);
		glColor3fv(color);
		
		const float radius = model_prefs->Double("MM2Graphics/CylinderSize", 0.1);
		const int resolution = model_prefs->Value("MM2Graphics/CylinderResolution", 10);
		
		GLUquadricObj * qo = gluNewQuadric();
		gluQuadricDrawStyle(qo, (GLenum) GLU_FILL); glPushMatrix();
		
		glTranslated(crd1[0], crd1[1], crd1[2]);
		
		glRotated(180.0 * pol[1] / M_PI, 0.0, 1.0, 0.0);
		glRotated(180.0 * pol[2] / M_PI, sin(-pol[1]), 0.0, cos(-pol[1]));
		
		fGL length = crt.len() * res[n1]->vdwr[atm[n1]] / rsum;
		gluCylinder(qo, radius, radius, length, resolution, resolution / 2);
		
		glPopMatrix(); gluDeleteQuadric(qo);
	}
}

void mm2_docv::Render(graphics_view * gv, rmode rm)
{
	if (gv->enable_fog) glEnable(GL_FOG);
	
bool accum = gv->accumulate; if (rm != Normal) accum = false;
//if (accum) { glClear(GL_ACCUM_BUFFER_BIT); UpdateAccumValues(); }
//else if (rm != Transform2) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
////////////////////////////////////////////////// debug!!!
////////////////////////////////////////////////// debug!!!
//	glBegin(GL_POINTS);
//	for (i32u n1 = 0;n1 < debug_vector.size();n1++)
//	{
//		glColor3dv(debug_vector[n1].color);
//		glVertex3dv(debug_vector[n1].crd);
//	} glEnd();
////////////////////////////////////////////////// debug!!!
////////////////////////////////////////////////// debug!!!

	for (i32u n1 = 0;n1 < cs_vector.size();n1++)
	{
		if (!cs_vector[n1].visible) continue;
		
		if (accum)
		{
glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// FIXME!!!
			gv->cam->RenderObjects(gv);
		}
		
		// disulphide bridges!!!
		// disulphide bridges!!!
		// disulphide bridges!!!
		
		glColor3f(1.0, 1.0, 1.0); glLineWidth(1.0);
		for (i32u n2 = 0;n2 < dsb_vector.size();n2++)
		{
			glBegin(GL_LINES);
			glVertex3fv(chn_vector[dsb_vector[n2].chn[0]].res_vector[dsb_vector[n2].res[0]].crd_vector[1][n1].data);
			glVertex3fv(chn_vector[dsb_vector[n2].chn[1]].res_vector[dsb_vector[n2].res[1]].crd_vector[1][n1].data);
			glEnd();
		}
		
		if (gv->render == RENDER_WIREFRAME)
		{
			glPointSize(3.0); glLineWidth(1.0);
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 0;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 1;n3++)
				{
					glBegin(GL_LINES);
					
					mm2_cdata cdata; fGL_a4 color;
					cdata.res = & chn_vector[n2].res_vector[n3 + 0]; cdata.index = 0;
					gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
					
					glVertex3fv(chn_vector[n2].res_vector[n3 + 0].crd_vector[0][n1].data);
					cdata.res = & chn_vector[n2].res_vector[n3 + 1]; cdata.index = 0;
					gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
					
					glVertex3fv(chn_vector[n2].res_vector[n3 + 1].crd_vector[0][n1].data);
					
					glEnd();
				}
				
				for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
				{
					for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
					{
						glBegin(GL_POINTS);
						
						mm2_cdata cdata; fGL_a4 color;
						cdata.res = & chn_vector[n2].res_vector[n3]; cdata.index = n4;
						gv->colormode->GetColor(& cdata,  color, model_prefs); glColor3fv(color);
						
						glVertex3fv(chn_vector[n2].res_vector[n3].crd_vector[n4][n1].data);
						
						glEnd();
					}
					
////////////////////////////////////////////////// allowed side-chain cones!!!
////////////////////////////////////////////////// allowed side-chain cones!!!
/*

bool test = false;
if (chn_vector[n2].res_vector[n3].natm > 1) test = true;

if (test && n3 && n3 != chn_vector[n2].res_vector.size() - 1)
{
	fGL length = 0.25;
	fGL angle = M_PI * 52.0 / 180.0;
	
	fGL * curr = chn_vector[n2].res_vector[n3].crd[0][n1];
	
	fGL * prev = chn_vector[n2].res_vector[n3 - 1].crd[0][n1];
	fGL * next = chn_vector[n2].res_vector[n3 + 1].crd[0][n1];
	
	v3d<fGL> v1 = v3d<fGL>(curr, prev); v1 = v1 / v1.len();
	v3d<fGL> v2 = v3d<fGL>(curr, next); v2 = v2 / v2.len();
	
	v3d<fGL> v3 = v1.vpr(v2); v3 = v3 * (cos(angle) / v3.len());
	v3d<fGL> v4 = v1 + v2; v4 = v4 * (sin(angle) / v4.len());
	v3d<fGL> v5 = v3 - v4;
	
	v5 = v5 * (length / v5.len());
	v3d<fGL> v6 = v3d<fGL>(curr); v6 = v6 + v5;
	
////////////////////////////////////////
//	glBegin(GL_LINES);
//	glColor3f(1.0, 1.0, 1.0); glVertex3fv(v6.comp);
//	glVertex3fv(chn_vector[n2].res_vector[n3].crd[0][n1]);
//	glEnd();
////////////////////////////////////////

	v3d<fGL> crt = v3d<fGL>(curr, v6.comp);
	fGL pol[3]; crt2pol(crt.comp, pol);
	glColor3f(0.0, 1.0, 1.0);
	
	GLUquadricObj * qo;
	fGL t1 = chn_vector[n2].res_vector[n3].crd[0][n1][0];
	fGL t2 = chn_vector[n2].res_vector[n3].crd[0][n1][1];
	fGL t3 = chn_vector[n2].res_vector[n3].crd[0][n1][2];
	glEnable(GL_LIGHTING);
	
	qo = gluNewQuadric();
	glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, true);
	gluQuadricDrawStyle(qo, (GLenum) GLU_FILL);
	
	glPushMatrix(); glTranslatef(t1, t2, t3);
	
	glRotated(180.0 * pol[1] / M_PI, 0.0, 1.0, 0.0);
	glRotated(180.0 * pol[2] / M_PI, sin(-pol[1]), 0.0, cos(-pol[1]));
	
	gluCylinder(qo, 0.0, length * tan(angle), length, 12, 1);
	glPopMatrix(); gluDeleteQuadric(qo);
	
	glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, false);
	glDisable(GL_LIGHTING);
}

*/
////////////////////////////////////////////////// allowed side-chain cones!!!
////////////////////////////////////////////////// allowed side-chain cones!!!

					for (i32s n4 = 0;n4 < ((i32s) chn_vector[n2].res_vector[n3].natm) - 1;n4++)
					{
						glBegin(GL_LINES);
						
						mm2_cdata cdata; fGL_a4 color;
						cdata.res = & chn_vector[n2].res_vector[n3]; cdata.index = n4 + 0;
						gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
						
						glVertex3fv(chn_vector[n2].res_vector[n3].crd_vector[n4 + 0][n1].data);
						cdata.res = & chn_vector[n2].res_vector[n3]; cdata.index = n4 + 1;
						gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
						
						glVertex3fv(chn_vector[n2].res_vector[n3].crd_vector[n4 + 1][n1].data);
						
						glEnd();
					}
				}
			}
			
			// the peptide units!!!
			// the peptide units!!!
			// the peptide units!!!
			
			glEnable(GL_LIGHTING);
			glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, true);
			
			glBegin(GL_QUADS);      
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 1;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 2;n3++)
				{
					char symbol2 = chn_vector[n2].res_vector[n3 + 1].symbol;
					if (symbol2 == 'P') continue;	// skip all X-pro cases !!!
					
					fGL * curr = chn_vector[n2].res_vector[n3].crd_vector[0][n1].data;
					fGL * prev = chn_vector[n2].res_vector[n3 - 1].crd_vector[0][n1].data;
					fGL * next = chn_vector[n2].res_vector[n3 + 1].crd_vector[0][n1].data;
					
					v3d<fGL> v1(prev, curr); v3d<fGL> v2(curr, next);
					
					v3d<fGL> v3 = v1.vpr(v2); v3 = v3 * (0.075 / v3.len());
					v3d<fGL> v4 = v3.vpr(v2); v4 = v4 * (0.075 / v4.len());
					
					fGL peptide = chn_vector[n2].res_vector[n3].peptide_vector[n1];
					v3d<fGL> v5 = (v3 * sin(peptide)) + (v4 * cos(peptide));
					
					fGL peptnorm = peptide - M_PI / 2.0;
					v3d<fGL> normal = (v3 * sin(peptnorm)) + (v4 * cos(peptnorm));
					normal = normal / normal.len(); glNormal3fv(normal.data);
					
					v3d<fGL> pvc(curr);
					v3d<fGL> pv1 = pvc + (v2 * 0.5) + v5; v3d<fGL> pv2 = pvc + (v2 * 0.90);
					v3d<fGL> pv3 = pvc + (v2 * 0.5) - v5; v3d<fGL> pv4 = pvc + (v2 * 0.10);
					
					glColor3f(1.0, 0.0, 0.0); glVertex3fv(pv1.data);
					glColor3f(0.0, 1.0, 0.0); glVertex3fv(pv2.data);
					glColor3f(0.0, 0.0, 1.0); glVertex3fv(pv3.data);
					glColor3f(0.0, 1.0, 0.0); glVertex3fv(pv4.data);
				}
			}
			
			glEnd();	// GL_QUADS
			
			glDisable(GL_LIGHTING);
			glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, false);
		}
		
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

		if (gv->render != RENDER_WIREFRAME && gv->render != RENDER_NOTHING)
		{
//			glEnable(GL_FOG);
			glEnable(GL_LIGHTING);
			
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
				{
					glPushName(GLNAME_MD_TYPE1);
					glPushName((i32u) ((n2 << 16) + n3));
					
					for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
					{
						mm2_cdata cdata; cdata.res = & chn_vector[n2].res_vector[n3]; cdata.index = n4;
						fGL_a4 color; gv->colormode->GetColor(& cdata, color, model_prefs); glColor3fv(color);
						
						if (chn_vector[n2].res_vector[n3].sel) glColor3f(1.0, 0.0, 1.0);
						
						float rad = 0.0; int res = 0;
						switch (gv->render)
						{
							case RENDER_BALL_AND_STICK:
					rad = model_prefs->Double("MM2Graphics/BallSize", 0.5) * chn_vector[n2].res_vector[n3].vdwr[n4];
					res = model_prefs->Value("MM2Graphics/BallResolution", 12);
							break;
							
							case RENDER_VAN_DER_WAALS:
							case RENDER_ACCESSIBLE:
					rad = chn_vector[n2].res_vector[n3].vdwr[n4];
					res = model_prefs->Value("MM2Graphics/BallResolution", 12);
					if (gv->render == RENDER_ACCESSIBLE) rad += 0.15;
							break;
							
							case RENDER_CYLINDERS:
					rad = model_prefs->Double("MM2Graphics/CylinderSize", 0.1);
					res = model_prefs->Value("MM2Graphics/CylinderResolution", 12);
							break;
						}
						
						GLUquadricObj * qo = gluNewQuadric();
						gluQuadricDrawStyle(qo, (GLenum) GLU_FILL); glPushMatrix();
						fGL t1 = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][0];
						fGL t2 = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][1];
						fGL t3 = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][2];
						glTranslatef(t1, t2, t3); gluSphere(qo, rad, res, res / 2);
						glPopMatrix(); gluDeleteQuadric(qo);
					}
					
					glPopName();
					glPopName();
				}
			}
			
//			glDisable(GL_FOG);
			glDisable(GL_LIGHTING);
		}
		
		if (gv->render == RENDER_BALL_AND_STICK || gv->render == RENDER_CYLINDERS)
		{
//			glEnable(GL_FOG);
			glEnable(GL_LIGHTING);
			
			for (i32u n2 = 0;n2 < chn_vector.size();n2++)
			{
				for (i32s n3 = 0;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 1;n3++)
				{
					mm2_res * res[2];
					res[0] = & chn_vector[n2].res_vector[n3];
					res[1] = & chn_vector[n2].res_vector[n3 + 1];
					i32s atm[2] = { 0, 0 }; DrawCylinder1(gv, res, atm, n1);
				}
				
				for (i32u n3 = 0;n3 < chn_vector[n2].res_vector.size();n3++)
				{
					for (i32s n4 = 0;n4 < ((i32s) chn_vector[n2].res_vector[n3].natm) - 1;n4++)
					{
						mm2_res * res[2];
						res[0] = & chn_vector[n2].res_vector[n3];
						res[1] = & chn_vector[n2].res_vector[n3];
						i32s atm[2] = { n4, n4 + 1 };
						
						DrawCylinder1(gv, res, atm, n1);
					}
				}
			}
			
//			glDisable(GL_FOG);
			glDisable(GL_LIGHTING);
		}
		
////////////////////////////////////////////////// labels!!!
////////////////////////////////////////////////// labels!!!

		if (gv->label != LABEL_NOTHING)		// not used anywhere?!?!?
		{
glColor3f(0.0, 1.0, 1.0); char string[256];
for (i32u n2 = 0;n2 < chn_vector.size();n2++)
{
	for (i32s n3 = 0;n3 < ((i32s) chn_vector[n2].res_vector.size()) - 1;n3++)
	{
		for (i32u n4 = 0;n4 < chn_vector[n2].res_vector[n3].natm;n4++)
		{
			ostrstream str(string, sizeof(string));
			str << chn_vector[n2].res_vector[n3].label[n4] << ends;
			
			fGL x = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][0];
			fGL y = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][1];
			fGL z = chn_vector[n2].res_vector[n3].crd_vector[n4][n1][2];
			
			gv->WriteGlutString3D(string, x, y, z, gv->cam->GetLocData(), GLUT_BITMAP_9_BY_15);
		}
	}
}
		}
		
////////////////////////////////////////////////// labels!!!
////////////////////////////////////////////////// labels!!!

		if (accum)
		{
			gv->cam->RenderObjects(gv);
			glAccum(GL_ACCUM, cs_vector[n1].accum_value);
		}
	}
	
	if (accum) glAccum(GL_RETURN, 1.0);
	else if (rm != Transform2) gv->cam->RenderObjects(gv);
	
	if (gv->enable_fog) glDisable(GL_FOG);
	
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	
	RenderAllTPs(gv, rm);
}

void mm2_docv::Center(transformer *)
{
}

void mm2_docv::Transform(transformer *)
{
}

void mm2_docv::DrawEvent(graphics_view *, vector<iGLu> &)
{
}

void mm2_docv::EraseEvent(graphics_view *, vector<iGLu> &)
{
}

void mm2_docv::SelectEvent(graphics_view *, vector<iGLu> & names)
{
	if (names[0] == GLNAME_MD_TYPE1)
	{
		i32s chn = (names[1] >> 16);
		i32s res = (names[1] & 0xFFFF);
		
		chn_vector[chn].res_vector[res].sel = !chn_vector[chn].res_vector[res].sel;
		UpdateAllGraphicsViews();
		
		cout << "chn = " << chn << " res = " << res << " ";
		cout << "symbol = " << chn_vector[chn].res_vector[res].symbol << endl;
	}
}

void mm2_docv::MeasureEvent(graphics_view *, vector<iGLu> &)
{
}

/*################################################################################################*/

void mm2_cm_state::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	mm2_cdata * ref = (mm2_cdata *) p1;
	switch (ref->res->state)
	{
		case STATE_HELIX:
		p2[0] = 1.0; p2[1] = 0.0; p2[2] = 0.0;
		return;
		
		case STATE_STRAND:
		p2[0] = 0.0; p2[1] = 1.0; p2[2] = 0.0;
		return;
		
		default:	// STATE_LOOP
		p2[0] = 0.0; p2[1] = 0.0; p2[2] = 1.0;
		return;
	}
}

/*################################################################################################*/

void mm2_cm_residue::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	p2[0] = p2[1] = p2[2] = 1.0;
	
/*	mm2_cdata * ref = (mm2_cdata *) p1;		// CURRENTLY BROKEN...
	mm2_mdl * mdl = ref->res->mdl;
	
	i32s chn = 0;
	while (true)
	{
		i32s res = 0;
		i32s max = mdl->chn_vector[chn].res_vector.size();
		while (res < max)
		{
			if (ref->res != & mdl->chn_vector[chn].res_vector[res]) res++;
			else
			{
				fGL value = (fGL) res / (fGL) (max - 1);
				GetRGRange1(value, p2); return;
			}
		}
		
		chn++;
		if (chn == (i32s) mdl->chn_vector.size()) return;
	}	*/
}

/*################################################################################################*/

void mm2_cm_sasa::GetColor(const void * p1, fGL_a4 & p2, prefs *p3)
{
	mm2_cdata * ref = (mm2_cdata *) p1;
	fGL value = ref->res->sasa[ref->index] / 20.0;
	GetRBRange1(value, 1.0, p2);
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
