// QM2DOCV.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "qm2docv.h"	// config.h is here -> we get ENABLE-macros here...

#ifdef ENABLE_GRAPHICS
#include "plane.h"
#include "surface.h"

#include "color.h"
#include "views.h"

/*################################################################################################*/

qm2_docv::qm2_docv(ostream * p1, graphics_class_factory & p2) :
	docview(p1, p2), qm2_mdl(p1, p2), model_simple(p1, p2)
{
}

qm2_docv::~qm2_docv(void)
{
}

fGL qm2_docv::GetDefaultFocus(void)
{
	return 1.0;
}

const char * qm2_docv::GetType(void)
{
	return "QM, atomic calculations";
}

color_mode * qm2_docv::GetDefaultColorMode(void)
{
	return NULL;
}

void qm2_docv::SelectAll(void)
{
}

void qm2_docv::InvertSelection(void)
{
}

void qm2_docv::Render(graphics_view * gv, rmode rm)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	if (gv->enable_fog) glEnable(GL_FOG);
	
	glPointSize(3.0); glLineWidth(1.0);
	
	glBegin(GL_POINTS);
	glColor3fv(el.GetColor());
	glVertex3f(0.0, 0.0, 0.0);
	glEnd();
	
	if (rm != Transform2) gv->cam->RenderObjects(gv);
	if (gv->enable_fog) glDisable(GL_FOG);
	
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	// finally call this to handle transparency...
	
	RenderAllTPs(gv, rm);
}

void qm2_docv::Center(transformer *)
{
}

void qm2_docv::Transform(transformer *)
{
}

void qm2_docv::DrawEvent(graphics_view *, vector<iGLu> &)
{
}

void qm2_docv::EraseEvent(graphics_view *, vector<iGLu> &)
{
}

void qm2_docv::SelectEvent(graphics_view *, vector<iGLu> &)
{
}

void qm2_docv::MeasureEvent(graphics_view *, vector<iGLu> &)
{
}

/*################################################################################################*/

#endif	// ENABLE_GRAPHICS

// eof
