/* $Header: /cvs/gnome/gIDE/src/gI_window.c,v 1.7 1999/12/05 07:17:51 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include "structs.h"
#include "gI_document.h"
#include "gI_menus.h"
#include "gI_file.h"
#include "gI_edit.h"
#include "gI_help.h"
#include "gI_prefs.h"
#include "gI_search.h"
#include "gI_tools.h"
#include "gI_common.h"
#include "gI_window.h"
#include "gI_hilite.h"
#include "gI_project.h"
#include "gI_toolbar.h"

/* externs */
extern gI_config *cfg;
extern glong ro_not_change;


glong window_destroy( GtkWidget *widget, GdkEvent *event, gI_window *window )
{
	gint nod,i,changed=0;
	gI_document *current;
	gI_project *project;

	/* close opened project */
	if( (project = gI_project_get_current()) )
	{
		project_close( NULL, NULL );
	}

	nod = gI_document_get_no( window );

	for(i=1;i<=nod;i++)
	{
		gtk_notebook_set_page( GTK_NOTEBOOK( window->notebook ), i );
		current = gI_document_get_current( window );
		if( current->changed == TRUE )
		{
			changed = TRUE;
			break;
		}
	}

	if( changed )
	{
		/*g_free(window->popup);
		window->popup = NULL;*/
		file_exit_is_changed( window );
		return( TRUE );
	}
	else
	{
		/*if(window->popup)
			g_free(window->popup);
		if(window->search_history)
			g_list_free(window->search_history);
		if(window->search_history)
			g_list_free(window->search_history);*/

		gtk_main_quit();
		return( TRUE );
	}
}



/*
 ---------------------------------------------------------------------
     Function: create_prjftree()
     Desc: Creates Project-File-Tree
 ---------------------------------------------------------------------
*/

void create_prjftree( gI_window *window )

{
	if( cfg->prjftree )
	{
		if( window->tree_frame != NULL )
			return;

		window->tree_frame = gtk_frame_new( _("Project Files") );
		gtk_box_pack_start( GTK_BOX( window->tree_box ), window->tree_frame, FALSE, TRUE, 5 );
		window->tree_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(window->tree_scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_container_add(GTK_CONTAINER(window->tree_frame), window->tree_scrolled_window);
		window->tree_viewport = gtk_viewport_new(NULL,NULL);
		gtk_container_add(GTK_CONTAINER(window->tree_scrolled_window), window->tree_viewport);
		gtk_widget_show(window->tree_viewport);
		gtk_widget_show(window->tree_scrolled_window);
		gtk_widget_show( window->tree_frame );
	}
	else
	{
		if( window->tree_frame != NULL )
		{
			gtk_widget_destroy( window->tree_frame );
			window->tree_frame = NULL;
		}
	}
}

static void switchto_next_doc( GtkWidget *widget, GdkEventKey *kevent, gI_window *window )
{
	gint curpag;
	GtkNotebookPage *page;
	static guint KeyValSave = 0;

	g_assert( window != NULL );
	g_assert( window->notebook != NULL );

	if( kevent->type == GDK_KEY_PRESS
	        && kevent->keyval == GDK_Shift_L )
	{
		KeyValSave = kevent->keyval;

		return;
	}

	if( kevent->type != GDK_KEY_PRESS
	        || kevent->keyval != GDK_ISO_Left_Tab
	        || KeyValSave != GDK_Shift_L )
	{
		return;
	}

	curpag = gtk_notebook_get_current_page( GTK_NOTEBOOK( window->notebook ) );
	if( curpag == gI_document_get_no( window )-1 )
		gtk_notebook_set_page( GTK_NOTEBOOK( window->notebook ), 0 );
	else
		gtk_notebook_next_page( GTK_NOTEBOOK( window->notebook ) );

	page = (GtkNotebookPage *) GTK_NOTEBOOK( window->notebook )->cur_page;

	g_assert( page != NULL );

	gtk_widget_grab_focus( page->tab_label );
	gtk_widget_draw_focus( page->tab_label );

	gtk_signal_emit_stop_by_name( GTK_OBJECT( window->window ), "key_press_event" );
}



/*
 ---------------------------------------------------------------------
     Function: gI_window_new()
     Desc: Opens a new Session
 ---------------------------------------------------------------------
*/
gI_window *gI_window_new( void )
{
	GtkTargetEntry dragtypes[] = { { "text/uri-list", 0, 0 } };
	gI_window *window;
	GtkWidget *vbox;
	gchar *title;

	window = g_malloc0( sizeof( gI_window ) );
	window->popup = g_malloc( sizeof(gI_text_popupmenu) );
	window->notebook = NULL;
	window->switch_page_id = FALSE;
	window->toolbar = NULL;

	/* Initialize Gnome Application */
	window->window = gnome_app_new( "gIDE", NULL );
	gtk_signal_connect( GTK_OBJECT( window->window ), "delete_event",
	                    GTK_SIGNAL_FUNC (window_destroy), window );

	gtk_window_set_policy( GTK_WINDOW( window->window ),
				TRUE, TRUE, TRUE );

	/* for small toolbar icons */
	/* this will be configurable in the future */
	/* maybe this value should be higher */
	if( gdk_screen_width() < 600 )
		gnome_preferences_set_toolbar_labels( FALSE );

	/* drag'n'drop */
	gtk_drag_dest_set( window->window, GTK_DEST_DEFAULT_ALL, dragtypes,
	                   sizeof(dragtypes) / sizeof(dragtypes[0]),
	                   GDK_ACTION_COPY );
	gtk_signal_connect( GTK_OBJECT( window->window ), "drag_data_received",
	                    GTK_SIGNAL_FUNC( gI_window_drag_recv ), (gpointer) window );

	title = g_strconcat( "gIDE", " ", VERSION, NULL );
	gtk_window_set_title( GTK_WINDOW( window->window ), title );
	g_free( title );
	gtk_widget_set_usize( window->window, 800, 550 );
	gtk_widget_realize (window->window);

	/* Create The Layout of the window */
	vbox = gtk_vbox_new (FALSE, 0);
	gnome_app_set_contents (GNOME_APP (window->window), vbox);
	gtk_widget_show (vbox);

	/*
	 * first part of splitted statusbar code:
	 * create the widget,
	 * for GNOME version: set statusbar in GnomeApp
	 */
	window->statusbar = gtk_statusbar_new ();
	gnome_app_set_statusbar( GNOME_APP( window->window ), window->statusbar );

	window->menubar = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), window->menubar, FALSE, TRUE, 0);
	gtk_widget_show (window->menubar);
	create_menubar (window->window, window->menubar);

	/* Add toolbar - Note: gcc/gnome seems temperamental about where these
	   ifdefs are placed, so please don't remove the duplicated code below
	   unless you make sure the toolbar works.*/

	window->toolbar_box = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), window->toolbar_box, FALSE, TRUE, 0);
	gtk_widget_show (window->toolbar_box);
	gI_create_toolbar (window->window, window->toolbar_box);

	/* Continue Layout */
	window->hpane = gtk_hpaned_new ();
	gtk_paned_gutter_size (GTK_PANED (window->hpane), 10 );
	gtk_paned_set_position( GTK_PANED( window->hpane ), 0 );
	gtk_box_pack_start (GTK_BOX (vbox), window->hpane, TRUE, TRUE, 0);
	gtk_widget_show (window->hpane);

	gI_window_create_popupmenu (window);

	window->tree_box = gtk_hbox_new (TRUE, 0);

	/* Project tree is on the left */
	gtk_paned_add1 (GTK_PANED (window->hpane), window->tree_box);

	create_prjftree (window);

	gtk_widget_hide (window->tree_box);
	gtk_widget_show (window->tree_frame);

	gI_document_new (window);

	gtk_paned_add2 (GTK_PANED (window->hpane), window->notebook);
	gtk_widget_show (window->notebook);

	/* statusbar */
	/*
	 * second part of statusbar code
	 * we had to split the statusbar code, 'cause we need the
	 * statusbar widget earlier to install the menu hints
	 *
	 * for non-GNOME-version: add statusbar widget to vbox
	 */
	gtk_widget_show (window->statusbar);

	/* add tools */
	add_all_tools( window );

	/* autosave */
	if (cfg->autosave)
	{
		window->timeout_id = gtk_timeout_add (cfg->autosave_freq * 1000, (GtkFunction) file_autosave, NULL);
	}
	else
	{
		window->timeout_id = 0;
	}

	gtk_signal_connect( GTK_OBJECT( window->window ), "key_press_event",
	                    GTK_SIGNAL_FUNC( switchto_next_doc ), window );

	gtk_widget_show (window->window);

	gtk_widget_queue_draw( window->window );
	gtk_widget_queue_resize( window->window );

	gtk_widget_show_all( window->window );

	return( window );
}


/*
 ---------------------------------------------------------------------
     Function: gI_window_clear_statusbar()
     Desc: Clears the Statusbar of a Window
 ---------------------------------------------------------------------
*/

void gI_window_clear_statusbar( gI_window *window )
{
	gtk_statusbar_pop( GTK_STATUSBAR( window->statusbar ), STATUSBAR_CONTEXT_CURSOR_POSITION );
}


/*
 ---------------------------------------------------------------------
     Function: gI_window_create_popupmenu()
     Desc: Creates PopUp-Menu
 ---------------------------------------------------------------------
*/

void gI_window_create_popupmenu(gI_window *window)
{
	window->popup->menu=gtk_menu_new();
	window->popup->menu_swaphc=gtk_menu_item_new_with_label( _("Open (swap) .c/.h file") );
	window->popup->menu_openfile_at_line=gtk_menu_item_new_with_label( _("Open Selected") );
	window->popup->menu_separator1=gtk_menu_item_new();
	window->popup->menu_cut=gtk_menu_item_new_with_label( _("Cut") );
	window->popup->menu_copy=gtk_menu_item_new_with_label( _("Copy") );
	window->popup->menu_paste=gtk_menu_item_new_with_label( _("Paste") );
	window->popup->menu_separator2=gtk_menu_item_new();
	window->popup->menu_save = gtk_menu_item_new_with_label( _("Save") );
	window->popup->menu_print = gtk_menu_item_new_with_label( _("Print") );
	window->popup->menu_close=gtk_menu_item_new_with_label( _("Close") );
#ifdef HAVE_GTKTEXT_PATCH
	window->popup->menu_separator3 = gtk_menu_item_new();
	window->popup->menu_rehilite = gtk_menu_item_new_with_label( _("Re-Highlight") );
#endif
	window->popup->menu_separator4 = gtk_menu_item_new();
	window->popup->menu_item_special = gtk_menu_item_new_with_label( _("Special") );
	window->popup->menu_special = gtk_menu_new();
	window->popup->menu_special_delete = gtk_menu_item_new_with_label( _("Delete active file") );
	window->popup->menu_special_insert = gtk_menu_item_new_with_label( _("Insert file") );
	window->popup->menu_special_mail = gtk_menu_item_new_with_label( _("Mail active document") );
	window->popup->menu_separator5 = gtk_menu_item_new();
	window->popup->menu_man = gtk_menu_item_new_with_label( _("Show Manual Page") );

	gtk_menu_append( GTK_MENU(window->popup->menu), window->popup->menu_swaphc );
	gtk_menu_append(GTK_MENU(window->popup->menu),
	                window->popup->menu_openfile_at_line );

	gtk_menu_append( GTK_MENU(window->popup->menu),
	                 window->popup->menu_separator1 );

	gtk_menu_append( GTK_MENU(window->popup->menu), window->popup->menu_cut );
	gtk_menu_append( GTK_MENU(window->popup->menu), window->popup->menu_copy );
	gtk_menu_append( GTK_MENU(window->popup->menu), window->popup->menu_paste );
	gtk_menu_append( GTK_MENU(window->popup->menu),
	                 window->popup->menu_separator2 );
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_save );
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_print );
	gtk_menu_append( GTK_MENU(window->popup->menu), window->popup->menu_close );
#ifdef HAVE_GTKTEXT_PATCH
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_separator3 );
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_rehilite );
#endif
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_separator4 );
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_item_special );

	gtk_menu_item_set_submenu( GTK_MENU_ITEM( window->popup->menu_item_special ), window->popup->menu_special );

	gtk_menu_append( GTK_MENU( window->popup->menu_special ), window->popup->menu_special_insert );
	gtk_menu_append( GTK_MENU( window->popup->menu_special ), window->popup->menu_special_delete );
	gtk_menu_append( GTK_MENU( window->popup->menu_special ), window->popup->menu_special_mail );

	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_separator5 );
	gtk_menu_append( GTK_MENU( window->popup->menu ), window->popup->menu_man );

	gtk_widget_show(window->popup->menu_swaphc);
	gtk_widget_show(window->popup->menu_openfile_at_line);
	gtk_widget_show(window->popup->menu_separator1);
	gtk_widget_show(window->popup->menu_cut);
	gtk_widget_show(window->popup->menu_copy);
	gtk_widget_show(window->popup->menu_paste);
	gtk_widget_show(window->popup->menu_separator2);
	gtk_widget_show( window->popup->menu_save );
	gtk_widget_show( window->popup->menu_print );
	gtk_widget_show(window->popup->menu_close);
#ifdef HAVE_GTKTEXT_PATCH
	gtk_widget_show( window->popup->menu_separator3 );
	gtk_widget_show( window->popup->menu_rehilite );
#endif
	gtk_widget_show( window->popup->menu_separator4 );
	gtk_widget_show( window->popup->menu_item_special );
	gtk_widget_show( window->popup->menu_special_insert );
	gtk_widget_show( window->popup->menu_special_delete );
	gtk_widget_show( window->popup->menu_special_mail );

	gtk_widget_show( window->popup->menu_separator5 );
	gtk_widget_show( window->popup->menu_man );

	gtk_signal_connect(GTK_OBJECT(window->popup->menu_swaphc),"activate",
	                   GTK_SIGNAL_FUNC(gI_document_cmd_swaphc),window);
	gtk_signal_connect(GTK_OBJECT(window->popup->menu_openfile_at_line),"activate",
	                   GTK_SIGNAL_FUNC(gI_document_cmd_open_file_at_line),window);

	gtk_signal_connect(GTK_OBJECT(window->popup->menu_cut),"activate",
	                   GTK_SIGNAL_FUNC(edit_cut),NULL);
	gtk_signal_connect(GTK_OBJECT(window->popup->menu_copy),"activate",
	                   GTK_SIGNAL_FUNC(edit_copy),NULL);
	gtk_signal_connect(GTK_OBJECT(window->popup->menu_paste),"activate",
	                   GTK_SIGNAL_FUNC(edit_paste),NULL);
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_save ), "activate",
	                    GTK_SIGNAL_FUNC( file_save ), NULL );
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_print ), "activate",
	                    GTK_SIGNAL_FUNC( file_print ), NULL );
	gtk_signal_connect(GTK_OBJECT(window->popup->menu_close),"activate",
	                   GTK_SIGNAL_FUNC(file_close),NULL);
#ifdef HAVE_GTKTEXT_PATCH
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_rehilite ), "activate",
	                    GTK_SIGNAL_FUNC( gI_hilite_rehilite ), NULL );
#endif
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_special_insert ), "activate",
	                    GTK_SIGNAL_FUNC( special_insert_file ), NULL );
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_special_delete ), "activate",
	                    GTK_SIGNAL_FUNC( special_remove_current_file ), NULL );
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_special_mail ), "activate",
	                    GTK_SIGNAL_FUNC( special_mail_doc ), NULL );
	gtk_signal_connect( GTK_OBJECT( window->popup->menu_man ), "activate",
	                    GTK_SIGNAL_FUNC( show_manpage ), NULL );
}


/*
 ---------------------------------------------------------------------
     Function: gI_window_set_statusbar()
     Desc: Sets the content of the Statusbar of a Window
 ---------------------------------------------------------------------
*/

void gI_window_set_statusbar( gI_document *document )
{
	gchar sb_msg[200];
	gchar buftxt[200];

	/* return, if no document is given */
	if( !document )
		return;

	if( document->filename != NULL )
	{
		g_snprintf( buftxt, sizeof(buftxt), "gIDE %s <%s>", VERSION, document->filename );
	}
	else
	{
		gchar *label, *label_dup;
		gchar *ptr;

		gtk_label_get( GTK_LABEL( document->label ), &label );

		label_dup = g_strdup( label );
		label = label_dup;

		ptr = strchr( label, '*' );
		if( ptr )
			*ptr = '\0';

		sprintf( buftxt, "gIDE %s %s", VERSION, label );

		g_free( label_dup );
	}

	g_snprintf( sb_msg, sizeof(sb_msg), _("%s, Size: %d bytes %s / [row:%d, col:%d] %s %s"),
	            document->filename?document->filename:_("(no file)"),
	            gI_text_get_length( document->text ),
	            document->changed?_("[modified]"):"",
	            document->x, document->y,
	            document->read_only?_(" / [read-only]"):"",
	            document->window->debug_window?_(" / [debug]"):""
	          );

	gtk_window_set_title( GTK_WINDOW( document->window->window ), buftxt);

	gtk_statusbar_pop( GTK_STATUSBAR( document->window->statusbar ), STATUSBAR_CONTEXT_CURSOR_POSITION );
	gtk_statusbar_push( GTK_STATUSBAR( document->window->statusbar ),
	                    STATUSBAR_CONTEXT_CURSOR_POSITION, sb_msg );
}


static void set_undo_redo( gI_document *current )
{
	GList *op_list;

	if( !current )
	{
		menus_set_sensitive( "/Edit/Undo", FALSE );
		menus_set_sensitive( "/Edit/Redo", FALSE );
		return;
	}

	if( !current->op_list )
	{
		menus_set_sensitive( "/Edit/Undo", FALSE );
		menus_set_sensitive( "/Edit/Redo", FALSE );
		return;
	}

	op_list = current->op_list;

	/* no more operations to redo, set sensitive false */
	if( op_list->next == NULL )
	{
		menus_set_sensitive( "/Edit/Redo", FALSE );
		menus_set_sensitive( "/Edit/Undo", TRUE );
		return;
	}

	/* no more operations to undo, set sensitive false */
	if( op_list->prev == NULL )
	{
		menus_set_sensitive( "/Edit/Undo", FALSE );
		menus_set_sensitive( "/Edit/Redo", TRUE );
		return;
	}
}


/*
 ---------------------------------------------------------------------
     Function: gI_window_switch_notebookpage()
     Desc: This function is called, when the Notebook-Page is switched
 ---------------------------------------------------------------------
*/

void gI_window_switch_notebookpage( GtkWidget *widget, GtkNotebookPage *page, guint page_num, gI_window *window )
{
	gI_document *current;

	if( !window )
		return;

	if( gI_document_get_no( window ) < page_num )
	{
		return;
	}

	current = gI_document_get_nth( window, page_num+1 );
	if( !current )
	{
		return;
	}

	/* disconnect signal from menu item */
	/* gtk_signal_disconnect_by_func( GTK_OBJECT( menus_get_item_widget( "/Edit/Read Only" ) ), GTK_SIGNAL_FUNC( edit_read_only ), NULL ); */

	gI_window_set_visible_read_only( TRUE );

	/* set check menu item state & correct editable flag in widget */
	ro_not_change = 1;
	gtk_check_menu_item_set_state( GTK_CHECK_MENU_ITEM( menus_get_item_widget( "/Edit/Read Only" ) ), current->read_only );
	if( current->read_only )
		gI_text_set_editable( current->text, FALSE );
	else
		gI_text_set_editable( current->text, TRUE );
	ro_not_change = 0;

	set_read_only( !current->read_only );

	/* gtk_signal_connect( GTK_OBJECT( menus_get_item_widget( "/Edit/Read Only" ) ), "activate", GTK_SIGNAL_FUNC( edit_read_only ), NULL ); */

	set_undo_redo( current );

	gI_window_clear_statusbar( window );

	gI_window_set_statusbar( current );

	gtk_widget_grab_focus( current->text );

	check_current_doc();
}


/*
 ---------------------------------------------------------------------
     Function: gI_window_set_visible_read_only()
     Desc: This function sets the Read-Only entry sensitive true or false 
 ---------------------------------------------------------------------
*/

void gI_window_set_visible_read_only( gint sensitive )
{
	menus_set_sensitive( "/Edit/Read Only", sensitive );
	if( sensitive == FALSE )
		gtk_check_menu_item_set_state( GTK_CHECK_MENU_ITEM( menus_get_item_widget( "/Edit/Read Only" ) ), FALSE );
}


void gI_window_drag_recv( GtkWidget *widget, GdkDragContext *context, gint x,
                          gint y, GtkSelectionData *seldata, guint info,
                          guint time, gI_window *window )
{
	GList *files, *fnp;
	gint count;
	gchar *fname;

	/* get filenames */
	files = gnome_uri_list_extract_filenames( (gchar *) seldata->data );
	count = g_list_length( files );

	/* open files */
	if( count > 0 )
	{
		fnp = g_list_first( files );
		while( fnp )
		{
			fname = (gchar *) fnp->data;

			file_open_by_name( window, fname );

			fnp = g_list_next( fnp );
		}
	}

	gnome_uri_list_free_strings( files );
}

