/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef HAVE_CONFIG_H            /* Config */
# include "config.h"
#endif

/* I18N support */
#if defined ENABLE_NLS && defined HAVE_LIBINTL_H
# include <libintl.h>
# undef _
# define _(String) gettext (String)
# ifdef gettext_noop
#  define N_(String) gettext_noop (String)
# else
#  define N_(String) (String)
# endif /* gettext_noop */
#else
# define textdomain(S) (S)
# define gettext(S) (S)
# define dgettext(D,M) (M)
# define dcgettext(D,M,T) (M)
# define _(S) (S)
# define N_(S) (S)
#endif

void giftui_exit (void);

#endif
