/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_CHILD__
#define __UI_CHILD__

#include <gtk/gtk.h>

/*
  GtkVBox
      +----GiftuiChild
*/

#define GIFTUI_TYPE_CHILD (giftui_child_get_type ())
#define GIFTUI_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_CHILD, GiftuiChild))
#define GIFTUI_CHILD_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_CHILD, GiftuiChildClass))
#define GIFTUI_IS_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_CHILD))
#define GIFTUI_IS_CHILD_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_CHILD))
#define GIFTUI_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_CHILD, GiftuiChildClass))

typedef enum
{
	GIFTUI_CHILD_SEARCH = 0,
	GIFTUI_CHILD_BROWSE,
	
	GIFTUI_CHILD_TRANSFER,
	GIFTUI_CHILD_ABOUT,
	GIFTUI_CHILD_PREF
} GiftuiChildType_t;

typedef struct _GiftuiChild GiftuiChild;
typedef struct _GiftuiChildClass GiftuiChildClass;

struct _GiftuiChild
{
	GtkVBox parent_instance;
	
	/* < private_data > */
	GtkWidget *parent;
	GiftuiChildType_t type;
	
	GtkWidget *hbox;
	
	GtkWidget *icon;
	GtkWidget *label;
	GtkWidget *close_button;
	
	GtkWidget *menu_label;
	
	gboolean highlight : 1;
	gboolean close : 1;
};

struct _GiftuiChildClass
{
	GtkVBoxClass parent_class;
};

GType giftui_child_get_type (void);

void giftui_child_set_text (GiftuiChild *child, const gchar *text);
void giftui_child_set_image_from_stock (GiftuiChild *child, const gchar *stock_id);
void giftui_child_set_highlight (GiftuiChild *child, gboolean highlight);
void giftui_child_set_close (GiftuiChild *child, gboolean close);

#endif
