/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_UTILS_H__
#define __UI_UTILS_H__

#include <gtk/gtk.h>

#define HORIZONTAL (0)
#define VERTICAL   (1)

/* Color convertion */
gboolean str_to_color (GdkColor *color, const gchar *str);
gchar *color_to_str (const GdkColor *color);

/* All */
void widget_set_sensitivity_invert (GtkWidget *widget);

/* Separators */
void widget_vhseparator_add (GtkBox *box, gint orientation);

/* Menu */
GtkWidget *widget_menu_add (GtkMenuItem *item);
GtkWidget *widget_menu_item_add (GtkMenu *menu, const gchar *title);
GtkWidget *widget_menu_image_add (GtkMenu *menu, const gchar *title, GtkWidget *image);

/* Check */
GtkWidget *widget_check_add (GtkBox *box, const gchar *title);

/* Entry */
GtkWidget *widget_entry_add_chars (GtkBox *box, const gchar *title,
				   const gchar *value, gint max_char);
gchar *widget_entry_get_chars (GtkEntry *entry);
void widget_entry_set_chars (GtkEntry *entry, const gchar *text);

/* Spin */
GtkWidget *widget_spin_add_float (GtkBox *box, const gchar *title,
				  gfloat value, gfloat max, gfloat min,
				  gfloat step);
gfloat widget_spin_get_float (GtkSpinButton *spin);
void widget_spin_set_float (GtkSpinButton *spin, gfloat value);
/**/
GtkWidget *widget_spin_add_int (GtkBox *box, const gchar *title,
				gint value, gint max, gint min,
				gint step);
gint widget_spin_get_int (GtkSpinButton *spin);
void widget_spin_set_int (GtkSpinButton *spin, gint value);

/* Color selectors */
GtkWidget *widget_button_color_sel_add_from_str (GtkBox *box, const gchar *text);

/* Tooltips */
void widget_tooltips_set_tip (GtkTooltips *tips, GtkWidget *widget, const gchar *text);

/* GtkItemFactory */
GtkWidget *gtk_menu_from_factoryentry (GtkItemFactoryEntry *entrys, GType type, gint nb,
				       GtkWidget *window, gpointer data);

/* Combo */
GtkWidget *gtk_combo_add_with_title (GtkBox *box, const gchar *title,
					gint max_char);
void gtk_combo_entry_add_text (GtkCombo *combo, const gchar *text);

/* GtkTreeStore */
void gtk_tree_store_remove_children (GtkTreeStore *store, GtkTreeIter *parent);

/* GtkTreeSelection */
void gtk_tree_selection_selected_foreach_rm (GtkTreeSelection *selection,
					     GtkTreeSelectionForeachFunc func,
					     gpointer data);

/* Separators */
/*void widget_vhseparator_add (GtkWidget *box, gint orientation);*/

/* Checks */
/*void widget_check_clicked (GtkWidget *button, gint *value);
GtkWidget *widget_check_add (GtkWidget *box, gint *value,
const gchar *title);*/

/* Radios */
/*void widget_radio_clicked (GtkWidget *button, gint val);
GtkWidget *widget_radio_add (GtkWidget *box, GtkWidget *from,
			     gint val, gint *value,
			     const gchar *title);*/

#endif
