/*
 * GTK See -- a image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef __ICON_WIDGET_H__
#define __ICON_WIDGET_H__

#include <gtk/gtk.h>

#define ICON_WIDGET(obj)         GTK_CHECK_CAST (obj, icon_widget_get_type (), IconWidget)
#define ICON_WIDGET_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, icon_widget_get_type (), IconWidgetClass)
#define IS_ICON_WIDGET(obj)      GTK_CHECK_TYPE (obj, icon_widget_get_type ())

typedef struct _IconWidget       IconWidget;
typedef struct _IconWidgetClass  IconWidgetClass;

struct _IconWidgetClass
{
   GtkWidgetClass parent_class;
};

struct _IconWidget
{
   GtkWidget widget;
	
   GdkPixmap *pixmap;
   GdkBitmap *mask;
   guint      width;  /* icon image frame width */
   guint      height; /* icon image frame height */
   guint      xpad;
   guint      ypad;
   guint      space;
   guchar     label[80];
   gint       lines;
   gboolean   color_set;
   GdkGC     *bg_gc;
   GdkColor   color;
};

guint      icon_widget_get_type   ();
GtkWidget *icon_widget_new        (GdkPixmap   *pixmap,
				   GdkBitmap   *mask,
				   guchar      *label,
				   guint        width,
				   guint        height);
void       icon_widget_set_color  (IconWidget  *ii,
				   GdkColor    *color);
void       icon_widget_set_pixmap (IconWidget  *ii,
				   GdkPixmap   *pixmap,
				   GdkBitmap   *mask);

#endif
