/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __THUMBNAIL_VIEW_H__
#define __THUMBNAIL_VIEW_H__

#include <sys/stat.h>
#include <unistd.h>

#include "gimageview.h"

#include "fileload.h"
#include "image_info.h"
#include "thumbnail_support.h"

#define DEFAULT_DISP_MODE "Thumbnail"
#define DEFAULT_DISP_MODE_NUM 0
#define ICON_SIZE 18


struct Thumbnail_Tag
{
   ImageInfo *info;

   GtkWidget  *pixmap;
   GtkWidget  *icon;

   ThumbView  *thumb_view;

   ThumbCacheType cache_type;
   gint        thumb_width;
   gint        thumb_height;

   gboolean    selected;
   gboolean    sync;

   GHashTable  *mode_data;
};


typedef enum
{
   THUMB_MODE_COLLECTION,
   THUMB_MODE_DIR
} ThumbViewMode;


struct ThumbView_Tag
{
   /* file (thumbnail) list */
   GList       *thumblist;

   /* parent */
   ThumbWindow *thumb_window;
   GtkWidget   *container;

   GtkWidget       *popup_menu;

   gchar       *tabtitle;
   gint         ThumbnailSize;

   ThumbViewMode   mode;      /* dir mode or filelist mode */
   gchar          *dirname;   /* store dir name if mode is dirmode */
   gint            filenum;
   gint            filesize;

   gint            disp_mode;

   /* file load progress infomation */
   OpenFiles   *progress;

   GHashTable  *disp_mode_data;

   GList       *related_image_view;
};

extern GList *ThumbViewList;


/* for thumbnail view modules */
typedef GtkWidget *(*ThumbViewCreateFunc)         (ThumbView     *tv,
						   gint           dest_mode);
typedef gboolean   (*ThumbViewAddThumbFramesFunc) (ThumbView     *tv,
						   GList         *start,
						   gint           dest_mode);
typedef GtkWidget *(*ThumbViewAddThumbFunc)       (Thumbnail     *thumb,
						   gint           dest_mode,
						   ThumbLoadType  type);
typedef gboolean   (*ThumbViewRefreshThumbFunc)   (Thumbnail     *thumb);
typedef GtkWidget *(*ThumbViewRedrawFunc)         (ThumbView     *tv,
						   gint           mode,
						   GtkWidget     *scroll_win);
typedef GtkWidget *(*ThumbViewResizeFunc)         (ThumbView     *tv);
typedef void       (*ThumbViewAdjustFunc)         (ThumbView     *tv,
						   Thumbnail     *thumb);
typedef void       (*ThumbViewDestroyFunc)        (ThumbView     *tv);
typedef void       (*ThumbViewDataRemoveFunc)     (ThumbView     *tv);
typedef void       (*ThumbnailDataRemoveFunc)     (Thumbnail     *thumb);
typedef gboolean   (*ThumbViewSetSelectionFunc)   (Thumbnail     *thumb,
						   gboolean       select);


typedef struct ThumbDispMode_Tag
{
   gchar *label;

   ThumbViewCreateFunc         create_func;
   ThumbViewAddThumbFramesFunc add_thumb_frames_func;
   ThumbViewAddThumbFunc       add_thumb_func;
   ThumbViewRefreshThumbFunc   refresh_thumb_func;
   ThumbViewRedrawFunc         redraw_func;
   ThumbViewResizeFunc         resize_func;
   ThumbViewAdjustFunc         adjust_func;
   ThumbViewDestroyFunc        destroy_func;
   ThumbViewDataRemoveFunc     thumbview_data_remove_func;
   ThumbnailDataRemoveFunc     thumbnail_data_remove_func;
   ThumbViewSetSelectionFunc   set_selection_func;
} ThumbDispMode;


/* reference callback functions used by child module */
void        thumbview_thumb_button_press_cb  (GtkWidget        *widget,
					      GdkEventButton   *event,
					      Thumbnail        *thumb);
void        thumbview_thumb_button_release_cb(GtkWidget        *widget,
					      GdkEventButton   *event,
					      Thumbnail        *thumb);
gint        thumbview_motion_notify_cb       (GtkWidget        *widget,
					      GdkEventMotion   *event,
					      Thumbnail        *thumb);
void        thumbview_drag_begin_cb          (GtkWidget        *widget,
					      GdkDragContext   *context,
					      gpointer          data);
void        thumbview_drag_data_received_cb  (GtkWidget        *widget,
					      GdkDragContext   *context,
					      gint              x,
					      gint              y,
					      GtkSelectionData *seldata,
					      guint             info,
					      guint32           time,
					      gpointer          data);
void        thumbview_drag_data_get_cb       (GtkWidget        *widget,
					      GdkDragContext   *context,
					      GtkSelectionData *seldata,
					      guint             info,
					      guint             time,
					      gpointer          data);
void        thumbview_drag_end_cb            (GtkWidget        *widget,
					      GdkDragContext   *drag_context,
					      gpointer          data);
void        thumbview_drag_data_delete_cb    (GtkWidget        *widget,
					      GdkDragContext   *drag_context,
					      gpointer          data);

/* thumbnail view handling functions used by parent module */
gint        thumbview_get_disp_modes_length ();
gint        thumbview_label_to_num          (gchar        *label);
gchar      *thumbview_num_to_label          (gint          num);
gchar     **thumbview_get_disp_mode_labels  (gint         *num_ret);

void        thumbview_free_thumbnail        (Thumbnail    *thumb);
void        thumbview_free                  (ThumbView    *tv);
void        thumbview_delete                (ThumbView    *tv);
ThumbView  *thumbview_find_opened_dir       (const gchar  *path);
void        thumbview_sort_data             (ThumbView    *tv);
gboolean    thumbview_load_thumbnails       (ThumbView    *tv,
					     GList        *start,
					     gint          dest_mode);
gboolean    thumbview_append_thumbnail      (ThumbView    *tv,
					     OpenFiles    *files,
					     gboolean      force);
GtkWidget  *thumbview_redraw                (ThumbView    *tv,
					     gint          mode,
					     GtkWidget    *scroll_win);
GtkWidget  *thumbview_change_mode           (ThumbView    *tv,
					     gint          mode);
gboolean    thumbview_refresh_thumbnail     (Thumbnail    *thumb);
gboolean    thumbview_refresh_list          (ThumbView    *tv);
GtkWidget  *thumbview_resize                (ThumbView    *tv);
void        thumbview_adjust                (ThumbView    *tv,
					     Thumbnail    *thumb);
GList      *thumbview_get_selection_list    (ThumbView    *tv);
gboolean    thumbview_set_selection         (Thumbnail    *thumb,
					     gboolean      select);
gboolean    thumbview_set_selection_all     (ThumbView    *tv,
					     gboolean      select);
gboolean    thumbview_set_selection_multiple(Thumbnail    *thumb,
					     gboolean      reverse,
					     gboolean      clear);
ThumbView  *thumbview_create                (OpenFiles    *files,
					     ThumbWindow  *tw,
					     GtkWidget    *container,
					     ThumbViewMode mode);
#endif /* __THUMBNAIL_VIEW_H__ */
