/*
 *  
 *  $Id: icontexto.cpp 3746 2011-04-19 10:41:32Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */

#include "icontexto.h"
#include <iostream>
#include <cairo/cairo.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkginkgoimageviewer.h>

void GNC::GCS::Contexto3D::CrearOffscreen()
{
	if (offscreenCreado) {
		DestruirOffscreen();
	}

	if (ancho < 0 || alto < 0) {
		return;
	}
	
	const int numCanales = 4;
	int rowStride = ancho * numCanales;
	pixelData = (unsigned char*)calloc(rowStride, alto);

	if (pixelData == NULL) {
		return;
	}

	cs = cairo_image_surface_create_for_data(pixelData, CAIRO_FORMAT_ARGB32, ancho, alto, rowStride);
	if (cairo_surface_status(cs) != CAIRO_STATUS_SUCCESS) {
		std::cerr << "Error al crear surface" << std::endl;
		cairo_surface_destroy(cs);
		cs =  NULL;
		free(pixelData);
		pixelData = NULL;
		return;
	}
	else {
		cr = cairo_create(cs);
		if (cairo_status(cr) != CAIRO_STATUS_SUCCESS) {
			cairo_destroy(cr);
			cr = NULL;
			cairo_surface_destroy(cs);
			cs = NULL;
			free(pixelData);
			pixelData = NULL;
			return;
		}
	}
	//relacion mundo/pantalla
	m_RelacionMundoPantallaOffscreen = GNC::GCS::Vector( ancho, alto) * (1.0f/720.0f);
	factorReescalado = GNC::GCS::Vector::Unidad();
	offscreenCreado = true;
}

void GNC::GCS::Contexto3D::DestruirOffscreen()
{
	if (!offscreenCreado) {
		return;
	}
	if (cr != NULL) {
		cairo_destroy(cr);
		cr = NULL;
	}
	if (cs != NULL) {
		cairo_surface_destroy(cs);
		cs = NULL;
	}
	if (pixelData != NULL) {
		free(pixelData);
		pixelData = NULL;
	}

	offscreenCreado = false;
}

GNC::GCS::Vector GNC::GCS::Contexto3D::Reproyectar(const GNC::GCS::Vector& v)
{

	GNC::GCS::Vector vp = v;

	return vp;
}

