/*
 *  
 *  $Id: herramientadesencajar.cpp 4478 2011-12-13 11:55:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/wx.h>
#include <wx/menu.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include "herramientadesencajar.h"

#include <api/globals.h>
#include <main/entorno.h>
#include <main/controllers/controladorlog.h>
#include <resources/ginkgoresourcemanager.h>
#include <api/icontextoestudio.h>

//----------------------------------------------------------------------
#define ACTIVAR_RESET  1246

namespace GNC {
	namespace GUI {
		class EventHandlerDesencajar: public wxEvtHandler {
		public:
			EventHandlerDesencajar(wxWindow* pParent, GNC::HerramientaDesencajar* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(ACTIVAR_RESET, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerDesencajar::OnActivarDesencajarClick),NULL,this);
				m_pParent->Connect(ACTIVAR_RESET, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerDesencajar::OnUpdateResetUI),NULL,this);
			}

			~EventHandlerDesencajar()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerDesencajar::OnActivarDesencajarClick),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerDesencajar::OnUpdateResetUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnActivarDesencajarClick( wxCommandEvent& event )
			{
				m_pHerramienta->SolicitarActivacion(GNC::GCS::TriggerButton().EnableLeft());
				event.Skip(false);
			}

			void OnUpdateResetUI(wxUpdateUIEvent& event) {
				event.Enable(m_pHerramienta->EstaHabilitada());
				if(m_pHerramienta->IsDesencajada())
				{
					event.SetText(_("Fit View"));
				} else {
					event.SetText(_("Disengage view"));
				}
			}

			GNC::HerramientaDesencajar* m_pHerramienta;
			wxWindow* m_pParent;
		};


		class MenuHerramientaDesencajar : public wxMenuItem {
		public:
			MenuHerramientaDesencajar(wxWindow* pParent, wxMenu* pMenuPadre, GNC::HerramientaDesencajar* pHerramienta):wxMenuItem(pMenuPadre,ACTIVAR_RESET,_("Reset window level and zoom"),_("Reset window level and zoom"),wxITEM_NORMAL) {
				pEventHandler = new EventHandlerDesencajar(pParent,pHerramienta);
#ifdef __WXMSW__
				SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoReset());
				//#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuHerramientaDesencajar() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerDesencajar* pEventHandler;
		};
	}
}


GNC::HerramientaDesencajar::HerramientaDesencajar()
{
	m_Descripcion = _Std("Disengage");
	m_IsMenu = true;
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoDesencajar();
}

GNC::HerramientaDesencajar::~HerramientaDesencajar()
{
}

bool GNC::HerramientaDesencajar::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuHerramientaDesencajar(pParent,pMenuParent,this));
	return true;
}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaDesencajar::CrearPaneles( wxPanel* /*pParent*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

bool GNC::HerramientaDesencajar::EstaHabilitada()
{
	return m_pVistaActiva != NULL;
}

void GNC::HerramientaDesencajar::SolicitarActivacion(const GNC::GCS::TriggerButton&)
{
	Desencajar(m_pVistaActiva);
}

void GNC::HerramientaDesencajar::Desencajar(GNC::GCS::IVista* pVista)
{
	if (pVista != NULL) {
		GNC::Entorno::Instance()->GetVentanaPrincipal()->EncajarDesencajar(pVista);
	}
}

bool GNC::HerramientaDesencajar::IsDesencajada()
{
	//si el padre de la vistapadre de la vista es un dialogo esta desencajada si no no

	if(m_pVistaActiva != NULL)
	{
		wxWindow* pVentana = m_pVistaActiva->GetWindow();
		if(pVentana != NULL) {
			wxWindow* pVentanaPadre = pVentana->GetParent();
			if(pVentanaPadre != NULL) {
				wxFrame* pdlg = dynamic_cast<wxFrame*>(pVentanaPadre);
				if(pdlg != NULL) {
					return true;
				}
				else {
					return false;
				}
			}
		}
		else {
			LOG_WARN("Core/HerramientaDesencajar", "Error al obtener la ventana asociada a la vista para comprobar encaje. Incosistencia interna");
		}
	}
	else {
		//LOG_WARN("Core/HerramientaDesencajar", "Comprobacion de encaje incosistente");
	}
	return false;

}

void GNC::HerramientaDesencajar::ConectarContratoFalso(bool ) {
	if (m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

void GNC::HerramientaDesencajar::SetVistaActiva(GNC::GCS::IVista* pVista) {
	EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaDesencajar::EstablecerVistaActiva(pVista)::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaDesencajar::ConectarContratos(bool )
{
	if (m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

//endregion


