/*
 *  
 *  $Id: gwaveformview.h 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include "visualizatorviews.h"
#include <api/icontroladoreventos.h>
#include <export/icontratoscore.h>
#include <api/ianotador.h>

class vtkGinkgoImageViewer;

namespace GNKVisualizator{
	namespace Widgets {
		class WECG;
	}
	class WaveFormView;
	namespace GUI {
		class GWaveformViewButtonBar;
			
		class GWaveformView : public GWaveformViewBase, public GNC::GCS::IContratoWidgets, public GNC::GCS::IObservador, public GNC::GCS::IAnotador
		{
		public:
			/* Constructor */
			GWaveformView(GNKVisualizator::WaveFormView* pView);

			/* Destructor */
			~GWaveformView();

			void InitPipeline();

			void StopPipeline();

			void OnFinishLoad();

			virtual vtkGinkgoImageViewer* GetViewerActivo();

			void OnPaint(wxPaintEvent& event);
			virtual void OnComboGroup(wxCommandEvent &event);
			virtual void OnShowHideMetadata(wxCommandEvent &event);
			virtual void ShowMetaData(bool show);
			virtual void OnShowHideCornerAnnotations(wxCommandEvent &event);

			//Ianotador
			std::string GetDICOMTag(std::string tagId);
			virtual std::string GetTopLeftAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetTopRightAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetBottomRightAnnotation(GNC::GCS::Contexto3D* c);
			virtual std::string GetAnotacionPosicion(GNC::GCS::Vector* pPosicionRaton);
			//

		protected:
			
			void PreProcesarEvento(GNC::GCS::Eventos::IEvento* evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista);
			void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;

			GNKVisualizator::WaveFormView* View;
			GNKVisualizator::Widgets::WECG* WECG;
			GWaveformViewButtonBar* m_pButtonBar;
		};
	}
}

