/*
 *  
 *  $Id: surface.h 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include "reconstructionviews.h"
#include <yasper/yasper.h>
#include "../../estudios/visualizatorstudy.h"
#include <api/icontroladoreventos.h>

namespace GNC {
	namespace GUI {
		class StatusBarProgreso;
	}
	namespace GCS {
		class IComando;
	}
}

namespace MedicalViewer {
	namespace Reconstruction {
		namespace DataSet {
			class Slice;
			class DataSet;
		}

		namespace Pipelines {
			class SurfacePipeline;
		}
	}
}

namespace MedicalViewer {

	namespace Reconstruction {

		namespace GUI {
			class SurfaceTimerDemo;

			class wxSurfaceRendering : public wxSurfaceRenderingBase, public GNC::GCS::IObservador
			{
			public:
				typedef GNC::GCS::IContextoEstudio         TStudy;
				typedef GNC::GCS::IContextoEstudioReferido TRefStudy;
				typedef MedicalViewer::Reconstruction::Pipelines::SurfacePipeline TPipeline;

				wxSurfaceRendering(wxWindow* pParent, const GnkPtr<TStudy>& study);
				~wxSurfaceRendering();


			public:
				void SetStereo(bool enabled);
				void SetDemo(bool enabled);
				void ResetCamera();

				void SaveFrameToSerie();

			public:

				virtual void OnWindowSize( wxSizeEvent& event );
				virtual void OnToolTitleButtonClick( wxCommandEvent& event );
				virtual void OnTitleLeftUp( wxMouseEvent& event );
				virtual void OnToolSurface1TextChanged( wxCommandEvent& event );
				virtual void OnCheckEnable2( wxCommandEvent& event );
				virtual void OnToolSurface2TextChanged( wxCommandEvent& event );
				virtual void OnEraseBackground( wxEraseEvent& event );
				virtual void OnDataSetSliderChanged( wxScrollEvent& event );
				virtual void OnApplyClick(wxCommandEvent &event);
				virtual void OnComboFirstValue(wxCommandEvent &event);
				virtual void OnComboSecondValue(wxCommandEvent &event);
				virtual void SetValueCombo(int selection, wxTextCtrl* pText);
				virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);


			protected:
				GnkPtr<TRefStudy> RefStudy;
				GnkPtr<TPipeline> Pipeline;
				SurfaceTimerDemo* m_pTimer;
				bool m_editing;
				GNC::GUI::StatusBarProgreso* m_pProgressBar;

			};
		}
	}
}
