/*
*  
*  $Id: volumedataset.cpp 3558 2011-03-20 20:02:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "volumedataset.h"
#include <api/icontextoestudio.h>
#include <vtkImageData.h>
#include <vtkImageCast.h>
#include <main/controllers/controladorlog.h>
#include <vtkMatrix4x4.h>
#include <vtkAlgorithmOutput.h>

MedicalViewer::Reconstruction::DataSet::Slice::Slice(int id) {
	this->id = id;
	cosines[0] = cosines[1] = cosines[2] = cosines[3] = cosines[4] = cosines[5] = cosines[6] = cosines[7] = cosines[8] = 0.0;

}
MedicalViewer::Reconstruction::DataSet::DataSet::DataSet(const GnkPtr<GNC::GCS::IContextoEstudioReferido>& ref, const GnkPtr<Slice>& slice) : RefStudy(ref)
{
	MinValue = MaxValue = 0;

	dims.x = slice->dims.x;
	dims.y = slice->dims.y;
	spacing.x = slice->spacing.x;
	spacing.y = slice->spacing.y;
	origin = slice->origin;

	for (int i = 0; i < 9; i++) {
		cosines[i] = slice->cosines[i];
	}
	vtkSmartPointer<vtkMatrix4x4> Matrix = vtkSmartPointer<vtkMatrix4x4>::New();

	Matrix->SetElement(0, 0, cosines[0]);
	Matrix->SetElement(1, 0, cosines[3]);
	Matrix->SetElement(2, 0, cosines[6]);
	Matrix->SetElement(3, 0, 0.0);

	Matrix->SetElement(0, 1, cosines[1]);
	Matrix->SetElement(1, 1, cosines[4]);
	Matrix->SetElement(2, 1, cosines[7]);
	Matrix->SetElement(3, 1, 0.0);

	Matrix->SetElement(0, 2, cosines[2]);
	Matrix->SetElement(1, 2, cosines[5]);
	Matrix->SetElement(2, 2, cosines[8]);
	Matrix->SetElement(3, 2, 0.0);


	Matrix->SetElement(0, 3, 0.0);
	Matrix->SetElement(1, 3, 0.0);
	Matrix->SetElement(2, 3, 0.0);
	Matrix->SetElement(3, 3, 1.0);

	double pt[4] = {0.0, 0.0, 1.0, 1.0};

	double* r = Matrix->MultiplyDoublePoint(pt);

	vdir[0] = r[0];
	vdir[1] = r[1];
	vdir[2] = r[2];

	//std::cout << "vdir = " << vdir << std::endl;

	DoAdd(slice);

}

MedicalViewer::Reconstruction::DataSet::DataSet::~DataSet()
{

}


void MedicalViewer::Reconstruction::DataSet::DataSet::Compute()
{

	LOG_WARN("Reconstruction/Surface", "Resampling volume not implemented");

	if (size() == 0) {
		dims[0] = dims[1] = dims[2] = 0;
		spacing[0] = spacing[1] = spacing[2] = origin[0] = origin[1] = origin[2] = 0.0;
		vdir[0] = vdir[1] = vdir[2] = 0.0;
		for (int i = 0; i < 9; i++) {
			cosines[i] = 0;
		}
		LOG_ERROR("Reconstruction/Surface", "Empty volume");
		return;
	}
	else {
		{
			const GnkPtr<Slice>& first = front();
			dims = first->dims;
			spacing = first->spacing;
			origin = first->origin;
			dims[2] = 0;
			for (SliceList::iterator it = begin(); it != end(); it++) {
				dims[2] += (*it)->dims[2];
			}
			const GnkPtr<Slice>& last = back();
			GNC::GCS::Vector3D dist = last->origin - first->origin;
			spacing[2] = (dist.Norma2() + last->spacing[2] * (last->dims[2] - 1)) / dims[2];
		}
	}
	Img = vtkSmartPointer<vtkImageData>::New();
	Img->SetNumberOfScalarComponents(1);
	Img->SetDimensions(dims.v);
	Img->SetOrigin(origin.v);
	Img->SetSpacing(spacing.v);
	Img->SetScalarTypeToShort();
	Img->SetUpdateExtentToWholeExtent();
	Img->AllocateScalars();

	short* dstptr = (short*)Img->GetScalarPointer();

	vtkSmartPointer<vtkImageCast> caster = vtkSmartPointer<vtkImageCast>::New();
	caster->SetOutputScalarTypeToShort();

	int i = 0;

	for (SliceList::iterator it = begin(); it != end(); it++, i++) {
		unsigned long slicesize = dims[0] * dims[1] * (*it)->dims[2];
		RefStudy->SetIndiceActivo(i);
		caster->SetInputConnection(RefStudy->GetLoaderOutputConnection());
		caster->UpdateWholeExtent();

		short* srcptr = (short*) caster->GetOutput()->GetScalarPointer();

		for (unsigned long offr = 0; offr < slicesize; offr++) {
			const short Val = *(srcptr++);
			MinValue = std::min<short>(MinValue, Val);
			MaxValue = std::max<short>(MaxValue, Val);
			*(dstptr++) = Val;
		}
	}
}

/** Checks if the slice with corresponding cosines can belongs to this dataset **/
bool MedicalViewer::Reconstruction::DataSet::DataSet::Add(const GnkPtr<Slice>& slice)
{
	for (int i = 0; i < 9; i++) {
		if (this->cosines[i] != slice->cosines[i]) {
			return false;
		}
	}
	if (slice->dims.x == dims.x && slice->dims.y == dims.y && slice->spacing.x == spacing.x && slice->spacing.y == spacing.y) {
		for (SliceList::iterator it = begin(); it != end(); it++) {
			if ( (*it)->origin == slice->origin ) {
				return false;
			}
		}
		DoAdd(slice);
		return true;
	}
	return false;
}

void MedicalViewer::Reconstruction::DataSet::DataSet::DoAdd(const GnkPtr<Slice>& slice)
{
	//double pt[4] = {0.0, 0.0, 0.0, 1.0};
	GNC::GCS::Vector3D ptm;
	//std::cout << "-----" << std::endl;
	SliceList::iterator it = begin(), pos = begin();

	int slice_num = 0;

	if (it == end()) {
		push_back(slice);
		origin = slice->origin;
	}
	else {
		bool precedes = false;
		while (!precedes && it != end()) {
			GNC::GCS::Vector3D diff = slice->origin - (*it)->origin;
			//std::cout << "\t\t  diff(cur, " << i << " ) = " << diff << std::endl;
			//std::cout << "\t\t  vdir(cur, " << i << " ) = " << vdir << std::endl;
			for(int i = 0; !precedes && i < 3; i++) {
				if ( (vdir.x > 0.0 && diff.x <= 0 ) || (vdir.x < 0.0 && diff.x >= 0) || (vdir.x == 0 && diff.x != 0) ) {
					precedes = true;
				}
			}
			if (!precedes) {
				it++;
				slice_num++;
			}
		}
		if (precedes) {
			std::cout << "Slice inserted at " << slice_num << std::endl;
			LOG_WARN("Reconstruction/Surface", "Slice reordenation: " << size() << " => " << slice_num);
			this->insert(it, slice);
		}
		else {
			//std::cout << "Slice attached at end " << std::endl;
			push_back(slice);
		}
	}
}
