/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtkrootpointbutton.h"

#include "glrr-glib.h"
#include "glrr-gtk.h"



static void builtin_module_init (void);

static gpointer create_panel_widget_picker (gpointer data,
					    gpointer func_data,
					    gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_widget_picker (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-widget-picker";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-widget-picker",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  create_panel_widget_picker,
				  NULL);
}



static gboolean
timeout_handler (gpointer data)
{
  GInspectorElementHolder *element_holder;
  GtkWidget *tmp_widget;
  GtkWidget *widget;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (data);

  tmp_widget = gtk_get_widget_at_pointer ();

  if ((tmp_widget != NULL) &&
      (g_inspector_tag_check_widget (tmp_widget) != TRUE))
    {
      widget = tmp_widget;
    }
  else
    {
      widget = NULL;
    }

  if (widget != NULL)
    {
      g_inspector_element_holder_set_gobject (element_holder,
					      G_OBJECT (widget));
    }
  else
    {
      g_inspector_element_holder_unset (element_holder);
    }


  return TRUE;
}

static void
element_holder_changed (GInspectorElementHolder *element_holder,
			gpointer                 user_data)
{
  GInspectorElementType element_type;
  gpointer element;
  GInspectorPanel *panel;
  GtkWidget *widget;

  element_type = g_inspector_element_holder_get_element_type (element_holder);
  element = g_inspector_element_holder_get_element (element_holder);

  panel = G_INSPECTOR_PANEL (user_data);


  if ((element_type == G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE) &&
      GTK_IS_WIDGET (element))
    {
      widget = element;
    }
  else
    {
      widget = NULL;
    }

  {
#define SET(n,f,a) \
    G_STMT_START { 									    \
      if (widget != NULL) {								    \
	gtk_label_set_text_printf							    \
	  (GTK_LABEL (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), (n))),  \
	   (f), (a));									    \
      } else {										    \
	gtk_label_set_text								    \
	  (GTK_LABEL (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), (n))),  \
	   NULL);									    \
      }											    \
    } G_STMT_END

    SET ("label-widget-value", "%p", widget);
    SET ("label-name-value",   "%s", gtk_widget_get_name_or_empty (widget));
    SET ("label-gtype-value",  "%s", g_type_name (GTK_OBJECT_TYPE (widget)));

#undef SET
  }

  {
    gtk_widget_set_sensitive (gtk_container_find_descendant_by_name (GTK_CONTAINER (panel),
								     "table"),
			      (widget != NULL) ? TRUE : FALSE);
  }

  {
    gboolean pointing;

    pointing = (gboolean)g_object_get_data (G_OBJECT (element_holder),
					    "pointing");

    if (pointing == TRUE)
      {
	g_inspector_invoke_procedure_by_name ("marching-widget-bbox",
					      widget,
					      NULL);
      }
  }
}

static void
root_pointing_begin (GtkRootPointButton *root_point_button,
		     gpointer            user_data)
{
  GInspectorElementHolder *element_holder;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (user_data);

  {
    g_object_set_data (G_OBJECT (element_holder),
		       "pointing",
		       (gpointer)TRUE);
  }

  {
    g_inspector_invoke_procedure_by_name ("marching-widget-bbox",
					  NULL,
					  NULL);
  }
}

static void
root_pointing_end (GtkRootPointButton *root_point_button,
		   gpointer            user_data)
{
  GInspectorElementHolder *element_holder;

  element_holder = G_INSPECTOR_ELEMENT_HOLDER (user_data);

  {
    g_object_set_data (G_OBJECT (element_holder),
		       "pointing",
		       (gpointer)FALSE);
  }

  {
    g_inspector_invoke_procedure_by_name ("marching-widget-bbox",
					  NULL,
					  NULL);
  }
}

static void
root_pointed (GtkRootPointButton *root_point_button,
              gpointer            user_data)
{
  GtkWidget *widget_at_pointer;

  widget_at_pointer = gtk_get_widget_at_pointer ();

  if ((widget_at_pointer != NULL) && 
      (g_inspector_tag_check_widget (widget_at_pointer) != TRUE))
    {
      g_inspector_invoke_procedure_by_name ("pickup-instance",
					    widget_at_pointer,
					    NULL);
    }
}

static gpointer
create_panel_widget_picker (gpointer data,
			    gpointer func_data,
			    gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *vbox;
  GInspectorElementHolder *element_holder;

  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    top = panel;
  }

  {
    element_holder = g_inspector_element_holder_new ();

    g_object_set_data_full (G_OBJECT (panel),
			    "element-holder",
			    element_holder,
			    g_object_unref);
  }

  {
    GClosure *closure;
    GSource *source;

    closure = g_cclosure_new_object (G_CALLBACK (timeout_handler),
				     G_OBJECT (element_holder));

    source = g_timeout_source_new (250);

    g_source_set_closure (source, closure);
    g_source_attach (source, NULL);
    g_source_unref (source);
  }

  {
    g_signal_connect (element_holder,
		      "changed",
		      G_CALLBACK (element_holder_changed),
		      panel);
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Widget Picker");
    gtk_container_add (GTK_CONTAINER (top), frame);
  }

  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
  }

  {
    GtkWidget *table;

    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    label_list
      = g_list_new (gtk_label_new ("Widget:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-widget-value", NULL),

		    gtk_label_new ("Name:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-name-value", NULL),

		    gtk_label_new ("GType:"),
		    g_object_new (GTK_TYPE_LABEL, "name", "label-gtype-value", NULL),

		    NULL);

      n = g_list_length (label_list);


      table = gtk_table_new (2, n/2, FALSE);
      gtk_widget_set_name (table,
			   "table");
      gtk_widget_set_sensitive (table, FALSE);
      gtk_container_set_border_width (GTK_CONTAINER (table), 4);
      gtk_box_pack_start_defaults (GTK_BOX (vbox), table);


      for (i = 0; i < n; ++i)
	{
	  label = g_list_nth_data (label_list, i);

	  {
	    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	  }

	  {
	    gint left_attach;
	    gint top_attach;

	    left_attach = (i % 2);
	    top_attach  = (i / 2);

	    gtk_table_attach (GTK_TABLE (table),
			      label,
			      (left_attach + 0),
			      (left_attach + 1),
			      (top_attach + 0),
			      (top_attach + 1),
			      GTK_FILL, GTK_FILL,
			      4, 0);
	  }
	}
    }

  {
    GtkWidget *pick_button;

    pick_button = gtk_root_point_button_new_with_label ("Pick");
    gtk_box_pack_start_defaults (GTK_BOX (vbox), pick_button);

    g_signal_connect (pick_button,
		      "pointing_begin",
		      G_CALLBACK (root_pointing_begin),
		      element_holder);
    g_signal_connect (pick_button,
		      "pointing_end",
		      G_CALLBACK (root_pointing_end),
		      element_holder);
    g_signal_connect (pick_button,
		      "pointed",
		      G_CALLBACK (root_pointed),
		      NULL);
  }

  return top;
}
