// $Id: WriterBase.cc,v 1.51 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "WriterBase.hh"

safemap<std::string,const WriterBase *> Writer;

void WriterBase::GHInclude(const Widget &w, CxxFile &f) const
{  // if we see CXX_SEPERATE_CLASS _we_ need it for inheritance
   if (w.getString("cxx_visibility","private")=="private" && CanBeManaged(w)
	&& !w.getBool(CXX_SEPERATE_CLASS))
      return; // only a local ctor variable needed
   f.Include(IncludeName(w));
}

void WriterBase::GCInclude(const Widget &w, CxxFile &f) const
{  if (w.getString("cxx_visibility","private")!="private" || !CanBeManaged(w)
	|| w.getBool(CXX_SEPERATE_CLASS))
      return; // only a local ctor variable needed
   f.Include(IncludeName(w));
}

void WriterBase::GHDeclaration(const Widget &w, CxxFile &f) const 
{  const std::string visibility(w.getString("cxx_visibility","private"));
   if (visibility=="private" && CanBeManaged(w))
      return; // only a local ctor variable needed
   if (visibility=="private") f.Private();
   else if (visibility=="protected") f.Protected();
   else if (visibility=="public") f.Public();
   f.Declaration() << "class " << TypeName(w) << ' ';
   f << '*' << Configuration.InstanceName(w.Name());
   f.EndLine();
}

void WriterBase::Configure(Widget const &, CxxFile &, const std::string &instance) const
{
//#warning WriterBase::Configure
}

void WriterBase::ConstructionArgs(Widget const &w, CxxFile &f) const
{  f.FunctionArg();
}

const WriterBase &LookupWriter(const std::string &type,bool seperate_entity)
{  safemap<std::string,const WriterBase *>::iterator i;
   if (seperate_entity) i=Writer.find("Class");
   else i=Writer.find(type);
   if (i!=Writer.end()) return *(i->second);
   const WriterBase *deflt=Writer[""];
   std::cerr << "glade--: unknown Widget type "<<type << '\n';
   Writer[type]=deflt;
   return *deflt;
}

const WriterBase &LookupWriter(const Widget &w,bool containing)
{  return LookupWriter(Configuration.use_libglade?"LibGlademm":w.Class(),
		containing && w.getBool(CXX_SEPERATE_CLASS));
}

void WriterBase::Derivation(const Widget &w, CxxFile &f) const
{  f.Derivation() << "public " << TypeName(w);
}

void WriterBase::CreatePointer(const Widget &w, CxxFile &f) const
{  if (w.getString("cxx_visibility","private")=="private" && CanBeManaged(w))
     f.Declaration() << TypeName(w) << " *";
   else 
     f.Statement();
   f << Configuration.InstanceName(w.Name());
   f.Assignment();
   if (CanBeManaged(w))
   {  f.FunctionName("manage").FunctionArg();
      w.markManaged();
   }
   f << "new class ";
   f.FunctionName() << TypeName(w);
   ConstructionArgs(w,f);
   f.EndLine();
   CreatePointer_Toplevel(w,f);
}

void WriterBase::DestroyPointer(const Widget &w, CxxFile &f) const
{  DestroyPointer_Toplevel(w,f);
   if (!w.getBool(CXX_IS_MANAGED))
   {  f.Statement() << "delete " << Configuration.InstanceName(w.Name());
      f.EndLine();
   }
}

void WriterBase::ParentConstruction(Widget const &w, CxxFile &f) const
{  f.Constructor() << TypeName(w);
   ConstructionArgs(w,f);
}

void WriterBase::MemberConstruction(Widget const &w, CxxFile &f) const
{  f.Constructor() << Configuration.InstanceName(w.Name());
   ConstructionArgs(w,f);
}

void WriterBase::Destructor(Widget const &w, CxxFile &f) const
{
}

void WriterBase::ApplyPreferences(Tag &t) const
{  bool seperate_file=t.getBool(CXX_SEPERATE_FILE),
   	seperate_class=t.getBool(CXX_SEPERATE_CLASS);
   
   // apply preferences
   if (Configuration.lookup_table_compat)
   {  t.mark("cxx_visibility","public");
      Configuration.lookup_table=true;
   }
   
   Widget w(&t);
   // separate files need separate classes
   if (seperate_file && !seperate_class) 
   {  std::cerr << w.Name() << ": widgets in a separate file need their own class, marked\n";
      t.mark(CXX_SEPERATE_CLASS,"true");
      seperate_class=true;
   }
   
   // do we need a widget map?
   if (!Configuration.lookup_table && t.getString("cxx_visibility","private")=="public")
   {  Configuration.lookup_table=true;
   }
   
   // append a node for marking whether it is managed
   t.mark(CXX_IS_MANAGED,"false");
}

const std::string WriterBase::Instance(const Widget &parent,const Widget &w2, Subwidget sw) const
{  // std::cerr << "Instance " << parent.Name() << ':' << w2.Name() << ',' << sw << '\n';
   if (sw==SW_Unknown) sw=IsSubwidget(parent,w2);
   if (sw==is_Subwidget_only || sw==is_Subwidget_all || sw==is_Subwidget)
   {  std::string ii(InternalInstance(parent,w2));
      // std::cerr << "II("<<TypeName(parent) <<") = "<< ii <<'\n';
      if (ii.size())
         return Instance(parent,parent,not_Subwidget)+ii;
      else return "";
   }
   std::string ret(Configuration.InstanceName(w2.Name()));
   ret+="->";
   return ret;
}

const std::string WriterBase::GtkName(const Widget &w) const
{  const std::string prefix(GtkPrefix());
   const std::string Typename(TypeName(w));
   int pre_len(prefix.size());
   if (!strncmp(prefix.c_str(),Typename.c_str(),pre_len))
   {  std::string ret(Typename,pre_len,Typename.size()-pre_len);
      return "Gtk"+ret;
   }
   else
   {  std::cerr << "don't know how to convert " << Typename << " to a corresponding gtk+ type\n";
      return "GtkWidget";
   }
}

const std::string WriterBase::GtkCast(const Widget &w) const
{  const std::string gtktype(GtkName(w));
   std::string ret;
   for (std::string::const_iterator i(gtktype.begin());i!=gtktype.end();++i)
   {  if (isupper(*i))
      {  if (ret.size()) ret=ret+'_'+*i;
         else ret+=*i;
      }
      else ret+=toupper(*i);
   }
   return ret;
}

void WriterBase::ClassConstructor(const Widget &w, CxxFile &f) const
{  if (w.getString("cxx_visibility","private")=="private" && CanBeManaged(w))
     f.Declaration() << TypeName(w) << " *";
   else
     f.Statement();
   f << Configuration.InstanceName(w.Name());
   f.Assignment() << "this";
}

void WriterBase::AdditionalMemberVars(const Widget &w, CxxFile &f,bool container) const
{  if (container) GHDeclaration(w,f);
}

const std::string WriterBase::Reference(const std::string &instance)
{  // this is not bullet proof but should work well enough for internal widgets
   assert (instance.size()>2 && *(instance.end()-1)=='>' && *(instance.end()-2)=='-');
   return "*"+std::string(instance.begin(),instance.end()-2);
}

// returns true if matching
bool WriterBase::isInternalMethod(const std::string &prefix, const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const int plen(prefix.size());
   if (!strncmp(prefix.c_str(),method.c_str(),plen))
      method=std::string(method.c_str()+plen);
   
   std::string rettype("void");
   const std::string sargs(SignalHandlerArgs(w,method,rettype));
   // I don't know whether this is a signal ...
   if (!args.size() && !sargs.size() && true) return false;
// parse words and match them ...
   return false;
}
