// $Id: fileselection.cc,v 1.5 2002/02/15 16:23:32 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "window.hh"

class Gtk_FileSelection : public Gtk_Window
{public:
	typedef Gtk_Window Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_FileSelection();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{ // return false; 
	  return true;
	}
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  // f.FunctionArg(); 
         if(w.hasTag("title"))
	  f.FunctionArg() << Configuration.Translatable(w.getString("title"));
	 else
	  f.FunctionArg() << "File Selection";
	}
	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_FileSelection Gtk_FileSelection;

const std::string Gtk_FileSelection::TypeName(const Widget &w) const
{  return GtkPrefix()+"FileSelection";
}

const std::string Gtk_FileSelection::IncludeName(const Widget &w) const
{  return "gtk--/fileselection.h";
}

Gtk_FileSelection::Gtk_FileSelection()
{  Writer["GtkFileSelection"]=this;
}

Subwidget Gtk_FileSelection::IsSubwidget(const Widget &w,const Widget &ch) const
{  const std::string chn(ch.ChildName());
   if (chn=="FileSel:cancel_button" || chn=="FileSel:ok_button") 
   	return is_Subwidget_all;
   if (chn!="") {  std::cerr << "FileSelection: Unexpected child name '" << chn << "'\n"; }
   return not_Subwidget;
}

const std::string Gtk_FileSelection::InternalInstance(const Widget &parent,const Widget &w2) const
{  const std::string chn(w2.ChildName());
   if (chn=="FileSel:ok_button") return "get_ok_button()->";
   if (chn=="FileSel:cancel_button") return "get_cancel_button()->";
   return Parent::InternalInstance(parent,w2);
}

void Gtk_FileSelection::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   bool show_file_op_buttons=w.getBool("show_file_op_buttons",true);
   if (!show_file_op_buttons)
      f.Statement() << instance << "hide_fileop_buttons()";
}
