// $Id: gnome_appbar.cc,v 1.2 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

class Gnome_AppBar : public Gtk_HBox
{public:
	typedef Gtk_HBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_AppBar();
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return true; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
};

static Gnome_AppBar Gnome_AppBar;

void Gnome_AppBar::ConstructionArgs(Widget const &w, CxxFile &f) const
{  bool has_progress(w.getBool("has_progress"));
   bool has_status(w.getBool("has_status"));
   std::string interactivity(w.getString("interactivity","GNOME_PREFERENCES_NEVER"));
#warning is interactivity the correct name?   
   f.FunctionArg() << PRINT_BOOL(has_progress) << ", " 
   	<< PRINT_BOOL(has_status) << ", " << interactivity;
}

const std::string Gnome_AppBar::TypeName(const Widget &w) const
{  return GnomePrefix()+"AppBar";
}

const std::string Gnome_AppBar::IncludeName(const Widget &w) const
{  return "gnome--/appbar.h";
}

Gnome_AppBar::Gnome_AppBar()
{  Writer["GnomeAppBar"]=this;
}

void Gnome_AppBar::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   // set_status
   // set_default
#warning some configurations missing
}

#warning signals (clear_prompt(), user_response()) missing
