// $Id: menuitem.hh,v 1.16 2004/07/16 13:35:54 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1999  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "item.hh"

class Gtk_MenuItem : public Gtk_Item
{public:
	typedef Gtk_Item Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_MenuItem(bool base_class_init=true);
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void AddChild(const Widget &w,CxxFile &f,const std::string &instance) const;
        virtual void CreatePointer(const Widget &w,CxxFile &f) const;
        virtual const std::string SignalHandlerArgs(const Widget &w,const std::string &signal,std::string &rettype,std::string &scope) const;
        
        // functions specific to menuitems:
        virtual void MenuElemCreation(const Widget &w, CxxFile &f) const;
        virtual std::string MenuElemName(const Widget &w) const;
        virtual void MenuElemArgs(const Widget &w, CxxFile &f) const;
        virtual void MenuElemArgs0(const Widget &w, CxxFile &f) const;
        virtual void MenuElemArgsSub(const Widget &w, CxxFile &f) const;
        static std::string MenuElemPrefix()
        {  return "Gtk::Menu_Helpers::";
        }
};
