/*  Glimmer - gnomeasciilist.h
 *
 *  This library is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <stdio.h>

#ifndef _GNOME_ASCII_LIST_H_
#define _GNOME_ASCII_LIST_H_
#ifdef __cplusplus
extern "C" {
#endif

#define GNOME_TYPE_ASCII_LIST (gnome_ascii_list_get_type())
#define GNOME_ASCII_LIST(obj) (GTK_CHECK_CAST ((obj), GNOME_TYPE_ASCII_LIST, GnomeAsciiList))
#define GNOME_ASCII_LIST_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_ASCII_LIST, GnomeAsciiListClass))
#define GNOME_IS_ASCII_LIST(obj) (GTK_CHECK_TYPE((obj), GNOME_TYPE_ASCII_LIST))
#define GNOME_IS_ASCII_LIST_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_ASCII_LIST))

typedef struct _GnomeAsciiList GnomeAsciiList;
typedef struct _GnomeAsciiListClass GnomeAsciiListClass;

struct _GnomeAsciiList {
    GtkWindow window;
    GtkWidget *chars;
    GtkWidget *vbox;
    GtkWidget *entry;
    GtkWidget *insert_button;
    GtkWidget *close_button;
    gint selected_row;
};

struct _GnomeAsciiListClass {
    GtkWindowClass parent_class;
};

GtkType gnome_ascii_list_get_type(void);
GtkWidget *gnome_ascii_list_new(void);
/* Must Free this baby */
gchar *gnome_ascii_list_get_selection(GnomeAsciiList *ascii);

#ifdef __cplusplus /* cpp compatibility */
}
#endif
#endif
