<?php
/*
 * @version $Id: document.class.php 3843 2006-08-30 14:06:13Z moyo $
 -------------------------------------------------------------------------
 GLPI - Gestionnaire Libre de Parc Informatique
 Copyright (C) 2003-2006 by the INDEPNET Development Team.

 http://indepnet.net/   http://glpi-project.org
 -------------------------------------------------------------------------

 LICENSE

 This file is part of GLPI.

 GLPI is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 GLPI is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GLPI; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 --------------------------------------------------------------------------
 */

// ----------------------------------------------------------------------
// Original Author of file: Julien Dombre
// Purpose of file:
// ----------------------------------------------------------------------




class Document extends CommonDBTM {

	function Document () {
		$this->table="glpi_docs";
		$this->type=DOCUMENT_TYPE;
	}
	function getFromDBbyFilename($filename){
		global $db;
		$query="SELECT ID FROM glpi_docs WHERE filename='$filename'";
		$result=$db->query($query);
		if ($db->numrows($result)==1){
			return $this->getFromDB($db->result($result,0,0));
		} 
		return false;
	}	

	function cleanDBonPurge($ID) {
		global $db,$cfg_glpi,$phproot,$lang;

		$query3 = "DELETE FROM glpi_doc_device WHERE (FK_doc = '$ID')";
		$result3 = $db->query($query3);

		// UNLINK DU FICHIER
		if (!empty($this->fields["filename"]))
			if(is_file($cfg_glpi["doc_dir"]."/".$this->fields["filename"])&& !is_dir($cfg_glpi["doc_dir"]."/".$this->fields["filename"])) {
				if (unlink($cfg_glpi["doc_dir"]."/".$this->fields["filename"]))
					$_SESSION["MESSAGE_AFTER_REDIRECT"]= $lang["document"][24].$cfg_glpi["doc_dir"]."/".$this->fields["filename"]."<br>";
				else $_SESSION["MESSAGE_AFTER_REDIRECT"]= $lang["document"][25].$cfg_glpi["doc_dir"]."/".$this->fields["filename"]."<br>";
			}
	}

	function defineOnglets($withtemplate){
		global $lang;
		$ong[5]=$lang["title"][26];
		if (haveRight("notes","r"))
			$ong[10]=$lang["title"][37];
		return $ong;
	}

	function prepareInputForAdd($input) {
		global $lang;
		$input["date_mod"] = date("Y-m-d H:i:s");
		$input["FK_users"] = $_SESSION["glpiID"];

		if (isset($_FILES['filename']['type'])&&!empty($_FILES['filename']['type']))
			$input['mime']=$_FILES['filename']['type'];

		if (isset($input["item"])&&isset($input["type"])&&$input["type"]>0&&$input["item"]>0){
			$ci=new CommonItem();
			$ci->getFromDB($input["type"],$input["item"]);
			$input["name"]=substr($lang["document"][18]." ".$ci->getType()." - ".$ci->getNameID(),0,255);
		}

		if (isset($input["upload_file"])&&!empty($input["upload_file"])){
			$input['filename']=moveUploadedDocument($input["upload_file"]);
		} else 	$input['filename']= uploadDocument($_FILES['filename']);

		unset($input["upload_file"]);
		if (!isset($input["_only_if_upload_succeed"])||!$input["_only_if_upload_succeed"]||!empty($input['filename'])) {
			return $input;
		}
		else {
			return false;
		}
	}

	function postAddItem($newID,$input) {
		global $lang;
		if (isset($input["item"])&&isset($input["type"])&&$input["item"]>0&&$input["type"]>0){
			$template=0;
			if (isset($_POST["is_template"])) $template=1;

			addDeviceDocument($newID,$input['type'],$input['item'],$template);
			logEvent($newID, "documents", 4, "document", $_SESSION["glpiname"]." ".$lang["log"][32]);
		}


	}


	function prepareInputForUpdate($input) {
		$input["date_mod"] = date("Y-m-d H:i:s");
		if (isset($_FILES['filename']['type'])&&!empty($_FILES['filename']['type']))
			$input['mime']=$_FILES['filename']['type'];

		if (isset($input['current_filename']))
		if (isset($input["upload_file"])&&!empty($input["upload_file"])){
			$input['filename']=moveUploadedDocument($input["upload_file"],$input['current_filename']);
		} else 	$input['filename']= uploadDocument($_FILES['filename'],$input['current_filename']);

		if (empty($input['filename'])) unset($input['filename']);
		unset($input['current_filename']);	

		return $input;
	}


	function title(){

		global  $lang,$HTMLRel;

		echo "<div align='center'><table border='0'><tr><td>";
		echo "<img src=\"".$HTMLRel."pics/docs.png\" alt='".$lang["document"][13]."' title='".$lang["document"][13]."'></td>";
		if (haveRight("document","w")){
			echo "<td><a  class='icon_consol' href=\"document.form.php\"><b>".$lang["document"][13]."</b></a></td>";
		} else echo "<td><span class='icon_sous_nav'><b>".$lang["Menu"][27]."</b></span></td>";
		echo "</tr></table></div>";
	}

	function showForm ($target,$ID) {
		global $cfg_glpi,$lang,$HTMLRel;

		if (!haveRight("document","r"))	return false;


		$spotted=false;
		if (!$ID) {

			if($this->getEmpty()) $spotted = true;
		} else {
			if($this->getfromDB($ID)) $spotted = true;
		}

		if ($spotted){
			echo "<form name='form' method='post' action=\"$target\" enctype=\"multipart/form-data\"><div align='center'>";
			echo "<table class='tab_cadre_fixe'>";
			echo "<tr><th colspan='3'><b>";
			if (!$ID) {
				echo $lang["document"][16].":";
			} else {
				echo $lang["document"][18]." ID $ID:";
			}		
			echo "</b></th></tr>";

			echo "<tr class='tab_bg_1'><td>".$lang["common"][16].":		</td>";
			echo "<td colspan='2'>";
			autocompletionTextField("name","glpi_docs","name",$this->fields["name"],25);
			echo "</td></tr>";

			if (!empty($ID)){
				echo "<tr class='tab_bg_1'><td>".$lang["document"][22].":		</td>";
				echo "<td colspan='2'>".getDocumentLink($this->fields["filename"])."";
				echo "<input type='hidden' name='current_filename' value='".$this->fields["filename"]."'>";
				echo "</td></tr>";
			}
			$max_size=return_bytes_from_ini_vars(ini_get("upload_max_filesize"));
			$max_size/=1024*1024;
			$max_size=round($max_size,1);

			echo "<tr class='tab_bg_1'><td>".$lang["document"][2]." (".$max_size." Mb max):	</td>";
			echo "<td colspan='2'><input type='file' name='filename' value=\"".$this->fields["filename"]."\" size='25'></td>";
			echo "</tr>";

			echo "<tr class='tab_bg_1'><td>".$lang["document"][36].":		</td>";
			echo "<td colspan='2'>";
			showUploadedFilesDropdown("upload_file");
			echo "</td></tr>";


			echo "<tr class='tab_bg_1'><td>".$lang["document"][33].":		</td>";
			echo "<td colspan='2'>";
			autocompletionTextField("link","glpi_docs","link",$this->fields["link"],40);
			echo "</td></tr>";


			echo "<tr class='tab_bg_1'><td>".$lang["document"][3].":		</td>";
			echo "<td colspan='2'>";
			dropdownValue("glpi_dropdown_rubdocs","rubrique",$this->fields["rubrique"]);
			echo "</td></tr>";



			echo "<tr class='tab_bg_1'><td>".$lang["document"][4].":		</td>";
			echo "<td colspan='2'>";
			autocompletionTextField("mime","glpi_docs","mime",$this->fields["mime"],25);
			echo "</td></tr>";

			echo "<tr>";
			echo "<td class='tab_bg_1' valign='top'>";

			// table commentaires
			echo $lang["common"][25].":	</td>";
			echo "<td align='center' colspan='2'  class='tab_bg_1'><textarea cols='35' rows='4' name='comment' >".$this->fields["comment"]."</textarea>";

			echo "</td>";
			echo "</tr>";

			if (!$ID) {

				echo "<tr>";
				echo "<td class='tab_bg_2' valign='top' colspan='3'>";
				echo "<div align='center'><input type='submit' name='add' value=\"".$lang["buttons"][8]."\" class='submit'></div>";
				echo "</td>";
				echo "</tr>";

				echo "</table></div></form>";

			} else {

				echo "<tr>";
				echo "<td class='tab_bg_2'>";
				if ($this->fields["FK_users"]>0)
					echo $lang["document"][42]." ".getUserName($this->fields["FK_users"],1);
				else echo "&nbsp;";
				echo "</td>";
				echo "<td class='tab_bg_2' valign='top'>";
				echo "<input type='hidden' name='ID' value=\"$ID\">\n";
				echo "<div align='center'><input type='submit' name='update' value=\"".$lang["buttons"][7]."\" class='submit'></div>";
				echo "</td>\n\n";

				echo "<td class='tab_bg_2' valign='top'>\n";
				echo "<input type='hidden' name='ID' value=\"$ID\">\n";
				if ($this->fields["deleted"]=='N')
					echo "<div align='center'><input type='submit' name='delete' value=\"".$lang["buttons"][6]."\" class='submit'></div>";
				else {
					echo "<div align='center'><input type='submit' name='restore' value=\"".$lang["buttons"][21]."\" class='submit'>";

					echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type='submit' name='purge' value=\"".$lang["buttons"][22]."\" class='submit'></div>";
				}

				echo "</td>";
				echo "</tr>";

				echo "</table></div>";
				echo "</form>";


			}
		} else {
			echo "<div align='center'><b>".$lang["document"][23]."</b></div>";
			return false;

		}

		return true;

	}

}

?>
