#ifdef GLURP_DEBUG
#define debug(str, ARGS...)	debug_real(__FILE__, __LINE__, __FUNCTION__, str, ##ARGS)
#else
#define debug(str, ARGS...)
#endif

void debug_real(const char *file, const int line, const char *function, const char *msg, ...);

void statusbar_print(const char *string, ...);
gboolean statusbar_reset();
gchar *status_string();

void title_print(GtkWidget *window, const char *string, ...);

GlurpSong *get_nth_song_from_playlist(gint pos);
gchar *strip_dirs(gchar *path);
gchar *glade_path();

void gui_add_append(gchar *path, GtkTreePath *iter, gboolean song);

gchar *glurp_filename(gchar *path);

GlurpSong *get_song_by_pos(gint pos);
GlurpSong *get_song_by_id(gint id);
gint get_song_pos(GlurpSong *song);
gint get_num_songs();

void update_song(mpd_Song *song);
void add_song(mpd_Song *song);

void debug_print_playlist();

GlurpStream *get_stream_history(gchar *urls);
void print_stream_history();
gchar *dump_stream_history();
void push_stream(gchar *url);

/* convenience macros */
#define NONBLOCKING_UPDATE_CAPABLE_MPD	((glurp->conn->version[0] > 0 || \
					 glurp->conn->version[1] >= 11) ? TRUE : FALSE)

#define STREAM_CAPABLE_MPD	((glurp->conn->version[0] > 0 || \
				 glurp->conn->version[1] >= 11) ? TRUE : FALSE)

#define OUTPUTS_CAPABLE_MPD	((glurp->conn->version[0] > 0 || \
				 glurp->conn->version[1] >= 12) ? TRUE : FALSE)
