/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 */

#include <config.h>

#include <iostream>

#include <assert.h>

#include "GdomeSmartDOMDOMString.hh"
#include "GdomeSmartDOMDOMStringAux.hh"

namespace GdomeSmartDOM {

std::ostream&
operator<<(std::ostream& o, const DOMString& str)
{
  if (str.isNull()) o << "(null)";
  else {
    for (unsigned i = 0; i < str.length(); i++) {
      Char16 ch = str.at(i);
      if (ch < 0x7f) o.put(ch);
      else {
	o << "\\u";
	wchar_t       save_fill  = o.fill('0');
#if defined(HAVE_IOS_CLASS)
	ios::fmtflags save_flags = o.setf(ios::hex, ios::basefield);
#else
	std::ios_base::fmtflags save_flags = o.setf(std::ios_base::hex, std::ios_base::basefield);
#endif
	int           save_width = o.width(4);
	o << ch;
	o.fill(save_fill);
	o.setf(save_flags);
	o.width(save_width);
      }
    }
  }

  return o;
}

}

namespace std {

// FIXME: I has to split the declaration line into two lines
// because otherwise sed will substitute just one of the namespaces.
// Any hint?

size_t
hash<GdomeSmartDOM::DOMString>::operator()(
  const GdomeSmartDOM::DOMString& key) const
{
  size_t res = 0;

  for (unsigned i = 0; i < key.length(); i++)
    res = (res << 1) ^ key.at(i);

  return res;
}

}

