/* This file is part of GMetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://gmetadom.sourceforge.net
 * or send an email to <luca.padovani@cs.unibo.it>
 */

#include <config.h>

#include <gdome.h>
#include <assert.h>
#include <string.h>

#include "GdomeSmartDOMChar.hh"
#include "GdomeSmartDOMDOMString.hh"
#include "GdomeSmartDOMGdomeStringAux.hh"

namespace GdomeSmartDOM {

GdomeDOMString*
GdomeDOMString_of_DOMString(const DOMString& s)
{
  if (s.isNull()) return 0;
  else return gdome_str_mkref_own(s.toC());
}

DOMString
DOMString_of_GdomeDOMString(const GdomeDOMString* s)
{
  DOMString res;
  
  if (s != 0) {
    assert(s->str != 0);
    res.fromUTF8(reinterpret_cast<Char8*>(s->str), strlen(s->str));
  }

  return res;
}

}

