// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include <stdio.h>

#include "SampleShell.h"

#ifdef USE_X

SampleShell::SampleShell(QWidget *w) : QWidget(w, "sampleShell")
{
  setMinimumSize(70, 40);
  setCaption("Xgmod Samples");

  sampleList = new QListBox(this, "sampleList");
  sampleList->setGeometry(5, 5, 200, 160);
  
  closeButton = new QPushButton(this, "closeButton");
  closeButton->setText("Close");
  closeButton->setGeometry(75, 200, 60, 25);
  connect(closeButton, SIGNAL(clicked()), this, SLOT(closeSampleShell()));

  resize(210, 200);
}

void
SampleShell::showSampleShell()
{
  show();
}

void
SampleShell::closeSampleShell()
{
  close();
}

void
SampleShell::resizeEvent(QResizeEvent *)
{
  closeButton->move((width() - 60) / 2, height() - 30);
  sampleList->resize(width() - 10, height() - 40);
}

void
SampleShell::setSamples(Sample **samples, int nrSamples)
{
  int i;
  char sampleName[SAMPNAME_LEN + 6];

  sampleList->setAutoUpdate(FALSE);
  sampleList->clear();

  for (i = 0; i < nrSamples; i++)
    {
      if (samples[i]->ok())
	sprintf(sampleName, "[%03d] ", i);
      else
	strcpy(sampleName, "[xxx] ");

      strcat(sampleName, samples[i]->name());
      sampleList->insertItem(sampleName);
    }

  sampleList->repaint();
  sampleList->setAutoUpdate(TRUE);
}

#ifndef DEPEND
#include "SampleShell.moc"
#endif

#else /* !USE_X */

#ifndef USE_NCURSES

SampleShell::SampleShell(int background, int showEmpty)
  : background_(background), showEmpty_(showEmpty)
{
}

#else

SampleShell::SampleShell(int background)
  : background_(background), sampleWin_(0)
{
}

#endif

void
SampleShell::setSamples(Sample **samples, int nrSamples)
{
  if (!background_)
    {
      int i;

#ifdef USE_NCURSES
      if (sampleWin_)
	delwin(sampleWin_);

      sampleWin_ = newpad(nrSamples, COLS);
      scrollok(sampleWin_, FALSE);
      sampleLines_ = LINES - 6;
      
  //    if (sampleLines_ > nrSamples)
  //	sampleLines_ = nrSamples;

      for (i = 0; i < nrSamples; i++)
	samples[i]->printInfo(sampleWin_, i);

      nrSamples_ = nrSamples;
      firstVisible_ = 0;

      prefresh(sampleWin_, 0, 0, 4, 0, 4 + sampleLines_ - 1, COLS - 1);
#else
      for (i = 0; i < nrSamples; i++)
	samples[i]->printInfo(i, showEmpty_);
#endif  
    }
}

#ifdef USE_NCURSES

void
SampleShell::scrollSamples(int direction)
{
  if (direction > 0)
    {
      if (firstVisible_ < (nrSamples_ - sampleLines_))
	firstVisible_++;
    }
  else
    {
      if (firstVisible_ > 0)
	  firstVisible_--;
    }

  prefresh(sampleWin_, firstVisible_, 0, 4, 0, 4 + sampleLines_ - 1, COLS - 1);
}

#endif

#endif
