/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "toolbar.h"

#include "config.h"
#include "window.h"
#include "dopen.h"
#include "world.h"
#include "notebook.h"
#include "dproperties.h"
#include "dpreferences.h"
#include "userlist.h"
#include "dsend.h"
#include "dtriggers.h"

GtkWidget *toolbar;
GtkWidget *toolbar_handle;
GtkWidget *disconnect_button;
GtkWidget *disconnect_button_on;
GtkWidget *disconnect_button_off;
GtkWidget *disconnect_button_ing;
GtkWidget *close_button;
GtkWidget *properties_button;
GtkWidget *send_button;
GtkWidget *userlist_button;
GtkWidget *userlist_button_on;
GtkWidget *userlist_button_off;

void gm_toolbar_update_visibility() {
    if(settings->toolbar) {
        gtk_widget_show(toolbar_handle);
    } else {
        gtk_widget_hide(toolbar_handle);
    }
}

void discon_but_cb(GtkWidget *discon) {
    world *w = gm_notebook_current_world();

    if(gm_world_is_connected(w)) {
        gm_world_try_disconnect(w);
    } else if(gm_world_is_connecting(w)) {
        gm_world_disconnect(w);
    } else {
        gm_world_connect(w);
    }
}

GtkWidget *new_toolbar_button(char *xpm_file[], char *tooltip_text,
			      GtkSignalFunc callback, void *data) {
    GdkPixmap *icon;
    GdkBitmap  *mask;
    GtkWidget *icon_widget;

    icon = gdk_pixmap_create_from_xpm_d(gm_window_get_GdkWindow(), &mask,
					gm_window_get_background_color(),
					xpm_file);
    icon_widget = gtk_pixmap_new(icon, mask);
    return gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL,
				   tooltip_text, "Private", icon_widget,
				   callback, data);
}


GtkWidget *gm_toolbar_create() {
    GtkWidget *hbox;
    GdkPixmap *icon;
    GdkBitmap *mask;
#include "pix/new.xpm"    
#include "pix/open.xpm"    
#include "pix/exit.xpm"
#include "pix/connect_on.xpm"
#include "pix/connecting.xpm"
#include "pix/connect_off.xpm"
#include "pix/close.xpm"
#include "pix/properties.xpm"
#include "pix/preferences.xpm"
#ifdef __TRIGGERS__
#   include "pix/triggers.xpm"
#endif
#include "pix/send.xpm"
#include "pix/userlist_on.xpm"
#include "pix/userlist_off.xpm"

    toolbar_handle = gtk_handle_box_new();
    gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(toolbar_handle),
                                       GTK_POS_LEFT);
    gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(toolbar_handle), GTK_POS_TOP);

    gtk_widget_show(toolbar_handle);
    
    toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
    gtk_container_add(GTK_CONTAINER(toolbar_handle), toolbar);
    gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
    gtk_container_set_border_width(GTK_CONTAINER(toolbar), 4);
    gtk_toolbar_set_space_style(GTK_TOOLBAR(toolbar), GTK_TOOLBAR_SPACE_LINE);

    gtk_widget_show(toolbar);

    new_toolbar_button(new_xpm, "Create a new world",
                       GTK_SIGNAL_FUNC(gm_dialog_properties_open_new), NULL);
    new_toolbar_button(open_xpm, "Open a world",
                       GTK_SIGNAL_FUNC(gm_dialog_open_open), NULL);
    new_toolbar_button(exit_xpm, "Exit gmoo",
                       GTK_SIGNAL_FUNC(gm_window_close), NULL);
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    new_toolbar_button(preferences_xpm, "Open global preferences dialog",
                       GTK_SIGNAL_FUNC(gm_dialog_preferences_open), NULL);
#ifdef __TRIGGERS__
    new_toolbar_button(triggers_xpm,
		       "Open the highlites and "
		       "triggers dialog",
		       GTK_SIGNAL_FUNC(gm_dialog_triggers_open), NULL);
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
#endif

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);
    icon = gdk_pixmap_create_from_xpm_d(gm_window_get_GdkWindow(), &mask,
                                        gm_window_get_background_color(),
                                        connect_on_xpm);
    disconnect_button_on = gtk_pixmap_new(icon, mask);
    gtk_box_pack_start(GTK_BOX(hbox), disconnect_button_on, FALSE, FALSE, 0);
    icon = gdk_pixmap_create_from_xpm_d(gm_window_get_GdkWindow(), &mask,
                                        gm_window_get_background_color(),
                                        connect_off_xpm);
    disconnect_button_off = gtk_pixmap_new(icon, mask);
    gtk_widget_show(disconnect_button_off);
    gtk_box_pack_start(GTK_BOX(hbox), disconnect_button_off, FALSE, FALSE, 0);
    icon = gdk_pixmap_create_from_xpm_d(gm_window_get_GdkWindow(), &mask,
                                        gm_window_get_background_color(),
                                        connecting_xpm);
    disconnect_button_ing = gtk_pixmap_new(icon, mask);
    gtk_box_pack_start(GTK_BOX(hbox), disconnect_button_ing, FALSE, FALSE, 0);
    disconnect_button = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL,
                                                "Connect or disconnect", 
                                                "Private", hbox,
                                                GTK_SIGNAL_FUNC(discon_but_cb),
                                                NULL);

    close_button = 
        new_toolbar_button(close_xpm, "Close",
                           GTK_SIGNAL_FUNC(gm_notebook_close_current_tab),
                           NULL);
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    properties_button = 
        new_toolbar_button(properties_xpm, 
                           "Open world properties dialog",
                           GTK_SIGNAL_FUNC(
                               gm_dialog_properties_open_current_world),
                           NULL);
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
    send_button =
        new_toolbar_button(send_xpm, 
                           "Show `Send text to world' dialog",
                           GTK_SIGNAL_FUNC(gm_dialog_send_open_current_world), 
                           (void *) "Send");
    gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_widget_show(hbox);
    icon = gdk_pixmap_create_from_xpm_d(gm_window_get_GdkWindow(), &mask,
                                        gm_window_get_background_color(),
                                        userlist_on_xpm);
    userlist_button_on = gtk_pixmap_new(icon, mask);
    gtk_box_pack_start(GTK_BOX(hbox), userlist_button_on, FALSE, FALSE, 0);
    icon = gdk_pixmap_create_from_xpm_d(gm_window_get_GdkWindow(), &mask,
                                        gm_window_get_background_color(),
                                        userlist_off_xpm);
    userlist_button_off = gtk_pixmap_new(icon, mask);
    gtk_box_pack_start(GTK_BOX(hbox), userlist_button_off, FALSE, FALSE, 0);
    gtk_widget_show(userlist_button_off);
    userlist_button = 
        gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), NULL,
                                "Toggle the userlist", 
                                "Private", hbox,
                                GTK_SIGNAL_FUNC(gm_userlist_toggle),
                                NULL);

    gtk_widget_set_sensitive(disconnect_button, FALSE);
    gtk_widget_set_sensitive(close_button, FALSE);
    gtk_widget_set_sensitive(properties_button, FALSE);
    gtk_widget_set_sensitive(send_button, FALSE);
    gtk_widget_set_sensitive(userlist_button, FALSE);

    return toolbar_handle;
}

void gm_toolbar_world_connected(world *w) {
    if(w == gm_notebook_current_world()) {
        gtk_widget_hide(disconnect_button_off);
        gtk_widget_hide(disconnect_button_ing);
        gtk_widget_show(disconnect_button_on);
    }
}

void gm_toolbar_world_connecting(world *w) {
    if(w == gm_notebook_current_world()) {
        gtk_widget_hide(disconnect_button_off);
        gtk_widget_hide(disconnect_button_on);
        gtk_widget_show(disconnect_button_ing);
    }
}

void gm_toolbar_world_disconnected(world *w) {
    if(w == gm_notebook_current_world()) {
        gtk_widget_hide(disconnect_button_on);
        gtk_widget_hide(disconnect_button_ing);
        gtk_widget_show(disconnect_button_off);
    }
}

void gm_toolbar_userlist_on(world *w) {
    if(w == gm_notebook_current_world()) {
        gtk_widget_hide(userlist_button_off);
        gtk_widget_show(userlist_button_on);
    }
}

void gm_toolbar_userlist_off(world *w) {
    if(w == gm_notebook_current_world()) {
        gtk_widget_hide(userlist_button_on);
        gtk_widget_show(userlist_button_off);
    }
}

void gm_toolbar_switched_to(int type) {
    world *w;
    gtk_widget_set_sensitive(disconnect_button, type == TK_WORLD);
    gtk_widget_set_sensitive(close_button,
                             type == TK_WORLD
#ifdef ZVT
                             || type == TK_RUN
#endif
                             );
    gtk_widget_set_sensitive(properties_button, type == TK_WORLD);
    gtk_widget_set_sensitive(send_button,       type == TK_WORLD);
    gtk_widget_set_sensitive(userlist_button,   type == TK_WORLD);

    if(type == TK_WORLD) {
        w = gm_notebook_current_world();
        if(gm_world_is_connected(w))
            gm_toolbar_world_connected(w);
        else if(gm_world_is_connecting(w))
            gm_toolbar_world_connecting(w);
        else
            gm_toolbar_world_disconnected(w);

        if(GTK_WIDGET_VISIBLE(w->userlist_clist))
            gm_toolbar_userlist_on(w);
        else
            gm_toolbar_userlist_off(w);
        gtk_widget_set_sensitive(userlist_button, (w->userlist != NULL));
    }
}
