/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "DigitChooser.h"
#include "config.h"
#include "gettext.h"

DigitChooser::DigitChooser (Gtk::Window &parent, MultPuzzle &puzzle, char letter)
	: Gtk::Dialog ("", parent, true, false)
{
	Gtk::Table *t = manage (new Gtk::Table (2, 5, TRUE));
	Gtk::VBox *v = get_vbox ();
	Gtk::Label *l;
	bool *digits = puzzle.getUnknownDigits ();
	bool *guessed = puzzle.getLetterGuesses (letter);
	char *text;
	
	for (int i = 0; i < 10; i++)
	{
		bool possible = !guessed[i] && digits[i];
		DigitBox *b;
		
		b = manage (new DigitBox (i + 48, this));
		
		t->attach (*b, i % 5, (i % 5) + 1, i / 5, (i / 5) + 1);
		
		if (!possible)
		{
			b->set_sensitive (false);
		}
	}
	
	// make room for string and char
	text = (char *) malloc (strlen (_("Guess which digit is represented by %c.\n")) + 2);
	sprintf (text, _("Guess which digit is represented by %c.\n"), letter);
	
	l = manage (new Gtk::Label (text));
	free (text);
	
	v->add (*l);
	v->add (*t);
	add_button ("gtk-cancel", 0);
	
	t->set_spacings (6);
	v->set_border_width (12);
	
	free (guessed);
	free (digits);
	
	v->show_all ();
	
	//set_title ("");
	//set_transient_for (parent);
	// why is this non-existant?
//	set_destroy_with_parent (true);
	//set_modal (true);
//	set_position (Gtk::WIN_POS_CENTER_ON_PARENT);
}

DigitChooser::~DigitChooser (void)
{
}

DigitChooser::DigitBox::DigitBox (char digit, DigitChooser *d)
	: Gtk::Button (), dc (d), character (digit)
{
	Glib::ustring s = "_";
	
	s += digit;
	
	set_label (s);
	set_use_underline (true);
}

void DigitChooser::DigitBox::on_clicked (void)
{
	dc->response (character);
}

