/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GTK_MULT_TABLE_H__
#define __GTK_MULT_TABLE_H__

#include <gtkmm.h>
#include "MultPuzzle.h"
#include "CharBox.h"

class GtkMultTable
	: public Gtk::Table
{
	public:
	
	GtkMultTable (MultPuzzle *p);
	~GtkMultTable (void);
	
	void restart (MultPuzzle *p);
	
	protected:
	
	MultPuzzle *puzzle;
	
	bool boxReleased (GdkEventButton *e);
	void addString (const char *str, int row, int offset);
	void redraw (void);
	
	class TableBox
		: public CharBox
	{
		public:
		
		TableBox (char c, MultPuzzle *p);
		
		protected:
		
		virtual bool on_button_release_event (GdkEventButton *e);
		
		private:
		
		MultPuzzle *puzzle;
		char character;
	};
};

#endif /* __GTK_MULT_TABLE_H__ */
