#include <gnome.h>
#include "gnap.h"
#include "interface.h"
#include "napster.h"
#include "gtkutil.h"
#include "callbacks.h"

extern GList *sr_list;
extern int napster_socket;
extern main_window *the_window;
extern GtkWidget *download_window;
extern GtkWidget *properties_window;

static GnomeUIInfo popup_menu[] = {
  GNOMEUIINFO_MENU_NEW_ITEM(N_("Download"), N_("Start downloading"), download_cb, NULL),
  GNOMEUIINFO_MENU_NEW_ITEM(N_("Put in Queue"), N_("Add file to download queue"), add_queue_cb, NULL),
  GNOMEUIINFO_END
};

void download_cb (GtkMenuItem * menuitem, gpointer user_data)
{ 
 GList *i;
 search_result *data;

 i = (GList*)sr_list;

 do {
  data = (search_result*)i->data;
  if(data->selected) 
   nap_send_download_request(napster_socket,data->user,data->filename,data->id);
 } while((i = i->next));

}

void add_queue_cb (GtkMenuItem * menuitem, gpointer user_data)
{

}

void exit_cb (GtkMenuItem * menuitem, gpointer user_data)
{
 close(napster_socket);
 gtk_main_quit();
}

void search_cb (GtkWidget *entry, gpointer user_data)
{
 gchar *search_text;

 gtk_editable_select_region(GTK_EDITABLE(entry),0,-1);

 search_text = gtk_editable_get_chars(GTK_EDITABLE(entry),0,-1);
 nap_send_search(search_text,napster_socket); 
 gnome_entry_save_history (GNOME_ENTRY(the_window->search_entry));
}

void properties_apply_cb (GtkWidget *propertybox,gint page_number,GtkWidget *property_box)
{
 GtkWidget *entry_username; 
 GtkWidget *entry_password; 
 GtkWidget *entry_email; 
 GtkWidget *entry_download; 
 GtkWidget *entry_upload; 
 GtkWidget *combo; 
 gchar *string;

 entry_username = gtk_object_get_data(GTK_OBJECT(property_box),"entry_username");
 entry_password = gtk_object_get_data(GTK_OBJECT(property_box),"entry_password");
 entry_email = gtk_object_get_data(GTK_OBJECT(property_box),"entry_email");
 entry_download = gtk_object_get_data(GTK_OBJECT(property_box),"entry_download");
 entry_upload = gtk_object_get_data(GTK_OBJECT(property_box),"entry_upload");
 combo = gtk_object_get_data(GTK_OBJECT(property_box),"combo");

 gnome_config_set_string("/gnap/General/username",gtk_entry_get_text(GTK_ENTRY(entry_username)));
 gnome_config_set_string("/gnap/General/password",gtk_entry_get_text(GTK_ENTRY(entry_password)));
 gnome_config_set_string("/gnap/General/email",gtk_entry_get_text(GTK_ENTRY(entry_email)));
 gnome_config_set_string("/gnap/General/upload_dir",gtk_entry_get_text(GTK_ENTRY(entry_upload)));
 gnome_config_set_string("/gnap/General/download_dir",gtk_entry_get_text(GTK_ENTRY(entry_download)));
 string = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry)); 
 gnome_config_set_int("/gnap/General/connection",gnap_connection_to_int(string));

 gnome_config_sync();
}

void preferences_cb (GtkMenuItem * menuitem, gpointer user_data)
{
 gtk_widget_show_all(GTK_WIDGET(properties_window));
}

// Edit Menu stuff

void menu_clear_all_cb (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_clist_clear(GTK_CLIST(the_window->clist));

  // must free up all the sr_list items.
  do {
   g_free(sr_list->data);
  } while ((sr_list = sr_list->next)); 

  // just incase.
  sr_list = NULL;
}

void menu_select_all_cb (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_clist_select_all(GTK_CLIST(the_window->clist)); 
}

void menu_unselect_all_cb (GtkMenuItem * menuitem, gpointer user_data)
{
  gtk_clist_unselect_all(GTK_CLIST(the_window->clist)); 
}

void menu_crop_cb (GtkMenuItem * menuitem, gpointer user_data)
{
  GList *i,*j; 
  search_result *data;
  gint row = 0;

  i = sr_list;

  gtk_clist_freeze(GTK_CLIST(the_window->clist));
  for(row=0;i;row++) {
   data = (search_result*)i->data;
   if(!data->selected) {
     j = i;
     i = i->next;
     gtk_clist_remove(GTK_CLIST(the_window->clist),row);
     sr_list = g_list_remove_link(sr_list,j); 
     g_free(data);
   } else {
     i = i->next;
   }
  }
  gtk_clist_thaw(GTK_CLIST(the_window->clist));
}

void menu_delete_cb (GtkMenuItem * menuitem, gpointer user_data)
{
  GList *i,*j; 
  search_result *data;
  gint row = 0;

  i = sr_list;

  gtk_clist_freeze(GTK_CLIST(the_window->clist));
  for(row=0;i;row++) {
   data = (search_result*)i->data;
   if(data->selected) {
     j = i;
     i = i->next;
     gtk_clist_remove(GTK_CLIST(the_window->clist),row);
     sr_list = g_list_remove_link(sr_list,j); 
     g_free(data);
   } else {
     i = i->next;
   }
 }
 gtk_clist_thaw(GTK_CLIST(the_window->clist));
}

void
about_cb (GtkMenuItem * menuitem, gpointer user_data)
{
 GtkWidget *about_window; 
 about_window = create_about_window();
 gtk_widget_show(about_window);
}

void properties_changed_cb (GtkWidget *widget, GtkWidget *property_box) 
{
 gnome_property_box_set_state(GNOME_PROPERTY_BOX(property_box),1); 
}


void select_row_cb (GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
 GList *i = NULL;
 search_result *data;

 i = g_list_nth(sr_list,row);
 data = (search_result*)i->data;
 data->selected = 1;
}

void unselect_row_cb (GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer user_data)
{
 GList *i = NULL;
 search_result *data;

 i = g_list_nth(sr_list,row);
 data = (search_result*)i->data;
 data->selected = 0;
}

void select_all_cb (GtkCList *clist, gpointer user_data)
{
 GList *i = NULL;
 search_result *data;

 i = sr_list;
 
 do {
  data = (search_result*)i->data;
  data->selected = 1;
 } while((i = i->next));

}

void unselect_all_cb (GtkCList *clist, gpointer user_data)
{
 GList *i = NULL;
 search_result *data;

 i = sr_list;
 
 do {
  data = (search_result*)i->data;
  data->selected = 0;
 } while((i = i->next));
}

void download_window_cb (GtkMenuItem * menuitem, gpointer user_data)
{
 gtk_widget_show_all(download_window);
}

void queue_window_cb (GtkMenuItem * menuitem, gpointer user_data)
{
}

void motd_window_cb (GtkMenuItem * menuitem, gpointer user_data)
{
}

// i ripped most this off from gmenu
void main_popup_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
 GtkWidget *menu;
 gint row = -1;
 gint col;

 if(event->button == 3) {
  gtk_clist_get_selection_info (GTK_CLIST(widget), event->x, event->y, &row, &col);
  menu = gnome_popup_menu_new (popup_menu); 
  gnome_popup_menu_do_popup_modal (menu, NULL, NULL, event, NULL);
  gtk_widget_destroy (menu);
 }
}

void download_button_cb(GnomeDialog *dialog, gint button, gpointer clist)
{
 gint row;
 transfer *data;
	
 switch(button) {
  case 0:	row = gtkutil_clist_selection(clist);
		if(row != -1) {
		 data = gtk_clist_get_row_data(GTK_CLIST(clist),row);     
	         gnap_download_end(data);
		} 
		break;
  default:	break;
 }
}
