#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>

#include "gnapster.h"
#include "upload.h"
#include "commands.h"
#include "download.h"
#include "queue.h"

#include "chan.h"

extern ListChanDlg list_chan_dlg;
extern PropDlg prop_dlg;
extern UserInfo user_info;
extern GnapsterMain *gmain;

void real_query(STab *stab, int switchto, char *user) {
   if (user_lookup(stab, user) != -1)
     hook_text_insert(stab, CURR, SYSTEM_N, "general_error", 
		      "you are already talking to %s", user);
   else {
      append_console_tab(stab, user, 1);
	 
      if (switchto)
	gtk_notebook_set_page(GTK_NOTEBOOK(stab->ct->notebook),
			      user_lookup(stab, user) - 1);
   }
}

void set_total_users(ChannelInfo *ch) {
   char *buf;
   int i;
   
   i = g_list_length(GTK_CLIST(ch->clist)->row_list);
   
   d_msprintf(&buf, "Users: %i", i);
   gtk_label_set_text(GTK_LABEL(ch->label), buf);
   d_free(buf);
}

void hide_topic_cb(GtkWidget *w, gpointer data) {
   GtkWidget *hbox;
   
   d_assert(data != NULL);
   
   hbox = data;
   
   if (GTK_WIDGET_VISIBLE(hbox))
     gtk_widget_hide(hbox);
   else
     gtk_widget_show(hbox);
}

void hide_list_cb(GtkWidget *w, gpointer data) {
   GtkWidget *vbox;
   
   vbox = data;
   if (!vbox)
     return;
   
   if (GTK_WIDGET_VISIBLE(vbox)) {
      gtk_widget_hide(vbox);
      gtk_label_set_text(GTK_LABEL(GTK_BIN(w)->child), "<");
   } else {
      gtk_widget_show(vbox);
      gtk_label_set_text(GTK_LABEL(GTK_BIN(w)->child), ">");
   }
}

GList *nick_completion_fill_nicks(STab *stab, GCompletion *comp, GtkCList *clist) {
   User *dptr;
   GList *nick_list = NULL, *ptr;
   
   for(ptr=clist->row_list; ptr; ptr=ptr->next) {
      dptr = GTK_CLIST_ROW(ptr)->data;
      if (!dptr)
	break;
      
      if (dptr->user && strcmp(dptr->user, stab->ci->account->user))
	nick_list = g_list_append(nick_list, d_strdup(all_lower(dptr->user)));
   }
   
   g_completion_add_items(comp, nick_list);
   
   return nick_list;
}

void nick_list_free(GList *list) {
   GList *ptr;
   
   for(ptr=list; ptr; ptr=ptr->next)
     d_free(ptr->data);
}

char *nick_comp_func(void *data) {
   GtkCListRow *row;
   User *nuser;
   
   row = data;
   nuser = row->data;
   
   return all_lower(nuser->user);
}

char *nick_completion(char *ptr, STab *stab, GtkCList *clist) {
   GList *nicks;
   char *nick, *cnick, *text, *new_buf;
   
   if (!ptr || !clist)
     return NULL;
   
   new_buf = d_strdup(ptr);
   
   if (!strchr(ptr, ':'))
     return new_buf;
   
   nick = d_strdup(all_lower(next_arg_full(ptr, &ptr, ':')));
   text = ptr;
   
   /* Not the first word */
   if (!nick)
     return new_buf;
   
   if (strchr(nick, ' ') || strlen(nick) <= 1) {
      d_free(nick);
      
      return new_buf;
   }
   
   nicks = j_comp_items(stab, clist);
   cnick = j_complete(nicks, NULL, nick);
   
   if (!cnick) {
      j_complete_free();
      
      return new_buf;
   }
   
   /* completion succeeded, create a new buffer to hold the new string */
   d_strexp(&new_buf, "%s:%s", cnick, text);
   
   j_complete_free();
   
   return new_buf;
}

void autojoin_handle(STab *stab) {
   FILE *f;
   char *chan, *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   
   if (stab->ct->channel_list)
     return;
   
   f = open_autojoin("r");
   if (!f)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   if (felem)
     hook_text_insert(stab, CONSOLE, SYSTEM, "general_message", "%s",
		      "auto-joining channels");

   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      chan = next_arg(dptr, &dptr);
      if (!chan)
	continue;
      
      napster_send(stab->ci->sock, NAPSTER_JOIN_CHAN, chan);
   }
   
   read_file_free(felem);
}

FILE *open_autojoin(char *flags) {
   FILE *f;
   char *conf;
   
   conf = local_path("autojoin", NULL);
   
   f = fopen(conf, flags);
   
   if (!f)
     j_error("fopen", conf, NULL);
   
   d_free(conf);
   
   return f;
}

void append_autojoin_entry(char *chan) {
   FILE *f;
   char *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   
   if (!chan)
     return;
   
   f = open_autojoin("r");
   if (f) {
      felem = read_file(f);

      fclose(f);

      for(ptr=felem; ptr; ptr=ptr->next) {
	 fent = ptr->data;
	 if (!fent)
	   continue;
	 
	 dptr = fent->lptr;

	 if (!strncmp(dptr, chan, strlen(chan))) {
	    d_free(dptr);
	    break;
	 }
      }
      
      read_file_free(felem);
   }
   
   f = open_autojoin("a");
   if (!f)
     return;

   fprintf(f, "%s\n", chan);
   
   fclose(f);
}

void remove_autojoin_entry(char *chan) {
   FILE *f;
   char *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   
   if (!chan)
     return;
   
   f = open_autojoin("r");
   if (!f)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   f = open_autojoin("w");
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      if (strncmp(dptr, chan, strlen(chan)))
	fprintf(f, "%s", dptr);
   }
   
   read_file_free(felem);
   
   fclose(f);
}

void autojoin_add() {
   char *chan;
   
   chan = gtk_entry_get_text(GTK_ENTRY(prop_dlg.aj_entry));
   if (!strlen(chan))
     return;
   
   append_autojoin_entry(chan);
   
   gtk_entry_set_text(GTK_ENTRY(prop_dlg.aj_entry), "");
   
   populate_autojoin_clist();
}

void autojoin_remove() {
   char *chan;
   int row = -1;
   
   gnapster_get_selection_data(prop_dlg.aj_clist, &row);
   if (row == -1)
     return;
   
   gtk_clist_get_text(GTK_CLIST(prop_dlg.aj_clist), row, 0, &chan);
   
   remove_autojoin_entry(chan);
   
   populate_autojoin_clist();
}

void populate_autojoin_clist() {
   FILE *f;
   char *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   
   if (!prop_dlg.aj_clist)
     return;
   
   f = open_autojoin("r");
   if (!f)
     return;

   if (prop_dlg.aj_clist) {
      gtk_clist_freeze(GTK_CLIST(prop_dlg.aj_clist));
      gtk_clist_clear(GTK_CLIST(prop_dlg.aj_clist));
   }
   
   felem = read_file(f);
   
   fclose(f);
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      gnapster_clist_append(prop_dlg.aj_clist, NULL, NULL, dptr, NULL);
   }

   read_file_free(felem);
   
   gtk_clist_thaw(GTK_CLIST(prop_dlg.aj_clist));
}

void list_chan_dlg_clist_cb(GtkWidget *widget, GdkEventButton *event, gpointer data) {
   int row = -1, col;
   
   gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y,
				&row, &col);
   
   if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
     list_chan_dlg_cb(NULL, "join");
}

void list_chan_dlg_cb(GtkWidget *w, void *data) {
   STab *stab;
   
   if (!data)
     return;
   
   stab = get_current_stab();
   
   if (!strcmp(data, "join")) {
      Channel *nchan;
      
      nchan = gnapster_get_selection_data(list_chan_dlg.clist, NULL);
      if (!nchan)
	return;
      
      napster_send(stab->ci->sock, NAPSTER_JOIN_CHAN, nchan->chan);
   }

   j_dialog_close(list_chan_dlg.window);
}

void list_chan_cb(GtkWidget *w, gpointer data) {
   STab *stab;
   
   stab = get_current_stab();
   
   if (!connected(stab->ci) || connecting(stab->ci))
     return;
   
   if (dialog_open(list_chan_dlg.window))
     return;
   
   create_list_chan_dlg();
   
   gtk_clist_freeze(GTK_CLIST(list_chan_dlg.clist));
   
   napster_send(stab->ci->sock, NAPSTER_CHAN_LIST, NULL);
}

void join_chan_cb(GtkWidget *w, gpointer data) {
   STab *stab;
   
   stab = get_current_stab();
   
/*   gtk_notebook_set_page(GTK_NOTEBOOK(stab->notebook), 0);*/
   gtk_notebook_set_page(GTK_NOTEBOOK(gmain->srv_notebook), stab->pn + 4);
   gtk_entry_set_text(GTK_ENTRY(stab->ct->entry), "/join");
   gtk_widget_grab_focus(stab->ct->entry);
}

void part_chan_cb(GtkWidget *w, gpointer data) {
   STab *stab;
   
   stab = get_current_stab();
   
   if (!remove_console_tab(stab, NULL, 0))
     j_error_dialog("You must click on a channel tab before attempting to remove it");
}

void channel_list_clear(STab *stab) {
   GList *ptr;
   ChannelInfo *chinfo;
   
   for(ptr=stab->ct->channel_list; ptr; ptr=ptr->next) {
      chinfo = ptr->data;
      if (!chinfo)
	continue;
      
      if (chinfo->clist)
	gtk_clist_clear(GTK_CLIST(chinfo->clist));
      
      /* if we remove the 1st one everytime, we will get
       * rid of everything except Messages */
      gtk_notebook_remove_page(GTK_NOTEBOOK(stab->ct->notebook),
			       1);
      
      d_free(chinfo->channel_name);
      d_free(chinfo);
   }
   
   g_list_free(stab->ct->channel_list);
   stab->ct->channel_list = NULL;
}

int chan_lookup(STab *stab, char *chan) {
   GList *ptr;
   int i = 0;
   
   for(ptr=stab->ct->channel_list; ptr; ptr=ptr->next) {
      if (!g_strcasecmp(((ChannelInfo *)ptr->data)->channel_name, chan) &&
	  !((ChannelInfo *)ptr->data)->user)
	return (i + 2);
      
      i++;
   }
   
   return -1;
}

ChannelInfo *chan_lookup_data(STab *stab, char *chan) {
   GList *iter_ptr;
   ChannelInfo *ch;
   
   ITER_LIST(stab->ct->channel_list) {
      LIST_DATA(ch);
      
      if (!j_strcasecmp(ch->channel_name, chan) &&
	  !ch->user)
	return ch;
   }
   
   return NULL;
}

GtkCList *chan_lookup_clist(STab *stab, char *chan) {
   GList *ptr;
   
   for(ptr=stab->ct->channel_list; ptr; ptr=ptr->next) {
      if (!g_strcasecmp(((ChannelInfo *)ptr->data)->channel_name, chan) &&
	  !((ChannelInfo *)ptr->data)->user)
	return GTK_CLIST(((ChannelInfo *)ptr->data)->clist);
   }
   
   return NULL;
}

char *chan_lookup_chan(STab *stab, int index) {
   ChannelInfo *chan;
   
   chan = g_list_nth_data(stab->ct->channel_list, index);
   if (!chan)
     return NULL;
   
   if (!chan->user)
     return chan->channel_name;
   
   return NULL;
}

char *get_current_chan() {
   int page_num;
   STab *stab;
   
   stab = get_current_stab();
   
   page_num = gnapster_get_pagenum(stab);
   if (page_num <= 1)
     return NULL;
   
   return chan_lookup_chan(stab, page_num - 2);
}
