#ifndef __NAPSTER_H
#define __NAPSTER_H

#include <stdio.h>
#include <glib.h>

/* NEW SYSTEM */

enum nap_Commands {
	CMDR_ERROR		= 0,
	CMDS_UNKNOWN		= 1,
	CMDS_LOGIN		= 2, /* user pass dataport "version" speed */
	CMDR_EMAILADDR		= 3, /* email address */
	CMDR_BASTARD		= 4, /* unknown */
	CMDS_REGISTERINFO	= 6, /* userinfo */
	CMDS_CREATEUSER		= 7, /* create user account */
	CMDR_CREATED		= 8, /* account created */
	CMDR_CREATEERROR	= 9, /* username taken */
	CMDR_ILLEGALNICK	= 10, /* illegal nickname specified */
	
	CMDR_LOGINERROR		= 13, 

	CMDS_OPTIONS		= 14, /* NAME:%s ADDRESS:%s CITY:%s STATE:%s PHONE:%s AGE:%s INCOME:%s EDUCATION:%s   *login options */

	CMDR_MSTAT		= 15, 
	CMDR_REQUESTUSERSPEED	= 89,
	CMDR_SENDFILE		= 95,
	CMDS_ADDFILE		= 100,

	CMDS_REMOVEFILE		= 102, /* "\path\to\filename\" for removal */

	CMDR_GETQUEUE		= 108,

	CMDR_MOTD		= 109,
	CMDS_REMOVEALLFILES	= 110, /* remove all shared files */
	CMDR_ANOTHERUSER	= 148,
	CMDS_SEARCH		= 200,
	CMDR_SEARCHRESULTS	= 201,
	CMDR_SEARCHRESULTSEND	= 202,

	/* if dataport is 0 we use 500 to request a transfer. 0 is a firewalled host */
	CMDS_REQUESTFILE	= 203,
	CMDR_FILEREADY		= 204,

	CMDS_SENDMSG		= 205,
	CMDR_GETERROR		= 206,

	CMDS_ADDHOTLIST		= 207,

	CMDS_ADDHOTLISTSEQ	= 208,
	CMDR_HOTLISTONLINE	= 209,
	CMDR_USEROFFLINE	= 210, 

	CMDS_BROWSE		= 211,
	CMDR_BROWSERESULT	= 212,
	CMDR_BROWSEENDRESULT	= 213,
	CMDR_STATS		= 214,

	CMDS_REQUESTRESUME	= 215, /* checksum filesize */
	CMDR_RESUMESUCCESS	= 216, /* nick ip port filename checksum size connection */
	CMDR_RESUMEEND		= 217, /* end resume for checksum filesize */

	CMDS_UPDATE_GET1	= 218, /* add 1 to download */
	CMDS_UPDATE_GET		= 219, /* sub 1 from download */
	CMDS_UPDATE_SEND1	= 220, /* add 1 for send */
    	CMDS_UPDATE_SEND	= 221, /* sub 1 from send */

	CMDS_TESTPORT		= 300, /* portnum */

	CMDR_HOTLISTSUCCESS	= 301,
	CMDR_HOTLISTERROR	= 302, /* not on hotlist */
	CMDS_HOTLISTREMOVE	= 303, /* nick */
	
        CMDS_IGNORELIST         = 320,
        CMDS_IGNOREENTRY        = 321, /* user */
        CMDS_IGNOREADD          = 322, /* user */
        CMDS_IGNOREREMOVE       = 323, /* user */

	CMDS_BLOCKLIST		= 330, /* none */
     
	CMDS_BLOCK		= 332, /* ip [reason] */
	CMDS_UNBLOCK		= 333, /* ip */	


	CMDS_JOIN		= 400,
	CMDS_PART		= 401,
	CMDS_SEND		= 402,
	CMDR_PUBLIC		= 403,
	CMDR_ERRORMSG		= 404,
	CMDR_JOIN		= 405,
	CMDR_JOINNEW		= 406,
	CMDR_PARTED		= 407,
	CMDR_NAMES		= 408,
	CMDR_ENDNAMES		= 409,
	CMDS_TOPIC		= 410, /* got/change topic */

	CMDS_CBANLIST		= 420, /* <channel> */
	CMDR_CBANLIST		= 421, /* <nick> <who> "<reason>" <time> */
	CMDS_CBAN		= 422, /* <channel> <nick> [reason] */
	CMDS_CUNBAN		= 423, /* <channel> <nick> [reason] */
	CMDS_CBANCLEAR		= 424, /* <channel> */
		
	CMDS_REQUESTFILEFIRE	= 500,
	CMDR_FILEINFOFIRE	= 501, /* if firewalled then expect a 501 request send */

	CMDS_REQUESTLINESPEED	= 600,
	CMDR_LINESPEED		= 601,

	CMDS_REQUESTSIZE	= 602,
	CMDS_WHOIS		= 603,
	CMDR_WHOIS		= 604,
	CMDR_WHOWAS		= 605,
	CMDS_SETUSERLEVEL	= 606, /* moderators/administrators/elite */
	CMDR_FILEREQUEST	= 607, /* nick \"filename\" */
	CMDS_FILEINFO		= 608, /* nick \"filename\" */
	CMDR_ACCEPTERROR	= 609, /* accept failed on request */

	CMDS_KILLUSER		= 610, /* return 404 permission denied */
	CMDS_NUKEUSER		= 611, /* return 404 */
	CMDS_BANUSER		= 612,
	CMDR_SETDATAPORT	= 613, 
	CMDS_UNBANUSER		= 614,
	CMDS_BANLIST		= 615,
	CMDR_BANLIST_IP		= 616,
	CMDS_LISTCHANNELS	= 617,
	CMDR_LISTCHANNELS	= 618,

	CMDS_SENDLIMIT		= 619, /* nick "filename" queuelimit */
	CMDR_SENDLIMIT		= 620, /* nick "filename" filesize queuelimit */

	CMDR_MOTDS		= 621, 
	CMDS_MUZZLE		= 622,
	CMDS_UNMUZZLE		= 623,
	CMDS_UNNUKEUSER		= 624, /* return 404 */
	CMDS_SETLINESPEED	= 625,
	CMDR_DATAPORTERROR	= 626,
	CMDS_OPSAY		= 627,
	CMDR_ANNOUNCE		= 628,
	CMDR_BANLIST_NICK	= 629,
	CMDS_CLOAK		= 652, /* toggle moderator cloaking */
		
	CMDS_CHANGESPEED	= 700,
	CMDS_CHANGEPASS		= 701,
	CMDS_CHANGEEMAIL	= 702,
	CMDS_CHANGEDATA		= 703,

	CMDS_SPING		= 750, /* guessing at this one. returns 750*/
	CMDS_PING		= 751, /* user */
	CMDS_PONG		= 752, /* <user> recieved from a ping*/
			       /* <user> can also be used to send a pong */
	CMDS_SETPASSWORD	= 753, /* <user> <password> [reason] */
		
	CMDS_RELOADCONFIG	= 800, /* <config variable> */
	CMDS_SERVERVERSION	= 801, /* none */
	/* 805 missing */
	CMDS_SETCONFIG		= 810, /* <config string */
	/* 811 */
	CMDS_CLEARCHANNEL	= 820,  /* channelname */
	/* 821 822 */
	CMDR_CLIENTREDIR	= 821, /* client redirect <nick> <host> <port>*/
	CMDR_CYCLE		= 822, /* client cycle <nick> <host> */
	CMDS_SETCHANLEVEL	= 823, /* set channel level <channel> <level> */
	CMDS_SENDME		= 824, /* text */
	CMDR_NICK		= 825,
	CMDS_SETCHANNELLIMIT	= 826, /* <channel> <limit> default 200 */
	CMDS_SHOWALLCHANNELS	= 827, /* shows all channels */
			       /* <channel> <users> <?> <?> <limit> "Topic" */
	CMDR_ALLCHANNELS	= 828, /* <channelname> end of list is empty 827 */

	CMDS_KICK		= 829, /* channel nick [reason] */
	CMDS_NAME		= 830, /* <channel> returns 825 with nick info, 830 is recieved on end of list */
	CMDS_SHOWUSERS		= 831, /* end global list of users */
	CMDS_SHOWUSERSLIST	= 832, /* global list of users */
	CMDS_SHAREPATH		= 870, /* share path of files */
	
	/* the following are open-nap specific */
	CMDS_SERVERLINK		= 10100, /* link server  <server> <port> [<remote server>] */
	CMDS_SERVERUNLINK	= 10101, /* unlink server <server> <reason> */
	CMDS_SERVERKILL		= 10110, /* kill server <server> <reason> */
	CMDS_SERVERREMOVE	= 10111, /* remove it <server> <reason> */
	CMDS_SERVERLINKS	= 10112, /* links command */ 
	CMDS_SERVERUSAGE	= 10115, /* usage of server */
	CMDS_SERVERPING		= 10116, /* <server> [args] */
	CMDS_SERVERREHASH	= 10117, /* rehash all variables/motd */
	
	CMDS_ADMINREGISTER	= 10200, /* admin register nick <nick> <pass> <email> [<level>] */
/*	CMDS_SETCHANLEVEL	= 10201,  set channel level <channel> <level> */
	CMDS_KICKUSER		= 10202, /* <channel> <nick> <reason> */
	CMDS_CREATEOP		= 10204, /* <channel> <user> [user ...] */
	CMDS_DELETEOP		= 10205, /* <channel> <user> [user ...] */
	CMDS_LISTOPS		= 10206, /* <channel> */
	CMDS_DROPCHANNEL	= 10207, /* <channel> ["reason"] */
	CMDS_OPWALL		= 10208, /* <channel> <text> */
	CMDS_CHANNELMODE	= 10209, /* <channel> [<+MODERATED> <+PRIVATE>] */
	CMDS_CHANNELINVITE	= 10210, /* <channel> <nick> */

	CMDS_CHANNELVOICE	= 10211, /* <channel> <nick> ... */
	CMDS_CHANNELUNVOICE	= 10212, /* <channel> <nick> ... */
	CMDS_CHANNELMUZZLE	= 10213, /* <channel> <nick> ... */
	CMDS_CHANNELUNMUZZLE	= 10214, /* <channel> <nick> ... */

	CMDS_ADDMIMEFILE	= 10300, /* add a mime file type */
	CMDS_NEW_BROWSE		= 10301, /* */
	CMDR_NEW_BROWSE		= 10302  /* */
};



/* OLD SYSTEM */

#define NAPSTER_ERROR 0

#define NAPSTER_LOGIN 2
#define NAPSTER_LOGIN_ACK 3

#define NAPSTER_NEW_USER_LOGIN 6
#define NAPSTER_NEW_USER 7
#define NAPSTER_NEWUSER_SUCCESS 8
#define NAPSTER_NEWUSER_REG 9
#define NAPSTER_NEWUSER_INVALID_NICK 10

#define NAPSTER_SUBMIT 100
#define NAPSTER_REMOVE_SHARE 102

#define NAPSTER_SEARCH 200
#define NAPSTER_SEARCH_RESULT 201
#define NAPSTER_END_SEARCH 202

#define NAPSTER_GET 203
#define NAPSTER_DOWNLOAD_REPLY 204

#define NAPSTER_USER_MESSAGE 205

#define NAPSTER_DOWNLOAD_ERROR 206

#define NAPSTER_BROWSE_ERROR 210
#define NAPSTER_BROWSE 211
#define NAPSTER_BROWSE_RESULT 212
#define NAPSTER_END_BROWSE 213

#define NAPSTER_STATUS_MESSAGE 214

#define NAPSTER_RESUME_SEARCH 215
#define NAPSTER_RESUME_RESULT 216
#define NAPSTER_RESUME_END 217

#define NAPSTER_DOWNLOAD_START 218
#define NAPSTER_DOWNLOAD_COMPLETE 219
#define NAPSTER_UPLOAD_START 220
#define NAPSTER_UPLOAD_COMPLETE 221

#define NAPSTER_JOIN_CHAN 400
#define NAPSTER_PART_CHAN 401
#define NAPSTER_CHAN_MESSAGE 402
#define NAPSTER_CHAN_MESSAGE_IN 403

#define NAPSTER_SERVER_MESSAGE 404

#define NAPSTER_CHAN_JOIN 405
#define NAPSTER_CHAN_JOINUSER 406
#define NAPSTER_CHAN_PARTUSER 407
#define NAPSTER_CHAN_USERLIST 408
#define NAPSTER_CHAN_USERLIST_END 409
#define NAPSTER_CHAN_TOPIC 410

#define NAPSTER_CBAN_LIST 420
#define NAPSTER_CBAN_LIST_ENTRY 421
#define NAPSTER_CBAN 422
#define NAPSTER_CUNBAN 423
#define NAPSTER_CBAN_CLEAR 424

#define NAPSTER_ALT_GET 500
#define NAPSTER_ALT_DOWNLOAD_REPLY 501 

#define NAPSTER_WHOIS_REQUEST 603
#define NAPSTER_WHOIS_REPLY 604
#define NAPSTER_WHOIS_OFFLINE 605

#define NAPSTER_CHANGE_USERLEVEL 606

#define NAPSTER_UPLOAD_REQUEST 607
#define NAPSTER_ACCEPT_UPLOAD_REQUEST 608

#define NAPSTER_KILL_USER 610
#define NAPSTER_NUKE_USER 611

#define NAPSTER_BAN_USER 612
#define NAPSTER_UNBAN_USER 614

#define NAPSTER_BAN_LIST 615
#define NAPSTER_BAN_LIST_ENTRY 616

#define NAPSTER_REQUEST_PORTCHANGE 613

#define NAPSTER_CHAN_LIST 617
#define NAPSTER_CHAN_LIST_ENTRY 618

#define NAPSTER_SENDLIMIT 619
#define NAPSTER_SENDLIMIT_REACHED 620

#define NAPSTER_MESSAGE 621
#define NAPSTER_MUZZLE_USER 622
#define NAPSTER_UNMUZZLE_USER 623

#define NAPSTER_SET_LINESPEED 625

#define NAPSTER_PORT_ERROR 626

#define NAPSTER_ADMIN_MESSAGE 627
#define NAPSTER_GLOBAL_MESSAGE 628

#define NAPSTER_PTP_BROWSE 640
#define NAPSTER_PTP_BROWSE_ACCEPT 641
#define NAPSTER_PTP_BROWSE_ERROR 642

#define NAPSTER_CHANGE_PORT 703

#define NAPSTER_PING 751
#define NAPSTER_PONG 752

#define NAPSTER_SERVER_VERSION 801

#define NAPSTER_ACTION 824

#define NAPSTER_ChannelInfoLIMIT 826

#define NAPSTER_KICK 829

#define NAPSTER_SUBMIT_DIRECTORY 870

#define NAPSTER_LOGIN_SEQUENCE 920

/* Non-standard opennap commands */

#define NAPSTER_LINKS 10112

#define NAPSTER_SERVER_STATS 10115

#define NAPSTER_ChannelInfo_LEVEL 10201

#define NAPSTER_SET_USER_MODE 10203
#define NAPSTER_SET_ChannelInfo_OP 10204
#define NAPSTER_REMOVE_ChannelInfo_OP 10205

#define NAPSTER_ChannelInfo_OP_LIST 10206

#define NAPSTER_ChannelInfo_MODE 10209

#define NAPSTER_OPENNAP_BROWSE 211
#define NAPSTER_OPENNAP_BROWSE_RESULT 10302

struct _Transfer {
   int type;
   
   char *trunc_file;
   char *file;
   char *user;
   
   int connection;
   unsigned short port;
   unsigned long int ip;
   
   int sock;
   int sock_input;
   
   int update_tag;
   
   int accept_timeout;
   int start_timeout;
   
   FILE *fdesc;
   
   char *fpath;
   
   char *header;
   
   unsigned long size, temp_size;
   unsigned long total;
   
   time_t start;
   
   int calls;
   int timeout_calls;
   
   struct timeval ptime;		/* time it took to read one packet */
   float kps;				/* kps for that packet */   

   guint8 status;
   int timeout_tag;
   
   int ttype;
   int conn_type;
   
   char *id;
   int num;
   int kbps;
   int freq;
   char *resume_path;
   
   STab *st;
};

struct _Server {
   int type;
   
   char *ip;
   int port;
   char *desc;
   char *network;
   unsigned long users;
   unsigned long files;
   unsigned long gigs;
};

struct _File {
   int type;
   
   time_t mtime;
   char *filename;
};

struct _User {
   int type;
   
   char *user;
   int shares;
   int conn;
};

struct _Channel {
   int type;
   
   char *chan;
   int users;
   char *topic;
};

struct _Resume {
   int type;
   
   char *file;
   char *checksum;
   int localsize;
   int remotesize;
};

/* prototypes */
int napster_send(int sock, int cmd, char *fmt, ...);
void napster_send_get(int sock, char *user, char *file, unsigned long int size);
void napster_send_send(int sock, char *user, char *file, unsigned long int size);
int opennap_version(STab *stab, int major, int minor);
int is_opennap_server(STab *stab, char *data);
int user_ignored(char *user);
void napster_show_links(STab *stab);
GtkCTreeNode *napster_find_link(STab *stab, GtkCTreeNode *node, char *s);
void napster_handle_data(STab *stab, int c, char *data);
void napster_get_best_host(STab *stab, char *ip, unsigned short port);
void napster_connect(STab *stab, char *ip, int port);
void napster_connect_user(Transfer *t);
void napster_unbind();
void napster_bind(unsigned short port);
void handle_rebind(int nport);
int napster_conn_as_int(char *s);
char *napster_conn_as_str(int i);
int napster_user_uploads(STab *stab, char *user);
/* !prototypes */

#endif /* __NAPSTER_H */
