/* ping.c - ... */
/* this is not complete and thus, not used */

#include "gnapster.h"

#include <sys/time.h>

void ping_finish(void *data) {
   Connection *c;
   
   d_assert(data != NULL);
   
   c = data;
   
   INPUT_REMOVE(c->tag);
   
   pclose(c->data);
}

void read_ping(void *data, int source, GdkInputCondition cond) {
   char *ptr, buf[2048], *line = NULL;
   int n;
   
   n = read(source, buf, sizeof(buf) - 1);
   if (n <= 0) {
      perror("read");
      ping_finish(data);
      return;
   }
   
   buf[n] = 0;
   
   for(ptr=buf; *ptr; ptr++) {
      if (*ptr == '\n') {
	 *line = 0;
	 
      }
   }
}

void read_ping_nb(void *data, int source, GdkInputCondition cond) {
   NBRead *nb;
   int n;
   
   nb = nb_active(source + 1);

   n = nb_read(nb, source, 0, '\n');
   if (n <= 0) {
      perror("recv");
      ping_finish(data);
      nb_finish(nb);
      return;
   }
   
   if (!nb->term)
     return;
   
   printf("...: %s\n", nb->data);
}

void start_ping(unsigned long iplong) {
   char *ip;
   Connection *c;
   struct in_addr in;
   char *cmd;
   FILE *p;
   
   in.s_addr = iplong;
   
   ip = inet_ntoa(in);
   if (!ip) {
      perror("inet_ntoa");
      return;
   }
   
   d_msprintf(&cmd, "/bin/ping -c 1 \"%s\"", ip);
   printf("opening %s\n", cmd);
   p = popen(cmd, "r");
   d_free(cmd);
   
   if (!p) {
      perror("popen");
      return;
   }
   
   c = d_new(CONNECTION);

   c->data = p;
   
   c->tag = INPUT_ADD(fileno(p), GDK_INPUT_READ, read_ping, c);
}

/*#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#define DEFDATALEN (64 - ICMP_MINLEN)

static guint8 outpack[IP_MAXPACKET];
static int datalen = DEFDATALEN;

#define OUTPACK_ICMP ((struct icmp *)outpack)
#define OUTPACK_PAYLOAD (OUTPACK_ICMP->icmp_data)
#define OUTPACK_TIME ((struct timeval *)OUTPACK_PAYLOAD)

int input;

void read_ping(void *data, int source, GdkInputCondition cond) {
   struct timeval *t, e;
   
   d_assert(data != NULL);
   
   t = data;
   
   gettimeofday(&e, NULL);
   
   printf("distance: %li\n", (e.tv_sec - t->tv_sec) * 1000000 + (e.tv_usec - t->tv_sec));
   
   CLOSE(source);
   INPUT_REMOVE(input);
}

void start_ping(unsigned long ip) {
   struct protoent *proto;
   struct sockaddr_in whereto;
   int sock;
   
   proto = getprotobyname("icmp");
   
   sock = socket(AF_INET, SOCK_RAW, proto->p_proto);   
   if (sock < 0) {
      perror("ping: socket");
      return;
   }
   
   memset(&whereto, 0, sizeof(whereto));
   whereto.sin_family = AF_INET;
   whereto.sin_addr.s_addr = ip;
   
   if (send_ping(sock, whereto) > 0)
     input = INPUT_ADD(sock, GDK_INPUT_READ, read_ping, OUTPACK_TIME);
}

static guint16 in_cksum(guint16 *addr, int len) {
   int nleft = len;
   guint16 *w = addr;
   guint32 sum = 0;
   guint16 answer = 0;
   
   while(nleft > 1) {
      sum += *w++;
      nleft -= 2;
   }
   
   if (nleft == 1) {
      answer = 0;
      *(guint8 *)(&answer) = *(guint8 *)w;
      sum += answer;
   }
   
   sum = (sum >> 16) + (sum & 0xffff);
   sum += (sum >> 16);
   answer = ~sum;
   
   return answer;
}

int send_ping(int sock, struct sockaddr_in *whereto) {
   struct icmp *icp;
   struct timeval t;
   size_t packlen;
   int sentlen;
   
   icp = OUTPACK_ICMP;
   icp->icmp_type = ICMP_ECHO;
   icp->icmp_code = 0;
   icp->icmp_cksum = 0;
   icp->icmp_seq = 0;
   icp->icmp_id = whereto->sin_addr.s_addr & 0xFFFF;

   gettimeofday(&t, NULL);
   memcpy(OUTPACK_TIME, &t, sizeof(t));
   
   packlen = datalen + (OUTPACK_PAYLOAD - outpack);
   
   icp->icmp_cksum = in_cksum((unsigned short *)outpack, packlen);
   
   sentlen = sendto(sock, outpack, packlen, 0, 
		    (struct sockaddr *)whereto, sizeof(struct sockaddr_in));
   
   if (sentlen != (int)packlen) {
      perror("sendto");
      return -1;
   }
   
   return sentlen;
}
*/
